/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.parseArgument;

import java.util.List;

import circusRefine.core.util.ChildrenTermExtractor;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.visitor.NameVisitor;

/**
 * Um Visitor para retornar um Name a partir da AST. Usado no parse
 *  de Argumentos
 *  
 * @author Cristiano Gurgel
 */
public class NameGetter implements TermVisitor<Name>, 
		NameVisitor<Name> {

	/**
	 * Retorna um Name a partir de uma AST, usando, para isso, uma
	 *  instncia de {@link NameGetter}.
	 * 
	 * @param ast a AST a ser visitada
	 * @return um Name contido na AST
	 */
	public static Name getAName(Term ast) {
		NameGetter getter = new NameGetter();
		return ast.accept(getter);
	}
	
	/**
	 * Construtor Padro.
	 */
	public NameGetter() { }
	
	/**
	 * Percorre a rvore procurando uma instncia de {@link Name}.
	 * 
	 * @param arg0 a AST a ser visitada.
	 * @return o {@link Name} encontrado na rvore ou 
	 * 	<code>null</code> caso esse no seja encontrado.
	 */
	public Name visitTerm(Term arg0) {
		List<Term> filhos = ChildrenTermExtractor.extrairFilhos(arg0);
		
		for (Term filho : filhos) {
			Name result = filho.accept(this);
			if (result != null) {
				return result;
			}
		}
		
		/* No encontrei a Name na Ast*/
		return null;
	}

	/**
	 * Caso encontre uma instncia de Name, ento o mesmo  
	 * 	retornado
	 * 
	 * @param arg0 o Name a ser visitado.
	 * @return o Name encontrado
	 */
	public Name visitName(Name arg0) {
		return arg0;
	}

}
