/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.messages;

import java.util.MissingResourceException;

import circusRefine.core.crules.CRulesException;

/**
 * Excesso gerada quando uma chave invlida  passada para uma 
 * mensagem ao usurio
 * 
 * @author Cristiano Castro
 */
public class CRulesMissingMessageException extends CRulesException {

	/** Nmero para a serializao */
	private static final long serialVersionUID = -147271548882778011L;

	/**
	 * Construtor com a excesso de falta de mensagem.
	 * 
	 * @param e a falha de mensagem que causou a excesso
	 */
	public CRulesMissingMessageException(MissingResourceException e) {
		super(e);
	}
	
}
