/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.CircusChannelSet;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.SkipAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.ast.VarDeclCommand;
import net.sourceforge.czt.circus.impl.SeqActionImpl;
import net.sourceforge.czt.circus.impl.VarDeclCommandImpl;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.ExprList;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.impl.ConstDeclImpl;
import net.sourceforge.czt.z.impl.VarDeclImpl;
import net.sourceforge.czt.z.util.Factory;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerName;
import circusRefine.core.InternalManager;
import circusRefine.core.astmodifiers.ActionArgumentAnn;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.util.Internacional;

/**
 * F�brica das leis que atuam sobre Blocos de Vari�veis
 * 
 * @author Cristiano Castro
 */
public class VariableBlocksLawsFactory extends ActionLawsFactory {

	/**
	 * Inicia a f�brica com o objeto para internacionaliza��o
	 * 
	 * @param inter o objeto de onde se retiram as mensagens para
	 *  internacionaliza��o
	 */
	public VariableBlocksLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter,gerInt);
	}

	/**
	 * Cria o nome da lei baseado no tipo da f�brica
	 * 
	 * @param codName c�digo para o nome da lei
	 */
	protected String createName(String codName) {
		return this.retornarMsg(
				LawType.ACTION_REFINEMENT_VARIABLE_BLOCKS, codName);
	}

	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();

		result.add(criarLeiJoinBlocks());

		
		return result;
	}



	public CircusLaw criarLeiJoinBlocks() {

		/* Criando o LHS da lei 

		 * \circvar\ x: T_1 @ \circvar\ y: T_2 @ A = 
		 * \circvar\ x:T_1; y: T_2 @ A$ 
		 */

        Factory f = new Factory();
       
       // DeclList dl1 = factory.createJokerDeclList("x", null);
        JokerDeclList d1 = factory.createJokerDeclList("x", null);
        JokerDeclList d2 = factory.createJokerDeclList("y", null);
        //DeclList d2 = factory.createJokerDeclList("y", null);
        JokerAction a1 = factory.createJokerAction("A", null);
        
        
        VarDeclCommand var1 = factory.createVarDeclCommand();
        var1.setDeclList(d1);
        var1.setCircusAction(a1);
        
        
       // VarDeclCommand left = factory.createVarDeclCommand();
       //.setDeclList(d2);
       // left.setCircusAction(a1);
        
/*        ZDeclList lista = factory.createZDeclList();
        ZDeclList listZD = var1.getZDeclList();
		for (Decl decl : listZD) {
			lista.add(decl);
		}*/
        
		//DeclList listZD2 = left.getDeclList();
		//for (Decl decl : listZD2) {
		//	lista.add(listZD2);
		//}
        
        
        ZDeclList list = factory.createZDeclList();
        //list.add(dl1);
        //list.add(dl2);
        //list.add(dl1);
               
		//ZDeclList list = f.createZDeclList();
		VarDecl xdecl = f.createVarDecl();
		VarDecl ydecl = f.createVarDecl();
		//xdecl = (VarDecl) d1;
		//ydecl = (VarDecl) d2;
		
		
		
		ZName x = f.createZName(d1.getName(), f.createZStrokeList(), null);
		ZName y = f.createZName(d2.getName(), f.createZStrokeList(), null);
		xdecl.setNameList(f.createZNameList(Arrays.asList(x)));
		ydecl.setNameList(f.createZNameList(Arrays.asList(y)));
		xdecl.setExpr (null);
		ydecl.setExpr (null);
		ydecl.setExpr (f.createRefExpr (f.createZName ("T_2")));
		list.add(ydecl);
		list.add(xdecl);
		list.add(xdecl);
		list.add(ydecl);
		
	
        /* LEFT var x : T1 ² var y : T2 ² A */
		

	
		ZDeclList listX = factory.createZDeclList();
		listX.add(xdecl);
		ZDeclList listY = factory.createZDeclList();
		listY.add(ydecl);

		//VarDeclCommand varAc = factory.createVarDeclCommand(Arrays.asList(d1,d2), a1);
		VarDeclCommand left = factory.createVarDeclCommand(listX, var1);


		/* Parte direita  
		 * var x : T1; y : T2 ² A*/
		

		VarDeclCommand rigth = factory.createVarDeclCommand(list, a1);

		/*Criando o transformer*/ 
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left,rigth));

		/* Criando a Obrigacao de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("JoinBlocks");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1005", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_VARIABLE_BLOCKS);

		return result;
	} 

	/*public CircusLaw criarLeiVarExpSeq() {

		 Criando o LHS da lei 
		 /* 
		 * A1 \circseq \circvar\ x: T_1 @ A2) \circseq A2 = 
		 * \circvar\ x:T_1 @ A1 \circseq A2 \circseq A3 
		 
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerAction a3 = factory.createJokerAction("A3", null);
		DeclList x = factory.createJokerDeclList("x", null);
		

		VarDeclCommand var = factory.createVarDeclCommand(x, a2);
		SeqAction left1 = factory.createSeqAction(Arrays.asList(var,a3));
		SeqAction left = factory.createSeqAction(Arrays.asList(a1,left1));
		
		 Parte direita 

		 Criando o Seq 
		SeqAction seq2 = factory.createSeqAction(Arrays.asList(a2,a3));
		SeqAction seq3 = factory.createSeqAction(Arrays.asList(a1,seq2));
		
		VarDeclCommand right = factory.createVarDeclCommand(x, seq3);

		 Criando o transformer 
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		 Criando a Obriga��o de prova 
		List<Pred> ops = new ArrayList<Pred>();
		
		Criando as OPS

		RefExpr funFv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Action);
		 ListaArgumentos da fun��oUsedC 
		RefExpr argFVA = this.getFactory().createRefExpr();
		argFVA.getAnns().add(new ActionArgumentAnn(a1));
		
	
		 Aplicacao FV_Action 1 
		ApplExpr applFVA = 
			this.getFactory().createApplExpr(Arrays.asList(funFv, 
					argFVA), false);
		
		RefExpr funFv2 = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Action);
		 ListaArgumentos da fun��oUsedC 
		RefExpr argFVA2 = this.getFactory().createRefExpr();
		argFVA2.getAnns().add(new ActionArgumentAnn(a3));
		
		 Aplicacao FV_Action 2 
		ApplExpr applFVA2 = 
			this.getFactory().createApplExpr(Arrays.asList(funFv2, 
					argFVA2), false);

		*//**
		 * Criar a Unicao
		 * FV(A1) U FV(A3)
		 *//*
		
		 * Criando a Uniao
		 
		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);
		
		 Lista de argumentos da uniao 
		ZExprList listaUniao2 = 
			this.getFactory().createZExprList
			(Arrays.asList(applFVA,applFVA2));
		TupleExpr argsUniao2 = 
			this.getFactory().createTupleExpr(listaUniao2);

		 Aplica��o da uniao 
		ApplExpr applUniao = 
			this.getFactory().createApplExpr(Arrays.asList(funUniao, 
					argsUniao2), true);

		Criando a intersecao 
		ZName nomeIntersecao = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funIntersecao = this.getFactory().createRefExpr(nomeIntersecao, 
				this.getFactory().createZExprList(), false, false);

		 Lista de argumentos da intersecao 
		ZSchText textoDl = this.getFactory().createZSchText(x, 
				null);
		SchExpr argS1Stroke = this.getFactory().createSchExpr(textoDl);

		JokerName x2 = factory.createJokerName("x", null);
		//RefExpr refX = factory.createRefExpr(x2, factory.createZExprList(), false, false);

		ExprList exprs = factory.createZExprList(Arrays.asList(argS1Stroke));
		SetExpr listX = factory.createSetExpr(exprs);
		
		ConstDecl con = factory.createConstDecl();
		con.getExpr();
		
		//t(Arrays.asList(c1Expr,c2Expr));
				
		Intersecao 
		
		ZExprList listaArgsIntersecao = 
			this.getFactory().createZExprList(Arrays.asList(argS1Stroke,applUniao));
		TupleExpr argsIntersecao = 
			this.getFactory().createTupleExpr(listaArgsIntersecao);

		 Aplicacao da intersecao 
		ApplExpr applIntersecao1 = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsIntersecao), true);

		 Monta a referencia ao conjunto vazio 
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		 Monta o conjunto unit�rio do conjunto vazio 
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		 Monta o segundo predicado 
		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(applIntersecao1, 
					conjuntoUnitarioDoConjuntoVazio), true);

		ops.add(op1);

		 Criando a Lei 
		String nome = this.createName("VarExpSeq");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1008", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_VARIABLE_BLOCKS);

		return result;
	} */

}
