/*
 * Projeto: Circus Refine
 * Autor: Cristiano Castro
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.ChaosAction;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusFieldList;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.CommUsage;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.ExtChoiceActionIte;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.SchExprAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.StopAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.ast.VarDeclCommand;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerCommunication;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import circusRefine.core.InternalManager;
import circusRefine.core.crules.LawDefinitionAnn;
import circusRefine.core.crules.anotations.SchemaExpressionsAnn;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.util.Internacional;

/**
 * util para a criação das leis de simulação
 * 
 * @author crisgc
 *
 */
public class SimulationLawsFactory extends ActionLawsFactory {
	
	public SimulationLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new ArrayList<CircusLaw>();
		
		/* C.1 */
    	result.add(this.criarLeiSkip());
    	
    	/* C.2 Stop */
    	result.add(this.criarLeiStop());
    	
    	/* C.3 Chaos */
    	result.add(this.createLawChaos());
    	
    	/* C.4 */
    	result.add(this.createSchemasExpressions());
    	
    	/* C-5 */
    	result.add(this.createLawPrefixDistribution());
    	
    	/* C-8 */
    	result.add(this.createLawInputPrefixDistribution());
    	
    	
    	/* C-11 */
    	result.add(this.criarLeiGuardDistribution());
    	
    	/* C-12 */
    	result.add(this.createLawSequenceDistribution());
    	
    	/* C-13 External Choice Distribution */
    	result.add(this.createLawExternalChoiceDistribution());

		/* C-14 */
		result.add(this.criarLeiExternalChoicePrefixDistribution()); 
		
		/* C-20 */
		result.add(this.createLawInternalChoiceDistribution());
		
		/* C-23 */
    	result.add(this.criarLeiRecursionDistribution());
    	
    	/* C-25 */
    	result.add(this.createLawVariableBlockDistribution());
		return result;
	}

	protected String createName(String codName) {
		return this.retornarMsg(LawType.SIMULATION_, codName);
	}

	
	
	public CircusLaw criarLeiGuardDistribution(){

		JokerPred ag = factory.createJokerPred("ag", null);
		JokerPred cg = factory.createJokerPred("cg", null);

		JokerAction A1 = factory.createJokerAction("A1", null);
		JokerAction A2 = factory.createJokerAction("A2", null);

		//LADO DIREITO
		GuardedAction right = factory.createGuardedAction(A2, cg);  

		//LADO ESQUERDO
		GuardedAction left = factory.createGuardedAction(A1, ag);

		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Simulation, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obrigações de prova */
		List<Pred> ops = new ArrayList<Pred>();

		//Falta a 1ª Obrigação
		JokerPred pred1 = factory.createJokerPred("\\forall ASState; CSState @ " +
				"\\ag \\implies \\cg", null);
		
		ops.add(pred1);

		ActionTransformerPred pred = factory.createActionTransformerPred(null, 
				Transformation.Simulation,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(A1, A2));		
		ops.add(pred);

		/* Criando a Lei */
		String nome = this.createName("GuardDistribution");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans,ops);

		LawNumberAnn id = new LawNumberAnn("C.11", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result,LawType.SIMULATION_);

		return result;
	}

	
	
    /**
     * Cria a lei Skip (C.1)
     * 
     * @return a Nova Lei Circus
     */
    public CircusLaw criarLeiSkip() {
    	CircusAction left = factory.createSkipAction();
    	CircusAction right = factory.createSkipAction();
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Simulation,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	String nome = this.createName("COD0475");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			new ArrayList<Pred>());

    	LawNumberAnn id = new LawNumberAnn("C.1", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.SIMULATION_);
    	return result;
    	
    }
    
    /**
     * Cria a lei Stop (C.2)
     * 
     * @return a Nova Lei Circus
     */
    public CircusLaw criarLeiStop() {
    	StopAction left = factory.createStopAction();
    	StopAction right = factory.createStopAction();
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Simulation,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	String nome = this.createName("COD0639");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			new ArrayList<Pred>());

    	LawNumberAnn id = new LawNumberAnn("C.2", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.SIMULATION_);
    	return result;
    	
    }
    
    /**
     * Cria a lei Chaos (C.3)
     * 
     * @return a Nova Lei Circus
     */
    public CircusLaw createLawChaos() {
    	ChaosAction left = factory.createChaosAction();
    	ChaosAction right = factory.createChaosAction();
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Simulation,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	String nome = this.createName("COD0640");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			new ArrayList<Pred>());

    	LawNumberAnn id = new LawNumberAnn("C.3", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.SIMULATION_);
    	return result;
    	
    }
    
    /**
     * Criando Lei Schemas Expressions (C.4)
     * 
     * @return a nova Lei Circus
     */
    public CircusLaw createSchemasExpressions() {
    	
    	/* Criando o LHS da lei */
    	JokerExpr exp1 = this.getFactory().createJokerExpr("ASExp", 
    			null);
    	SchExprAction left = 
    		this.getFactory().createSchExprAction(exp1);
    	
    	/* Criando o RHS da lei */
    	
    	JokerAction right  = this.getFactory().createJokerAction("CSExpr", null);
    	
    	/* Criando o transformer */
    	
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Simulation,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/* OP 1 - */
    	JokerPred pred1 = factory.createJokerPred("\\forall ASState; CSState @ " +
    			"\\pre ASExpr \\implies \\pre CSExpr", null);
    	
    	JokerPred pred2 = factory.createJokerPred("\\forall ASState; CSState;"
    			+"CSState' @ R \\land \\pre ASState \\land CSExpr \\implies\n         "+
    			" (\\exists ABSState'@ R' \\land ASExpr )", null);
    	
    	
    	/* Adicionando a anotação */
    	right.getAnns().add(new SchemaExpressionsAnn(exp1,right,pred1,pred2));
    	
    	ops.add(pred1);
    	ops.add(pred2);
    	
    	/* Criando a Lei */
    	String nome = this.createName("SchemaExpressionsLaw");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			ops);

    	LawNumberAnn id = new LawNumberAnn("C.4", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.SIMULATION_);
    	
    	String[] obs = new String[1];
    	obs[0] = "The user must input the name of abstract state, the concrete one\n" +
    			"and the name of the retrieve relation. The abstract operation must\n" +
    			"have the abstract state declared; On the other hand, the concrete one must\n" +
    			"have the concrete state in its declaration.";
    	
    	LawDefinitionAnn annDetails = new LawDefinitionAnn(obs,null,null,null);
    	
    	result.getAnns().add(annDetails);
    	
    	return result;
    }
    
    
    
    /**
     * Criando Lei Prefix Distribution (C.5)
     * 
     * @return a nova Lei Circus
     */
    public CircusLaw createLawPrefixDistribution() {
    	
    	/* Criando o LHS da lei */
    	JokerCommunication c = factory.createJokerCommunication(null, null, 
    			null, null, null, null, "c", null);
    	JokerAction l = factory.createJokerAction("A1", null);
    	PrefixingAction left = factory.createPrefixingAction(l, c);
    	
    	/* Criando o RHS da lei */
    	JokerAction r = factory.createJokerAction("A2", null);
    	PrefixingAction right = factory.createPrefixingAction(r, c);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Simulation,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	/* Criando a Obriga��o de prova */
    	ActionTransformerPred op = factory.createActionTransformerPred(null, 
    			Transformation.Simulation, CircusUtils.DEFAULT_REFINEMENT_MODEL,
    			Arrays.asList(l, r));
    	List<Pred> ops = new ArrayList<Pred>();
    	ops.add(op);
    	
    	/* Criando a Lei */
    	String nome = this.createName("COD0476");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			ops);

    	LawNumberAnn id = new LawNumberAnn("C.5", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.SIMULATION_);
    	
    	return result;
    }
    
    
    
    /**
     * Criando Lei Input Prefix Distribution (C.8)
     * 
     * @return a nova Lei Circus
     */
    public CircusLaw createLawInputPrefixDistribution() {
    	
    	/* Criando o LHS da lei */
    	JokerName nomeX = this.factory.createJokerName("x", null);
		InputField inX = this.factory.createInputField(nomeX, 
				this.factory.createTruePred());
		CircusFieldList listaInX = 
			this.factory.createCircusFieldList(Arrays.asList(inX));
		JokerName nomeC = this.factory.createJokerName("c", null);
		RefExpr c = this.factory.createRefExpr(nomeC, 
				this.factory.createZExprList(), false, false);
		Communication cInX = this.factory.createCommunication(c, listaInX, 
				CommUsage.Normal, CommPattern.Input, null, null);
		
    	JokerAction l = factory.createJokerAction("A1", null);
    	PrefixingAction left = factory.createPrefixingAction(l, cInX);
    	
    	/* Criando o RHS da lei */
    	JokerAction r = factory.createJokerAction("A2", null);
    	PrefixingAction right = factory.createPrefixingAction(r, cInX);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Simulation,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	/* Criando a Obriga��o de prova */
    	ActionTransformerPred op = factory.createActionTransformerPred(null, 
    			Transformation.Simulation, CircusUtils.DEFAULT_REFINEMENT_MODEL,
    			Arrays.asList(l, r));
    	List<Pred> ops = new ArrayList<Pred>();
    	ops.add(op);
    	
    	/* Criando a Lei */
    	String nome = this.createName("COD0666");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			ops);

    	LawNumberAnn id = new LawNumberAnn("C.8", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.SIMULATION_);
    	
    	return result;
    }
    
    
    /**
     * Criando Lei C.12 (Sequence distribution)
     * 
     * @return a nova Lei Circus
     */
    public CircusLaw createLawSequenceDistribution() {
    	
    	/* Criando o LHS da lei */
    	JokerAction a1 = this.factory.createJokerAction("A_1", null);
    	JokerAction a2 = this.factory.createJokerAction("A_2", null);
    	SeqAction left = this.factory.createSeqAction(Arrays.asList(a1, a2));
    	
    	/* Criando o RHS da lei */
    	JokerAction b1 = this.factory.createJokerAction("B_1", null);
    	JokerAction b2 = this.factory.createJokerAction("B_2", null);
    	SeqAction right = this.factory.createSeqAction(Arrays.asList(b1, b2));
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Simulation,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	/* Criando a Obriga��o de prova */
    	ActionTransformerPred op1 = factory.createActionTransformerPred(null, 
    			Transformation.Simulation, CircusUtils.DEFAULT_REFINEMENT_MODEL,
    			Arrays.asList(a1, b1));
    	ActionTransformerPred op2 = factory.createActionTransformerPred(null, 
    			Transformation.Simulation, CircusUtils.DEFAULT_REFINEMENT_MODEL,
    			Arrays.asList(a2, b2));
    	List<Pred> ops = new ArrayList<Pred>();
    	ops.add(op1);
    	ops.add(op2);
    	
    	/* Criando a Lei */
    	String nome = this.createName("COD0641");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			ops);

    	LawNumberAnn id = new LawNumberAnn("C.12", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.SIMULATION_);
    	
    	return result;
    }
    
    /**
     * Criando Lei C.13 (External Choice Distribution)
     * 
     * @return a nova Lei Circus
     */
    public CircusLaw createLawExternalChoiceDistribution() {
    	
    	/* Criando o LHS da lei */
    	JokerAction a1 = this.factory.createJokerAction("A_1", null);
    	JokerAction a2 = this.factory.createJokerAction("A_2", null);
    	ExtChoiceAction left = 
    		this.factory.createExtChoiceAction(Arrays.asList(a1, a2));
    	
    	/* Criando o RHS da lei */
    	JokerAction b1 = this.factory.createJokerAction("B_1", null);
    	JokerAction b2 = this.factory.createJokerAction("B_2", null);
    	ExtChoiceAction right = 
    		this.factory.createExtChoiceAction(Arrays.asList(b1, b2));
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Simulation,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	/* Criando a Obriga��o de prova */
    	ActionTransformerPred op1 = factory.createActionTransformerPred(null, 
    			Transformation.Simulation, CircusUtils.DEFAULT_REFINEMENT_MODEL,
    			Arrays.asList(a1, b1));
    	ActionTransformerPred op2 = factory.createActionTransformerPred(null, 
    			Transformation.Simulation, CircusUtils.DEFAULT_REFINEMENT_MODEL,
    			Arrays.asList(a2, b2));
    	List<Pred> ops = new ArrayList<Pred>();
    	ops.add(op1);
    	ops.add(op2);
    	
    	/* Criando a Lei */
    	String nome = this.createName("COD0642");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			ops);

    	LawNumberAnn id = new LawNumberAnn("C.13", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.SIMULATION_);
    	
    	return result;
    }

    /**
     * Cria a Lei <i>External choice/Prefix distribution</i> (C-14).
     * 
     * @return a nova lei Circus
     */
    public CircusLaw criarLeiExternalChoicePrefixDistribution() {
    	
    	/* Criando o LHS da lei */
    	JokerDeclList i = factory.createJokerDeclList("i", null);
    	JokerAction a = factory.createJokerAction("A", null);
    	JokerCommunication c = factory.createJokerCommunication(null, null, 
    			null, CommPattern.Synch, null, null, "c", null);
    	PrefixingAction act1 = factory.createPrefixingAction(a, c);
    	ExtChoiceActionIte left = factory.createExtChoiceActionIte(act1, i);
    	
    	/* Criando o RHS da lei */
    	JokerAction b = factory.createJokerAction("B", null);
    	PrefixingAction act2 = factory.createPrefixingAction(b, c);
    	ExtChoiceActionIte right = factory.createExtChoiceActionIte(act2, i);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Simulation,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	
    	/*
    	 * *************************************** *
    	 * OP1: \forall i @ A_i \circsimulates B_i *
    	 * *************************************** *
    	 */
    	
    	String op1 = ZString.ALL + "i" + ZString.DOT + " " + 
    	"Ai " + CircusString.CIRCSIMULATES + " Bi";
    	
    	ArrayList<String> opLista = new ArrayList<String>();
    	opLista.add(op1);
    	LawDefinitionAnn opAnn = new LawDefinitionAnn(null, opLista, null,null);
    	
    	
    	
    	/* Montando � refer�ncia ao "i" */
    	/*ZSchText schemaI = this.getFactory().createZSchText(i, 
    			this.getFactory().createTruePred());*/
    	
    	/* Montando � refer�ncia "A_i \circsimulates B_i" */
    	/*ActionTransformerPred aICircsimulatesBi = 
    		this.getFactory().createActionTransformerPred(null, 
    				Transformation.Simulation, 
    				CircusUtils.DEFAULT_REFINEMENT_MODEL, Arrays.asList(a, b));*/
    	
    	/* Criando a OP1 */
    	/*ForallPred op1 = this.getFactory().createForallPred(schemaI, 
    			aICircsimulatesBi);*/
    	
    	/* Adicionando a OP1 */
    	/*ops.add(op1);*/
    	
    	/* Criando a Lei */
    	String nome = this.createName("COD0493");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

    	/* Adicionando Law Definition-OP*/
    	result.getAnns().add(opAnn);
    	
    	LawNumberAnn id = new LawNumberAnn("C-14", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.SIMULATION_);
    	
    	return result;
    }
    
    /**
     * Criando Lei C.20 (Internal Choice Distribution)
     * 
     * @return a nova Lei Circus
     */
    public CircusLaw createLawInternalChoiceDistribution() {
    	
    	/* Criando o LHS da lei */
    	JokerAction a1 = this.factory.createJokerAction("A_1", null);
    	JokerAction a2 = this.factory.createJokerAction("A_2", null);
    	IntChoiceAction left = 
    		this.factory.createIntChoiceAction(Arrays.asList(a1, a2));
    	
    	/* Criando o RHS da lei */
    	JokerAction b1 = this.factory.createJokerAction("B_1", null);
    	JokerAction b2 = this.factory.createJokerAction("B_2", null);
    	IntChoiceAction right = 
    		this.factory.createIntChoiceAction(Arrays.asList(b1, b2));
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Simulation,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	/* Criando a Obriga��o de prova */
    	ActionTransformerPred op1 = factory.createActionTransformerPred(null, 
    			Transformation.Simulation, CircusUtils.DEFAULT_REFINEMENT_MODEL,
    			Arrays.asList(a1, b1));
    	ActionTransformerPred op2 = factory.createActionTransformerPred(null, 
    			Transformation.Simulation, CircusUtils.DEFAULT_REFINEMENT_MODEL,
    			Arrays.asList(a2, b2));
    	List<Pred> ops = new ArrayList<Pred>();
    	ops.add(op1);
    	ops.add(op2);
    	
    	/* Criando a Lei */
    	String nome = this.createName("COD0643");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			ops);

    	LawNumberAnn id = new LawNumberAnn("C.20", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.SIMULATION_);
    	
    	return result;
    }

    /**
     * Cria a Lei <i>Recursion Distribution</i> (C-23).
     * 
     * @return a nova lei Circus
     */
    public CircusLaw criarLeiRecursionDistribution() {
    	
    	/* Criando o LHS da lei */
    	JokerName x = factory.createJokerName("X", null);
    	JokerAction fA = factory.createJokerAction("Fa", null);
    	MuAction left = factory.createMuAction(fA, x);
    	
    	/* Criando o RHS da lei */
    	JokerAction fC = factory.createJokerAction("Fc", null);
    	MuAction right = factory.createMuAction(fC, x);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Simulation,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));

    	/* Criando as obriga��es de prova */
    	List<Pred> ops = new ArrayList<Pred>();
    	ActionTransformerPred op1 = factory.createActionTransformerPred(null, 
    			Transformation.Simulation, CircusUtils.DEFAULT_REFINEMENT_MODEL,
    			Arrays.asList(fA, fC));
    	ops.add(op1);
    	
    	/* Criando a Lei */
    	String nome = this.createName("COD0501");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

    	LawNumberAnn id = new LawNumberAnn("C-23", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.SIMULATION_);
    	
    	return result;
    }
    
    /**
     * Cria a Lei <i>Recursion Distribution</i> (C-23).
     * 
     * @return a nova lei Circus
     */
    public CircusLaw createLawVariableBlockDistribution() {
    	
    	/* Criando o LHS da lei */
    	JokerDeclList dl = this.factory.createJokerDeclList("x", null);
    	JokerAction a1 = this.factory.createJokerAction("A_1", null);
    	VarDeclCommand left = this.factory.createVarDeclCommand(dl, a1);
    	
    	/* Criando o RHS da lei */
    	JokerAction b1 = this.factory.createJokerAction("B_1", null);
    	VarDeclCommand right = this.factory.createVarDeclCommand(dl, b1);
    	
    	/* Criando o transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Simulation,
    			CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	/* Criando a Obriga��o de prova */
    	ActionTransformerPred op1 = factory.createActionTransformerPred(null, 
    			Transformation.Simulation, CircusUtils.DEFAULT_REFINEMENT_MODEL,
    			Arrays.asList(a1, b1));
    	List<Pred> ops = new ArrayList<Pred>();
    	ops.add(op1);
    	
    	/* Criando a Lei */
    	String nome = this.createName("COD0644");
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			ops);

    	LawNumberAnn id = new LawNumberAnn("C.25", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, LawType.SIMULATION_);
    	
    	return result;
    }

}
