/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.ast.VarDeclCommand;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.DecorExpr;
import net.sourceforge.czt.z.ast.ExprList;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.NameList;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerName;
import circusRefine.core.InternalManager;
import circusRefine.core.astmodifiers.ActionArgumentAnn;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.util.Internacional;

/**
 * F�brica das leis que atuam sobre Sequ�ncias
 * 
 * @author Cristiano Castro
 */
public class SequenceLawsFactory extends ActionLawsFactory {

	/**
	 * Inicia a f�brica com o objeto para internacionaliza��p
	 * 
	 * @param inter o objeto de onde se retiram as mensagens para
	 *  internacionaliza��o
	 */
	public SequenceLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	/**
	 * Retorna o nome composto para a lei circus
	 * 
	 * @param cod o c�digo para o nome da lei
	 * @return uma String com o nome constru�do da lei
	 */
	protected String createName(String cod) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_SEQUENCE, cod);
	}

	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();

		/*
		 * C.132 a C.134
		 */
		result.add(criarLeiSequenceUnit());
		result.add(criarLeiSequenceUnitpart2());
		result.add(criarLeiSequenceZero());
		result.add(criarLeiSequenceZero2());
		
		result.add(this.createLawSequenceAssociativity());
		
		result.add(criarLeiSequenceUnitpart1_2());

		result.add(criarLeiVarExpSeq());
		return result;
	}

	
	/**
	 * Cria Uma lei <i>Sequence Zero</i> (C-132) 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiSequenceUnit() {

		JokerAction a = factory.createJokerAction("A", null);
		/*
		 * LHS
		 */
		SeqAction left = factory.createSeqAction(Arrays.asList(
				a, factory.createSkipAction()));

		// Criando o Transformer 
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, a));
		
		/*SeqAction right = factory.createSeqAction(Arrays.asList(
				a, factory.createSkipAction()));

		// Criando o Transformer 
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(a, right));*/

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		String nome = this.createName("COD0746");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.132_01", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_SEQUENCE);

		return result;
	}
	
	/**
	 * Cria Uma lei <i>Sequence Zero</i> (C-132) 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiSequenceUnitpart2() {

		JokerAction a = factory.createJokerAction("A", null);
		/*
		 * LHS
		 */
		SeqAction left = factory.createSeqAction(Arrays.asList(
				factory.createSkipAction(),a));
		
		/*SeqAction right = factory.createSeqAction(Arrays.asList(
				factory.createSkipAction(),a));*/

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, a));
		
	/*	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(a,right));*/

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		String nome = this.createName("COD0747");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.132_02", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_SEQUENCE);

		return result;
	}
	
	
	public CircusLaw criarLeiSequenceUnitpart1_2() {

		JokerAction a = factory.createJokerAction("A", null);
		/*
		 * LHS
		 */
		SeqAction left = factory.createSeqAction(Arrays.asList(
				a,factory.createSkipAction()));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, a));

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		String nome = this.createName("Sequence_Unit_Part_12");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.1011", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_SEQUENCE);

		return result;
	}
	
	

	/**
	 * Cria Uma lei <i>Sequence Zero</i> (C-133) 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiSequenceZero() {

		JokerAction a = factory.createJokerAction("A", null);
		/*
		 * LHS
		 */
		SeqAction left = factory.createSeqAction(Arrays.asList(
				factory.createStopAction(),a));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, factory.createStopAction()));

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		String nome = this.createName("COD0713");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.133", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_SEQUENCE);

		return result;
	}
	
	
	/**
	 * Cria Uma lei <i>Sequence Zero2</i> (C-134) 
	 * 
	 * @return a nova CircusActionLaw
	 */
	public CircusLaw criarLeiSequenceZero2() {

		JokerAction a = factory.createJokerAction("A", null);
		/*
		 * LHS
		 */
		SeqAction left = factory.createSeqAction(Arrays.asList(
				factory.createChaosAction(),a));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, factory.createChaosAction()));

		/* Criando Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		String nome = this.createName("COD0714");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				list);

		LawNumberAnn id = new LawNumberAnn("C.134", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_SEQUENCE);

		return result;
	}


	/**
	 * Cria a lei Associatividade de sequencia.
	 * <code>A \circseq (B \circseq C) = 
	 * (A \circseq B) \circseq C</code>
	 * 
	 * @return a nova lei de circus
	 */
	public CircusLaw createLawSequenceAssociativity() {

		/* LHS */
		JokerAction a = 
			this.getFactory().createJokerAction("A", null);
		JokerAction b = 
			this.getFactory().createJokerAction("B", null);
		JokerAction c = 
			this.getFactory().createJokerAction("C", null);
		SeqAction bSeqC = 
			this.getFactory().createSeqAction(Arrays.asList(b, c));
		SeqAction left = 
			this.getFactory().createSeqAction(Arrays.asList(a, 
					bSeqC));

		/* RHS */
		SeqAction aSeqB = 
			this.getFactory().createSeqAction(Arrays.asList(a, b));
		SeqAction right = 
			this.getFactory().createSeqAction(Arrays.asList(aSeqB, 
					c));

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new ArrayList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0590");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("SequenceAssociativity", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_SEQUENCE);

		return result;
	}
	
	public CircusLaw criarLeiVarExpSeq() {

		/* Criando o LHS da lei 
		 /* 
		 * A1 \circseq \circvar\ x: T_1 @ A2) \circseq A3 = 
		 * \circvar\ x:T_1 @ A1 \circseq A2 \circseq A3 
		 */
		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);
		JokerAction a3 = factory.createJokerAction("A3", null);
		
		DeclList x = factory.createJokerDeclList("x", null);


		/*
		 * Nova parte para tentar criar 
		 * o {x,x'}
		 * 
		 */
		
/*		ZName z = factory.createZName("x",factory.createZStrokeList(),null);
		ZNameList frame = this.getFactory().createZNameList();
		frame.add(z);
		ZDeclList list = factory.createZDeclList();
		VarDecl xdecl = factory.createVarDecl();
		xdecl.setNameList(frame);*/

		VarDeclCommand var = factory.createVarDeclCommand(x, a2);
		SeqAction left1 = factory.createSeqAction(Arrays.asList(var,a3));
		SeqAction left = factory.createSeqAction(Arrays.asList(a1,left1));
		
		/* Parte direita */

		/* Criando o Seq */
		SeqAction seq2 = factory.createSeqAction(Arrays.asList(a2,a3));
		SeqAction seq3 = factory.createSeqAction(Arrays.asList(a1,seq2));
		
		VarDeclCommand right = factory.createVarDeclCommand(x, seq3);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence,
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando a Obriga��o de prova */
		List<Pred> ops = new ArrayList<Pred>();
		
		/*Criando as OPS*/

		RefExpr funFv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Action);
		/* ListaArgumentos da fun��oUsedC */
		RefExpr argFVA = this.getFactory().createRefExpr();
		argFVA.getAnns().add(new ActionArgumentAnn(a1));
		
	
		/* Aplicacao FV_Action 1 */
		ApplExpr applFVA = 
			this.getFactory().createApplExpr(Arrays.asList(funFv, 
					argFVA), false);
		
		RefExpr funFv2 = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Action);
		/* ListaArgumentos da fun��oUsedC */
		RefExpr argFVA2 = this.getFactory().createRefExpr();
		argFVA2.getAnns().add(new ActionArgumentAnn(a3));
		
		/* Aplicacao FV_Action 2 */
		ApplExpr applFVA2 = 
			this.getFactory().createApplExpr(Arrays.asList(funFv2, 
					argFVA2), false);

		/**
		 * Criar a Unicao
		 * FV(A1) U FV(A3)
		 */
		/*
		 * Criando a Uniao
		 */
		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);
		
		/* Lista de argumentos da uniao */
		ZExprList listaUniao2 = 
			this.getFactory().createZExprList
			(Arrays.asList(applFVA,applFVA2));
		TupleExpr argsUniao2 = 
			this.getFactory().createTupleExpr(listaUniao2);

		/* Aplica��o da uniao */
		ApplExpr applUniao = 
			this.getFactory().createApplExpr(Arrays.asList(funUniao, 
					argsUniao2), true);

		/*Criando a intersecao */
		ZName nomeIntersecao = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funIntersecao = this.getFactory().createRefExpr(nomeIntersecao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da intersecao */
		//ZSchText textoDl = this.getFactory().createZSchText(x, 
		//		null);
		ZSchText textoDl = this.getFactory().createZSchText(x, 
				null);
		SchExpr argS1Stroke = this.getFactory().createSchExpr(textoDl);

		//JokerName x2 = factory.createJokerName("x", null);
		//RefExpr refX = factory.createRefExpr(x2, factory.createZExprList(), false, false);

		ExprList exprs = factory.createZExprList(Arrays.asList(argS1Stroke));
		SetExpr listX = factory.createSetExpr(exprs);
		
		ConstDecl con = factory.createConstDecl();
		con.getExpr();
		
		//t(Arrays.asList(c1Expr,c2Expr));
				
		/*Intersecao */
		
		ZExprList listaArgsIntersecao = 
			//this.getFactory().createZExprList(Arrays.asList(argS1Stroke,applUniao));
			this.getFactory().createZExprList(Arrays.asList(listX,applUniao));
		TupleExpr argsIntersecao = 
			this.getFactory().createTupleExpr(listaArgsIntersecao);

		/* Aplicacao da intersecao */
		ApplExpr applIntersecao1 = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsIntersecao), true);

		/* Monta a referencia ao conjunto vazio */
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		/* Monta o conjunto unit�rio do conjunto vazio */
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		/* Monta o segundo predicado */
		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(applIntersecao1, 
					conjuntoUnitarioDoConjuntoVazio), true);

		ops.add(op1);

		/* Criando a Lei */
		String nome = this.createName("VarExpSeq");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1110", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_SEQUENCE);

		return result;
	}

}
