/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.Arrays;
import java.util.List;

import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.util.ZString;

import circusRefine.core.InternalManager;
import circusRefine.util.Internacional;

/**
 * Classe base de todas as f�bricas das leis de Circus.
 * 
 * @author Cristiano Gurgel
 */
public abstract class LawsFactory {

    /**
     * M�todo utilit�rio para montar a refer�ncia do conjunto unit�rio 
     * do conjunto vazio
     * 
     * @return um conjunto unit�rio contendo o conjunto vazio
     */
    
	public static SetExpr montarConjuntoUnitarioDoConjuntoVazio() {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();

    	/* Monta a refer�ncia ao conjunto vazio */
    	ZName nomeConjuntoVazio = 
    		factory.createZName(ZString.EMPTYSET, 
    				factory.createZStrokeList(), null);
    	RefExpr conjuntoVazio = 
    		factory.createRefExpr(nomeConjuntoVazio, 
    				factory.createZExprList(), false, false);

    	/* Monta o conjunto unit�rio do conjunto vazio */
    	ZExprList listaComConjuntoVazio = 
    		factory.createZExprList(Arrays.asList(conjuntoVazio));
    	SetExpr conjuntoUnitarioDoConjuntoVazio = 
    		factory.createSetExpr(listaComConjuntoVazio);
    	
    	return conjuntoUnitarioDoConjuntoVazio;
    }
    	
	/** Fábrica utlizada para criar as classes das leis */
	protected CircusPatternFactory factory = 
		new CircusPatternFactoryImpl();

	public CircusPatternFactory getFactory() {
		return factory;
	}

	public void setFactory(CircusPatternFactory factory) {
		this.factory = factory;
	}

	/** O campo para permitir internacionalizacao das leis criadas */
	protected Internacional inter;

	protected String simulationType; 

	protected String actionRefinementType;

	protected String assumptionRefinementType;

	protected String guardsRefinementType;

	protected String parallelismRefinementType;

	protected String interleavingRefinementType;

	protected String prefixRefinementType;

	protected String externalChoiceRefinementType;

	protected String internalChoiceRefinementType;

	protected String hidingRefinementType;

	protected String recursionRefinementType;

	protected String sequenceRefinementType;

	protected String chaosRefinementType;

	protected String variableBlocksRefinementType;

	protected String alternationRefinementType;

	protected String substitutionRefinementType;

	protected String schemaRefinementType;

	protected String processRefinementType;
	
	protected String zrcType;
	
	protected InternalManager gerInterno;


	/**
	 * 
	 * @param inter
	 */
	public LawsFactory(Internacional inter, InternalManager gerInt) {
		this.setInter(inter);
		gerInterno = gerInt;

		this.setSimulationType(this.getInter().retornarMensagem("COD0543"));

		String temp = this.getInter().retornarMensagem("COD0544");
		this.setActionRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0573");
		this.setAssumptionRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0574");
		this.setGuardsRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0574");
		this.setGuardsRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0546");
		this.setSchemaRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0575");
		this.setParallelismRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0576");
		this.setInterleavingRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0577");
		this.setPrefixRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0578");
		this.setExternalChoiceRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0579");
		this.setInternalChoiceRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0580");
		this.setHidingRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0581");
		this.setRecursionRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0582");
		this.setSequenceRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0583");
		this.setChaosRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0584");
		this.setVariableBlocksRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0585");
		this.setAlternationRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0586");
		this.setSubstitutionRefinementType(temp);

		temp = this.getInter().retornarMensagem("COD0545");
		this.setProcessRefinementType(temp);
		
		temp = this.getInter().retornarMensagem("ZRC");
		zrcType = temp;


	}

	/**
	 * Acessa a classe de internacionalizacao
	 * 
	 * @return a classe de internacionalizacao
	 */
	protected Internacional getInter() {
		return inter;
	}

	/**
	 * Configura uma nova classe de internacionalizacao
	 *  
	 * @param inter a nova classe de internacionalizacao
	 */
	private void setInter(Internacional inter) {
		this.inter = inter;
	}

	/**
	 * @return the simulationType
	 */
	private String getSimulationType() {
		return simulationType;
	}

	/**
	 * @param simulationType the simulationType to set
	 */
	private void setSimulationType(String simulationType) {
		this.simulationType = simulationType;
	}

	/**
	 * @return the actionRefinementType
	 */
	private String getActionRefinementType() {
		return actionRefinementType;
	}

	/**
	 * @param actionRefinementType the actionRefinementType to set
	 */
	private void setActionRefinementType(String actionRefinementType) {
		this.actionRefinementType = actionRefinementType;
	}

	/**
	 * @return the assumptionRefinementType
	 */
	private String getAssumptionRefinementType() {
		return assumptionRefinementType;
	}

	/**
	 * @param assumptionRefinementType the assumptionRefinementType to set
	 */
	private void setAssumptionRefinementType(String assumptionRefinementType) {
		this.assumptionRefinementType = assumptionRefinementType;
	}

	/**
	 * @return the guardsRefinementType
	 */
	private String getGuardsRefinementType() {
		return guardsRefinementType;
	}

	/**
	 * @param guardsRefinementType the guardsRefinementType to set
	 */
	private void setGuardsRefinementType(String guardsRefinementType) {
		this.guardsRefinementType = guardsRefinementType;
	}

	/**
	 * @return the parallelismRefinementType
	 */
	private String getParallelismRefinementType() {
		return parallelismRefinementType;
	}

	/**
	 * @param parallelismRefinementType the parallelismRefinementType to set
	 */
	private void setParallelismRefinementType(String parallelismRefinementType) {
		this.parallelismRefinementType = parallelismRefinementType;
	}

	/**
	 * @return the interleavingRefinementType
	 */
	private String getInterleavingRefinementType() {
		return interleavingRefinementType;
	}

	/**
	 * @param interleavingRefinementType the interleavingRefinementType to set
	 */
	private void setInterleavingRefinementType(String interleavingRefinementType) {
		this.interleavingRefinementType = interleavingRefinementType;
	}

	/**
	 * @return the prefixRefinementType
	 */
	private String getPrefixRefinementType() {
		return prefixRefinementType;
	}

	/**
	 * @param prefixRefinementType the prefixRefinementType to set
	 */
	private void setPrefixRefinementType(String prefixRefinementType) {
		this.prefixRefinementType = prefixRefinementType;
	}

	/**
	 * @return the externalChoiceRefinementType
	 */
	private String getExternalChoiceRefinementType() {
		return externalChoiceRefinementType;
	}

	/**
	 * @param externalChoiceRefinementType the externalChoiceRefinementType to set
	 */
	private void setExternalChoiceRefinementType(String externalChoiceRefinementType) {
		this.externalChoiceRefinementType = externalChoiceRefinementType;
	}

	/**
	 * @return the internalChoiceRefinementType
	 */
	private String getInternalChoiceRefinementType() {
		return internalChoiceRefinementType;
	}

	/**
	 * @param internalChoiceRefinementType the internalChoiceRefinementType to set
	 */
	private void setInternalChoiceRefinementType(String internalChoiceRefinementType) {
		this.internalChoiceRefinementType = internalChoiceRefinementType;
	}

	/**
	 * @return the hidingRefinementType
	 */
	private String getHidingRefinementType() {
		return hidingRefinementType;
	}

	/**
	 * @param hidingRefinementType the hidingRefinementType to set
	 */
	private void setHidingRefinementType(String hidingRefinementType) {
		this.hidingRefinementType = hidingRefinementType;
	}

	/**
	 * @return the recursionRefinementType
	 */
	private String getRecursionRefinementType() {
		return recursionRefinementType;
	}

	/**
	 * @param recursionRefinementType the recursionRefinementType to set
	 */
	private void setRecursionRefinementType(String recursionRefinementType) {
		this.recursionRefinementType = recursionRefinementType;
	}

	/**
	 * @return the sequenceRefinementType
	 */
	private String getSequenceRefinementType() {
		return sequenceRefinementType;
	}

	/**
	 * @param sequenceRefinementType the sequenceRefinementType to set
	 */
	private void setSequenceRefinementType(String sequenceRefinementType) {
		this.sequenceRefinementType = sequenceRefinementType;
	}

	/**
	 * @return the chaosChoiceRefinementType
	 */
	private String getChaosRefinementType() {
		return chaosRefinementType;
	}

	/**
	 * @param chaosChoiceRefinementType the chaosChoiceRefinementType to set
	 */
	private void setChaosRefinementType(String chaosChoiceRefinementType) {
		this.chaosRefinementType = chaosChoiceRefinementType;
	}

	/**
	 * @return the variableBlocksRefinementType
	 */
	private String getVariableBlocksRefinementType() {
		return variableBlocksRefinementType;
	}

	/**
	 * @param variableBlocksRefinementType the variableBlocksRefinementType to set
	 */
	private void setVariableBlocksRefinementType(String variableBlocksRefinementType) {
		this.variableBlocksRefinementType = variableBlocksRefinementType;
	}

	/**
	 * @return the alternationRefinementType
	 */
	private String getAlternationRefinementType() {
		return alternationRefinementType;
	}

	/**
	 * @param alternationRefinementType the alternationRefinementType to set
	 */
	private void setAlternationRefinementType(String alternationRefinementType) {
		this.alternationRefinementType = alternationRefinementType;
	}

	/**
	 * @return the substitutionRefinementType
	 */
	private String getSubstitutionRefinementType() {
		return substitutionRefinementType;
	}

	/**
	 * @param substitutionRefinementType the substitutionRefinementType to set
	 */
	private void setSubstitutionRefinementType(String substitutionRefinementType) {
		this.substitutionRefinementType = substitutionRefinementType;
	}

	/**
	 * @return the schemaRefinementType
	 */
	private String getSchemaRefinementType() {
		return schemaRefinementType;
	}

	/**
	 * @param schemaRefinementType the schemaRefinementType to set
	 */
	private void setSchemaRefinementType(String schemaRefinementType) {
		this.schemaRefinementType = schemaRefinementType;
	}

	/**
	 * @return the processRefinementType
	 */
	private String getProcessRefinementType() {
		return processRefinementType;
	}

	/**
	 * @param processRefinementType the processRefinementType to set
	 */
	private void setProcessRefinementType(String processRefinementType) {
		this.processRefinementType = processRefinementType;
	}

	public abstract List<CircusLaw> createAll();

	/**
	 * Retorna um nome para o tipo da lei
	 * 
	 * @param type tipo da lei
	 * @param codName o codigo do nome da lei
	 * @return o nome constru�do da lei
	 */
	protected String retornarMsg(LawType type , String codName) {
		String name;
		name = this.getInter().retornarMensagem(codName);
		return name;
	}

}
