/*
 * Projeto: Circus Refine
 * Autor: Cristiano Gurgel
 */
package circusRefine.core.crules.factories;

import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circuspatt.util.CircusLaw;

import circusRefine.core.InternalManager;
import circusRefine.util.Internacional;

/**
 * Classe respons�vel por chamar as f�bricas e criar as leis de 
 * Circus
 * 
 * @author Cristiano Gurgel
 */
public class LawsCreator {

	/** F�bricas de onde ser�o criadas as leis */
	private List<LawsFactory> fabricas;
	
	/**
	 * @param inter
	 */
	public LawsCreator(Internacional inter, InternalManager gerInt ) {
		
		/* Cria��o das f�bricas */
		FabricaLeisGeral geral = new FabricaLeisGeral(inter, gerInt);
		SimulationLawsFactory simulation = new SimulationLawsFactory(inter, gerInt);
		ActionLawsFactory action = new ActionLawsFactory(inter, gerInt);
		AssumptionsLawsFactory assumption = new AssumptionsLawsFactory(inter, gerInt);
		GuardsLawsFactory guarda = new GuardsLawsFactory(inter, gerInt);
		SchemaLawsFactory schema = new SchemaLawsFactory(inter, gerInt);
		ParallelismCompositionLawsFactory paralelismo = 
			new ParallelismCompositionLawsFactory(inter, gerInt);
		InterleavingLawsFactory interleaving = 
			new InterleavingLawsFactory(inter, gerInt);
		PrefixLawsFactory prefix = new PrefixLawsFactory(inter, gerInt);
		ExternalChoiceLawsFactory extChoice = 
			new ExternalChoiceLawsFactory(inter, gerInt);
		InternalChoiceLawsFactory intChoice = 
			new InternalChoiceLawsFactory(inter, gerInt);
		HidingLawsFactory hiding = new HidingLawsFactory(inter, gerInt);
		RecursionLawsFactory recursao = new RecursionLawsFactory(inter, gerInt);
		SequenceLawsFactory sequencia = new SequenceLawsFactory(inter, gerInt);
		ChaosLawsFactory chaos = new ChaosLawsFactory(inter, gerInt);
		VariableBlocksLawsFactory blocosVar = 
			new VariableBlocksLawsFactory(inter, gerInt);
		AlternationLawsFactory alternacao = new AlternationLawsFactory(inter, gerInt);
		SubstitutionLawsFactory substituicao = 
			new SubstitutionLawsFactory(inter, gerInt);
		ProcessLawsFactory processo = new ProcessLawsFactory(inter, gerInt);
		
		ZRCLawsFactory zrc = new ZRCLawsFactory(inter,gerInt);
		
		/* Adicionado as f�bricas � lista */
		this.setFabricas(new LinkedList<LawsFactory>());
		this.getFabricas().add(geral);
		this.getFabricas().add(simulation);
		this.getFabricas().add(action);
		this.getFabricas().add(assumption);
		this.getFabricas().add(guarda);
		this.getFabricas().add(schema);
		this.getFabricas().add(paralelismo);
		this.getFabricas().add(interleaving);
		this.getFabricas().add(prefix);
		this.getFabricas().add(extChoice);
		this.getFabricas().add(intChoice);
		this.getFabricas().add(hiding);
		this.getFabricas().add(recursao);
		this.getFabricas().add(sequencia);
		this.getFabricas().add(chaos);
		this.getFabricas().add(blocosVar);
		this.getFabricas().add(alternacao);
		this.getFabricas().add(substituicao);
		this.getFabricas().add(processo);
		this.getFabricas().add(zrc);
	}
	
	private List<LawsFactory> getFabricas() {
		return fabricas;
	}
	
	private void setFabricas(List<LawsFactory> fabricas) {
		this.fabricas = fabricas;
	}
	
	/**
	 * Cria as leis de Todas as F�bricas.
	 * 
	 * @return uma lista com as leis de circus
	 */
	public List<CircusLaw> createLaws() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();
		
		for (LawsFactory fabrica : this.getFabricas()) {
			result.addAll(fabrica.createAll());
		}
		
		/* Confer�ncia */
//		for (CircusLaw lei : result) {
//			if (lei.getAnn(LawNumberAnn.class) == null) {
//				System.err.println("Law " + lei.getName() + 
//						" does not have an identifier ");
//			}
//		}
		
		return result;
	}
	
}
