/*
 * Projeto: Circus Refine
 * Autor: Cristiano Castro
 */
package circusRefine.core.crules.factories;

/**
 * Tipos de leis presentes na ferramenta
 * 
 * @author Cristiano Castro
 */
public enum LawType {
	
	/* 
	 * O padrao na definicao dos tipos para a construção da arvore éo
	 * seguinte:
	 * -> Se um tipo tiver filhos, então é terminado com "_"
	 * -> Os filhos de um tipo são definidos logo depois da definição 
	 * 	  do pai
	 * -> Os nomes dos filhos têm como prefixo o nome do pai
	 * 
	 * A árvore de tipos é� construída segundo esse padrão no método
	 * circusRefine.core.crules.utils.TypeLawsTree#montarArvore()
	 */
	
	SIMULATION_, 
	ACTION_REFINEMENT_,
	ACTION_REFINEMENT_ASSUMPTION,
	ACTION_REFINEMENT_GUARDS,
	ACTION_REFINEMENT_SCHEMA,
	ACTION_REFINEMENT_PARALLELISM_COMPOSITION,
	ACTION_REFINEMENT_INTERLEAVING,
	ACTION_REFINEMENT_PREFIX,
	ACTION_REFINEMENT_EXTERNAL_CHOICE,
	ACTION_REFINEMENT_INTERNAL_CHOICE,
	ACTION_REFINEMENT_HIDING,
	ACTION_REFINEMENT_RECURSION,
	ACTION_REFINEMENT_SEQUENCE,
	ACTION_REFINEMENT_CHAOS,
	ACTION_REFINEMENT_VARIABLE_BLOCKS,
	ACTION_REFINEMENT_ALTERNATION,
	ACTION_REFINEMENT_SUBSTITUTION,
	PROCESS_REFINEMENT,
	ZED_REFINEMENT_CALCULUS;
	
	/**
	 * Teste para saber se um tipo de lei tem filhos na hierarquia da 
	 * classifica��o
	 * 
	 * @return <code>true</code> caso o tipo da lei tenha filho, isto
	 *  �, caso seu nome termine com "_"
	 */
	public boolean temFilhos() {
		return this.toString().endsWith("_");
	}
	
	/**
	 * Testa se este tipo � filho de outro
	 * 
	 * @param tipo o pai a ser testado
	 * @return <code>true</code> caso este tipo seja filho do 
	 *  par�metro, isto �, se seu nome tem como prefixo o nome do 
	 *  par�metro
	 */
	public boolean eFilhoDe(LawType tipo) {
		return tipo != null && this.toString().startsWith(tipo.toString());
	}
	
}
