/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.Pred;
import circusRefine.core.InternalManager;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.util.Internacional;

/**
 * F�brica das leis que atuam sobre Prefixos
 * 
 * @author Cristiano Castro
 */
public class InternalChoiceLawsFactory extends ActionLawsFactory {

	/**
	 * Inicia a f�brica com o objeto para internacionaliza��o
	 * 
	 * @param inter o objeto de onde se retiram as mensagens para
	 *  internacionaliza��o
	 */
	public InternalChoiceLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	/**
	 * Cria o nome da lei baseado no tipo da f�brica
	 * 
	 * @param codName c�digo para o nome da lei
	 */
	protected String createName(String codName) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_INTERNAL_CHOICE, codName);
	}
	
	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();
		
		/* C.115*/
		result.add(criarLeiSequenceInternalChoiceDistribution());
		
		/* C.116*/
		result.add(criarLeiInternalChoiceElimination());

		/* C.117*/
		result.add(criarLeiInternalChoiceElimination2());
		
		/* C.118*/
		result.add(criarLeiInternalChoiceZero() );
		
		/* C.119*/
		result.add(criarLeiInternalChoiceParallelismDistribution());
		
		return result;
	}
	
	
	/**
	 * Cria Uma lei <i>Sequence/Internal Choice -- Distribution</i> (C-115) 
	 * 
	 * @return a nova CircusActionLaw
	 */
    public CircusLaw criarLeiSequenceInternalChoiceDistribution() {
    	
    	JokerAction a1 = factory.createJokerAction("A1", null);
    	JokerAction a2 = factory.createJokerAction("A2", null);
    	JokerAction a3 = factory.createJokerAction("A3", null);
    	
    	/*
    	 * LHS
    	 */
    	IntChoiceAction par1 = factory.createIntChoiceAction(Arrays.asList(a2,a3));
    	SeqAction left = factory.createSeqAction(Arrays.asList(a1,par1));
    	
    	/* 
    	 * RHS
    	 */
    	
    	SeqAction par2 = factory.createSeqAction(Arrays.asList(a1,a2));
    	SeqAction par3 = factory.createSeqAction(Arrays.asList(a1,a3));
    	
    	IntChoiceAction right = factory.createIntChoiceAction(Arrays.asList(par2,par3));
    	
    	/* Criando o Transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	/* Criando Obriga��es de Prova */
    	List<Pred> list = new ArrayList<Pred>();
    	
    	String nome = this.createName("COD0705");
    	
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			list);

    	LawNumberAnn id = new LawNumberAnn("C.115", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, 
    			LawType.ACTION_REFINEMENT_INTERNAL_CHOICE);
    	
    	return result;
    }
    
    
    /**
	 * Cria Uma lei <i>Internal Choice Elimination</i> (C-116) 
	 * 
	 * @return a nova CircusActionLaw
	 */
    public CircusLaw criarLeiInternalChoiceElimination() {
    	
    	JokerAction a = factory.createJokerAction("A", null);
    	
    	/*
    	 * LHS
    	 */
    	IntChoiceAction left = factory.createIntChoiceAction(Arrays.asList(a,a));
    	
    	/* Criando o Transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, a));
    	
    	/* Criando Obriga��es de Prova */
    	List<Pred> list = new ArrayList<Pred>();
    	
    	String nome = this.createName("COD0706");
    	
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			list);

    	LawNumberAnn id = new LawNumberAnn("C.116", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, 
    			LawType.ACTION_REFINEMENT_INTERNAL_CHOICE);
    	
    	return result;
    }
    
    
    /**
	 * Cria Uma lei <i>Internal Choice Elimination 2</i> (C-117) 
	 * 
	 * @return a nova CircusActionLaw
	 */
    public CircusLaw criarLeiInternalChoiceElimination2() {
    	
    	JokerAction a1 = factory.createJokerAction("A1", null);
    	JokerAction a2 = factory.createJokerAction("A2", null);
    	
    	/*
    	 * LHS
    	 */
    	IntChoiceAction left = factory.createIntChoiceAction(Arrays.asList(a1,a2));
    	
    	/* Criando o Transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, a1));
    	
    	/* Criando Obriga��es de Prova */
    	List<Pred> list = new ArrayList<Pred>();
    	
    	String nome = this.createName("COD0707");
    	
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			list);

    	LawNumberAnn id = new LawNumberAnn("C.117", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, 
    			LawType.ACTION_REFINEMENT_INTERNAL_CHOICE);
    	
    	return result;
    }
    
    
    /**
	 * Cria Uma lei <i>Internal Choice Zero</i> (C-118) 
	 * 
	 * @return a nova CircusActionLaw
	 */
    public CircusLaw criarLeiInternalChoiceZero() {
    	
    	JokerAction a1 = factory.createJokerAction("A", null);
    	
    	/*
    	 * LHS
    	 */
    	IntChoiceAction left = factory.createIntChoiceAction(Arrays.
    			asList(a1,factory.createChaosAction()));
    	
    	/* Criando o Transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, factory.createChaosAction()));
    	
    	/* Criando Obriga��es de Prova */
    	List<Pred> list = new ArrayList<Pred>();
    	
    	String nome = this.createName("COD0708");
    	
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			list);

    	LawNumberAnn id = new LawNumberAnn("C.118", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, 
    			LawType.ACTION_REFINEMENT_INTERNAL_CHOICE);
    	
    	return result;
    }
    
    /**
	 * Cria Uma lei <i>Internal Choice/Parallelism -- Distribution</i> (C-119) 
	 * 
	 * @return a nova CircusActionLaw
	 */
    public CircusLaw criarLeiInternalChoiceParallelismDistribution() {
    	
    	JokerAction a1 = factory.createJokerAction("A1", null);
    	JokerAction a2 = factory.createJokerAction("A2", null);
    	JokerAction a3 = factory.createJokerAction("A3", null);
    	
    	JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
    	JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
    	
    	JokerChannelSet cs = factory.createJokerChannelSet("cs", null);
    	
    	/*
    	 * LHS
    	 */
    	IntChoiceAction par1 = factory.createIntChoiceAction(Arrays.asList(a1,a2));
    	
    	ParallelAction left = factory.createParallelAction(Arrays.asList(par1,a3)
    			, Arrays.asList(ns1,ns2), cs);
    	
    	/* 
    	 * RHS
    	 */
    	
    	ParallelAction par2 = factory.createParallelAction(Arrays.
    			asList(a1,a3), Arrays.asList(ns1,ns2), cs);
    	
    	ParallelAction par3 = factory.createParallelAction(Arrays.
    			asList(a2,a3), Arrays.asList(ns1,ns2), cs);
    	
    	IntChoiceAction right = factory.createIntChoiceAction(Arrays.asList(par2,par3));
    	
    	/* Criando o Transformer */
    	ActionTransformerPred trans = factory.createActionTransformerPred(null, 
    			Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
    			Arrays.asList(left, right));
    	
    	/* Criando Obriga��es de Prova */
    	List<Pred> list = new ArrayList<Pred>();
    	
    	String nome = this.createName("COD0709");
    	
    	CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
    			list);

    	LawNumberAnn id = new LawNumberAnn("C.119", nome);
    	result.getAnns().add(id);
    	LawTypeAnnUtils.insertAnnLawType(result, 
    			LawType.ACTION_REFINEMENT_INTERNAL_CHOICE);
    	
    	return result;
    }

}
