/*
 * Projeto: Circus Refine
 * Autor: Cristiano Gurgel de Castro
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import circusRefine.core.InternalManager;
import circusRefine.core.astmodifiers.ActionArgumentAnn;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.util.Internacional;

import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusChannelSet;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.CommUsage;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.ExprList;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerName;

/**
 * F�brica das leis Hiding de Circus 
 * 
 * @author Cristiano Castro
 */
public class HidingLawsFactory extends ActionLawsFactory {

	public HidingLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter, gerInt);
	}

	/**
	 * Cria o nome da lei baseado no tipo da f�brica
	 * 
	 * @param codName c�digo para o nome da lei
	 */
	protected String createName(String codName) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_HIDING, codName);
	}

	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();

		/* C-120 */
		result.add(this.createLawHidingIdentity());

		/* C-121 */
		result.add(this.createLawHidingCombination());

		/* C-122 */
		result.add(this.createLawHidingExternalChoiceDistribution());

		/* C-124 */
		result.add(this.createLawHidingExpansion2());

		/* C-125 */
		result.add(this.createLawHidingSequenceDistribution());

		/* C-126 */
		result.add(this.createLawHidingChaosDistribution());

		result.add(this.createLawHidParDist());
		result.add(this.createLawHidInterDist());
		result.add(this.createLawHidRecDist());
		result.add(this.createLawHidStep());

		return result;
	}

	/**
	 * Cria a lei C-120 Hiding Identity
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawHidingIdentity() {

		/* Criando o LHS */
		JokerAction actA = 
			this.getFactory().createJokerAction("A", null);
		JokerExpr csExpr = 
			this.getFactory().createJokerExpr("csExpr", null);
		ChannelSet cs = 
			this.getFactory().createCircusChannelSet(csExpr);
		HideAction left = 
			this.getFactory().createHideAction(actA, cs);

		/* criando o RHS */
		CircusAction right = actA;

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new LinkedList<Pred>();

		/* OP1 */
		ZName nomeFunUsedC = this.getFactory().createZName("usedC", 
				this.getFactory().createZStrokeList(), null);
		ZName nomeIntersecao = 
			this.getFactory().createZName(ZString.ARG_TOK + 
					ZString.CAP + ZString.ARG_TOK, 
					this.getFactory().createZStrokeList(), 
					null);

		/* Cria o argumento da fun��o usedC */
		RefExpr argUsedC = this.getFactory().createRefExpr();
		argUsedC.getAnns().add(new ActionArgumentAnn(actA));

		/* Nome da fun��o usedC */
		RefExpr nomeUsedC = 
			this.getFactory().createRefExpr(nomeFunUsedC, 
					getFactory().createZExprList(), false, false);

		/* Fun��o UsedC */
		ApplExpr funUsedC = 
			getFactory().createApplExpr(Arrays.asList(nomeUsedC, argUsedC), 
					false);

		/* Argumentos da interse��o */
		ZExprList listaArgsIntersecao = 
			this.getFactory().createZExprList(Arrays.asList(csExpr, 
					funUsedC));
		TupleExpr argsIntersecao = 
			this.getFactory().createTupleExpr(listaArgsIntersecao);

		/* Nome interse��o */
		RefExpr refIntersecao = 
			this.getFactory().createRefExpr(nomeIntersecao, 
					this.getFactory().createZExprList(), false, 
					false);

		/* Aplica��o da interse��o */
		ApplExpr intersecao = 
			this.getFactory().createApplExpr(
					Arrays.asList(refIntersecao, argsIntersecao), true);

		/* Cria��o do conjunto vazio */
		ZName conjVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr emptySet = 
			this.getFactory().createRefExpr(conjVazio, 
					this.getFactory().createZExprList(), false, 
					false);
		ZExprList listaUnitaria = 
			this.factory.createZExprList(Arrays.asList(emptySet));
		SetExpr conjUnit = 
			this.getFactory().createSetExpr(listaUnitaria);

		/* Predicado da igualdade */
		MemPred op1 = 
			this.factory.createMemPred(Arrays.asList(intersecao, 
					conjUnit), true);

		ops.add(op1);

		/* Criando a Lei */
		String nome = this.createName("COD0557");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C.120", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_HIDING);

		return result;

	}

	/**
	 * Cria a lei C-121 Hiding Combination
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawHidingCombination() {

		/* Criando o LHS */
		JokerAction actA1 = 
			this.getFactory().createJokerAction("A", null);


		JokerExpr cs1 = factory.createJokerExpr("cs1", null);
		JokerExpr cs2 = factory.createJokerExpr("cs2", null);

		CircusChannelSet cs1Set = factory.createCircusChannelSet(cs1);
		CircusChannelSet cs2Set = factory.createCircusChannelSet(cs2);

		HideAction par1 = this.getFactory().createHideAction(actA1, 
				cs1Set);

		HideAction left = this.getFactory().createHideAction(par1, 
				cs2Set);

		/* criando o RHS */

		/* Montando o nome da interse��o */
		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);


		/* Lista de argumentos da uniao */
		ZExprList listaUniao2 = 
			this.getFactory().createZExprList
			(Arrays.asList(cs1,cs2));
		TupleExpr argsUniao2 = 
			this.getFactory().createTupleExpr(listaUniao2);

		/* Aplica��o da uniao */
		ApplExpr applUniao2 = 
			this.getFactory().createApplExpr(Arrays.asList(funUniao, 
					argsUniao2), true);

		CircusChannelSet c1c2 = factory.createCircusChannelSet(applUniao2);

		HideAction right = factory.createHideAction(actA1, c1c2);


		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new LinkedList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0710");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C.121", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_HIDING);

		return result;

	}

	/**
	 * Cria a lei C-122 Hiding External Choice Distribution
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawHidingExternalChoiceDistribution() {

		/* Criando o LHS */
		JokerAction actA1 = 
			this.getFactory().createJokerAction("A1", null);

		JokerAction actA2 = 
			this.getFactory().createJokerAction("A2", null);

		JokerExpr cs1 = factory.createJokerExpr("cs", null);

		CircusChannelSet cs1Set = factory.createCircusChannelSet(cs1);

		ExtChoiceAction par1 = factory.createExtChoiceAction(Arrays
				.asList(actA1,actA2));

		HideAction left = factory.createHideAction(par1, cs1Set);

		/* criando o RHS */


		HideAction par2 = factory.createHideAction(actA1, cs1Set);
		HideAction par3 = factory.createHideAction(actA2, cs1Set);

		ExtChoiceAction right = factory.createExtChoiceAction(
				Arrays.asList(par2,par3));

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new LinkedList<Pred>();

		/*
		 * OP1
		 */

		/* Montando o nome da fun��o usedC */

		RefExpr funInitials = OPsDischargeUtils.refFuncao(OPsDischargeUtils.INITIALS); 

		/* ListaArgumentos da fun��oUsedC */
		RefExpr argInitialsA1 = this.getFactory().createRefExpr();
		argInitialsA1.getAnns().add(new ActionArgumentAnn(actA1));

		RefExpr argInitialsA2 = this.getFactory().createRefExpr();
		argInitialsA2.getAnns().add(new ActionArgumentAnn(actA2));

		/* Aplica��o da fun��o usedC */
		ApplExpr applInitialsA1 = 
			this.getFactory().createApplExpr(Arrays.asList(funInitials, 
					argInitialsA1), false);

		ApplExpr applInitialsA2 = 
			this.getFactory().createApplExpr(Arrays.asList(funInitials, 
					argInitialsA2), false);


		/* Montando o nome da interse��o */
		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);


		/* Lista de argumentos da uniao */
		ZExprList listaUniao2 = 
			this.getFactory().createZExprList
			(Arrays.asList(applInitialsA1,applInitialsA2 ));
		TupleExpr argsUniao2 = 
			this.getFactory().createTupleExpr(listaUniao2);

		/* Aplica��o da uniao */
		ApplExpr applUniao2 = 
			this.getFactory().createApplExpr(Arrays.asList(funUniao, 
					argsUniao2), true);

		/* Montando o nome da interse��o */
		ZName nomeIntersecao = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funIntersecao = this.getFactory().createRefExpr(nomeIntersecao, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da interse��o */
		ZExprList listaArgsIntersecao = 
			this.getFactory().createZExprList(Arrays.asList(applUniao2, cs1));
		TupleExpr argsIntersecao = 
			this.getFactory().createTupleExpr(listaArgsIntersecao);

		/* Aplica��o da intersecao */
		ApplExpr applIntersecao1 = 
			this.getFactory().createApplExpr(Arrays.asList(funIntersecao, 
					argsIntersecao), true);

		/* Monta a refer�ncia ao conjunto vazio */
		ZName nomeConjuntoVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr conjuntoVazio = 
			this.getFactory().createRefExpr(nomeConjuntoVazio, 
					this.getFactory().createZExprList(), false, false);

		/* Monta o conjunto unit�rio do conjunto vazio */
		ZExprList listaComConjuntoVazio = 
			this.getFactory().createZExprList(Arrays.asList(conjuntoVazio));
		SetExpr conjuntoUnitarioDoConjuntoVazio = 
			this.getFactory().createSetExpr(listaComConjuntoVazio);

		/* Monta o segundo predicado */
		MemPred op1 = 
			this.getFactory().createMemPred(Arrays.asList(applIntersecao1, 
					conjuntoUnitarioDoConjuntoVazio), true);

		ops.add(op1);

		/* Criando a Lei */
		String nome = this.createName("COD0711");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C.122", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_HIDING);

		return result;

	}

	/**
	 * Cria a lei C-124 Hiding Expansion 2
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawHidingExpansion2() {

		/* Criando o LHS */
		JokerAction actA1 = 
			this.getFactory().createJokerAction("A", null);


		JokerExpr cs1 = factory.createJokerExpr("cs1", null);

		CircusChannelSet cs1Set = factory.createCircusChannelSet(cs1);


		HideAction left = this.getFactory().createHideAction(actA1, 
				cs1Set);

		/* criando o RHS */

		/* Montando o nome da interse��o */
		ZName nomeUniao = this.getFactory().createZName(
				OPsDischargeUtils.CUP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funUniao = this.getFactory().createRefExpr(nomeUniao, 
				this.getFactory().createZExprList(), false, false);

		JokerExpr cexpr = factory.createJokerExpr("c", null);
		ExprList cexprlist = factory.createZExprList(Arrays.asList(cexpr));
		SetExpr set =factory.createSetExpr(cexprlist);

		/* Lista de argumentos da uniao */
		ZExprList listaUniao2 = 
			this.getFactory().createZExprList
			(Arrays.asList(cs1,set));
		TupleExpr argsUniao2 = 
			this.getFactory().createTupleExpr(listaUniao2);

		/* Aplica��o da uniao */
		ApplExpr applUniao2 = 
			this.getFactory().createApplExpr(Arrays.asList(funUniao, 
					argsUniao2), true);

		CircusChannelSet c1c2 = factory.createCircusChannelSet(applUniao2);

		HideAction right = factory.createHideAction(actA1, c1c2);


		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new LinkedList<Pred>();

		RefExpr funUsedC = OPsDischargeUtils.refFuncao
		(OPsDischargeUtils.USED_C);

		RefExpr argUsedCA = factory.createRefExpr();
		argUsedCA.getAnns().add(new ActionArgumentAnn(actA1));

		ApplExpr applUsedCA = factory.createApplExpr(Arrays
				.asList(funUsedC,argUsedCA), false);

		MemPred op1 = factory.createMemPred(Arrays.
				asList(cexpr,applUsedCA), false);

		ops.add(op1);

		/* Criando a Lei */
		String nome = this.createName("COD0716");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C.124", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_HIDING);

		return result;

	}


	/**
	 * Cria a lei C-125 Hiding/Sequence--distribution
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawHidingSequenceDistribution() {

		/* Criando o LHS */
		JokerAction actA1 = 
			this.getFactory().createJokerAction("A1", null);
		JokerAction actA2 = 
			this.getFactory().createJokerAction("A2", null);
		SeqAction seq = 
			this.getFactory().createSeqAction(Arrays.asList(actA1, 
					actA2));
		JokerChannelSet cs = 
			this.getFactory().createJokerChannelSet("cs", null);
		HideAction left = this.getFactory().createHideAction(seq, 
				cs);

		/* criando o RHS */
		HideAction hide1 = 
			this.getFactory().createHideAction(actA1, cs);
		HideAction hide2 = 
			this.getFactory().createHideAction(actA2, cs);
		SeqAction right = 
			this.getFactory().createSeqAction(Arrays.asList(hide1, 
					hide2));

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new LinkedList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0558");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C.125", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_HIDING);

		return result;

	}


	/**
	 * Cria a lei C-126 Hiding/Chaos -- Distribution
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawHidingChaosDistribution() {

		/* Criando o LHS */

		JokerExpr cs1 = factory.createJokerExpr("cs1", null);

		CircusChannelSet cs1Set = factory.createCircusChannelSet(cs1);

		HideAction left = this.getFactory().createHideAction(
				factory.createChaosAction(), cs1Set);

		/* criando o RHS */

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, factory.createChaosAction()));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new LinkedList<Pred>();

		/* Criando a Lei */
		String nome = this.createName("COD0712");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, ops);

		LawNumberAnn id = new LawNumberAnn("C.126", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, LawType.ACTION_REFINEMENT_HIDING);

		return result;

	}

	public CircusLaw createLawHidParDist(){


		JokerExpr cs2 = factory.createJokerExpr("cs2", null);
		CircusChannelSet cs2Set = factory.createCircusChannelSet(cs2);

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);
		JokerExpr csExpr = factory.createJokerExpr("cs1", null);
		CircusChannelSet cs1 = factory.createCircusChannelSet(csExpr);

		ParallelAction parLeft = factory.createParallelAction(Arrays
				.asList(a1,a2), Arrays.asList(ns1,ns2), cs1);

		HideAction left = this.getFactory().createHideAction(
				parLeft, cs2Set);	

		/**
		 * Right
		 */

		HideAction rightA1 = this.getFactory().createHideAction(
				a1, cs2Set);	

		HideAction rightA2 = this.getFactory().createHideAction(
				a2, cs2Set);	

		ParallelAction right = factory.createParallelAction(Arrays
				.asList(rightA1,rightA2), Arrays.asList(ns1,ns2), cs1);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left,right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new LinkedList<Pred>();

		/**
		 * cs1 ^ cs2 = 0
		 */

		ZName nomeInt = this.getFactory().createZName(
				OPsDischargeUtils.CAP, this.getFactory().createZStrokeList(), 
				null);
		RefExpr funCInter = this.getFactory().createRefExpr(nomeInt, 
				this.getFactory().createZExprList(), false, false);

		/* Lista de argumentos da intersecao */
		ZExprList listaArgsInter = 
			this.getFactory().createZExprList(Arrays.asList(csExpr,cs2));

		TupleExpr argsFuncaoInter = 
			this.getFactory().createTupleExpr(listaArgsInter);

		/* Aplicacao daUniao */
		ApplExpr applUniaoInter = 
			this.getFactory().createApplExpr(Arrays.asList(funCInter, 
					argsFuncaoInter), true);

		ZName conjVazio = 
			this.getFactory().createZName(ZString.EMPTYSET, 
					this.getFactory().createZStrokeList(), null);
		RefExpr emptySet = 
			this.getFactory().createRefExpr(conjVazio, 
					this.getFactory().createZExprList(), false, 
					false);
		ZExprList listaUnitaria = 
			this.factory.createZExprList(Arrays.asList(emptySet));
		SetExpr conjUnit = 
			this.getFactory().createSetExpr(listaUnitaria);

		/* Predicado da igualdade */
		MemPred op1 = 
			this.factory.createMemPred(Arrays.asList(applUniaoInter, 
					conjUnit), true);

		ops.add(op1);

		/* Criando a Lei */
		String nome = this.createName("HidParDist");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1071", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_HIDING);

		return result;
	}

	public CircusLaw createLawHidInterDist(){


		JokerExpr cs2 = factory.createJokerExpr("cs2", null);
		CircusChannelSet cs2Set = factory.createCircusChannelSet(cs2);

		JokerAction a1 = factory.createJokerAction("A1", null);
		JokerAction a2 = factory.createJokerAction("A2", null);

		JokerNameSet ns1 = factory.createJokerNameSet("ns1", null);
		JokerNameSet ns2 = factory.createJokerNameSet("ns2", null);

		InterleaveAction interLeft = factory.createInterleaveAction(Arrays
				.asList(a1,a2), Arrays.asList(ns1,ns2));

		HideAction left = this.getFactory().createHideAction(
				interLeft, cs2Set);	

		/**
		 * Right
		 */

		HideAction rightA1 = this.getFactory().createHideAction(
				a1, cs2Set);	

		HideAction rightA2 = this.getFactory().createHideAction(
				a2, cs2Set);	

		InterleaveAction right = factory.createInterleaveAction(Arrays
				.asList(rightA1,rightA2), Arrays.asList(ns1,ns2));

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left,right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new LinkedList<Pred>();


		/* Criando a Lei */
		String nome = this.createName("HidInterDist");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1072", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_HIDING);

		return result;
	}

	public CircusLaw createLawHidRecDist(){


		JokerExpr cs2 = factory.createJokerExpr("cs2", null);
		CircusChannelSet cs2Set = factory.createCircusChannelSet(cs2);

		JokerAction a1 = factory.createJokerAction("A", null);

		JokerName x = 
			this.getFactory().createJokerName("X", null);
		MuAction mu = factory.createMuAction(a1, x);

		HideAction left = this.getFactory().createHideAction(
				mu, cs2Set);	

		/**
		 * Right
		 */

		

		HideAction hide = this.getFactory().createHideAction(
				a1, cs2Set);	
		MuAction right = factory.createMuAction(hide, x);

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left,right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new LinkedList<Pred>();


		/* Criando a Lei */
		String nome = this.createName("HidRecDist");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1072", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_HIDING);

		return result;
	}
	
	public CircusLaw createLawHidStep(){


		JokerExpr cs2 = factory.createJokerExpr("cs", null);
		CircusChannelSet cs2Set = factory.createCircusChannelSet(cs2);

		JokerAction a1 = factory.createJokerAction("A", null);
		
		JokerName nomeCanal = this.getFactory().createJokerName("c", null);
		RefExpr refNomeCanal = this.getFactory().createRefExpr(nomeCanal, 
				this.getFactory().createZExprList(), false, false);
		Communication c1 = this.getFactory().createCommunication(refNomeCanal, 
				this.getFactory().createCircusFieldList(), CommUsage.Normal, 
				null, null, null);

		PrefixingAction pref = factory.createPrefixingAction(a1, c1);

		HideAction left = this.getFactory().createHideAction(
				pref, cs2Set);	

		/**
		 * Right
		 */

		HideAction right = this.getFactory().createHideAction(
				a1, cs2Set);	

		/* Criando o transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left,right));

		/* Criando as obriga��es de prova */
		List<Pred> ops = new LinkedList<Pred>();


		/* Criando a Lei */
		String nome = this.createName("HidStep");
		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, 
				ops);

		LawNumberAnn id = new LawNumberAnn("C.1073", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_HIDING);

		return result;
	}

	}

