/*
 * Projeto: Circus Refine
 * Autor: Cristiano Gurgel de Castro
 */
package circusRefine.core.crules.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;


import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.AssignmentCommand;
import net.sourceforge.czt.circus.ast.AssignmentPairs;
import net.sourceforge.czt.circus.ast.ChaosAction;
import net.sourceforge.czt.circus.ast.CircusFieldList;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.CommUsage;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.FieldList;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.SchExprAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.SkipAction;
import net.sourceforge.czt.circus.ast.SpecStmtCommand;
import net.sourceforge.czt.circus.ast.StopAction;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circuspatt.util.CircusPattUtils;
import net.sourceforge.czt.oz.ast.OzFactory;
import net.sourceforge.czt.oz.ast.PredExpr;
import net.sourceforge.czt.oz.impl.OzFactoryImpl;
import net.sourceforge.czt.z.ast.And;
import net.sourceforge.czt.z.ast.AndExpr;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.FalsePred;
import net.sourceforge.czt.z.ast.IffPred;
import net.sourceforge.czt.z.ast.ImpliesPred;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NegPred;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.TruePred;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExprList;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerNameList;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import circusRefine.core.InternalManager;
import circusRefine.core.crules.utils.LawTypeAnnUtils;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.util.Internacional;

/**
 * f�brica das leis que atuam sobre Assumptions
 * 
 * @author Cristiano Castro
 */
public class AssumptionsLawsFactory extends ActionLawsFactory {

	/**
	 * Inicia a f�brica com o objeto para internacionaliza��o
	 * 
	 * @param inter o objeto de onde se retiram as mensagens para
	 *  internacionaliza��o
	 */
	public AssumptionsLawsFactory(Internacional inter, InternalManager gerInt) {
		super(inter,gerInt);
	}

	/**
	 * Cria o nome da lei baseado no tipo da f�rica
	 * 
	 * @param codName c�digo para o nome da lei
	 */
	protected String createName(String codName) {
		return this.retornarMsg(LawType.ACTION_REFINEMENT_ASSUMPTION, codName);
	}

	@Override
	public List<CircusLaw> createAll() {
		List<CircusLaw> result = new LinkedList<CircusLaw>();

		/* C-26 */
		result.add(this.createLawAssumptionConjunction());

		/* C-27 */
		result.add(this.createLawAssumptionIntroduction());

		/* C-30 */
		result.add(this.createLawAssumptionGuardIntroduction());

		/* C-31 */
		result.add(this.createLawGuardAssumptionIntroduction());

		/* C-32 */
		result.add(this.createLawAssumptionGuardElimination1());

		/* C-33 */
		result.add(this.createLawAssumptionGuardElimination2());

		/* C-34 */
		result.add(this.createLawAssumptionGuardReplacement());

		/* C-35 */
		result.add(this.createLawAssumptionElimination());

		/* C-36 */
		result.add(this.createLawAssumptionSubstitution1());

		/* C-37 */
		result.add(this.createLawAssumptionExternalChoiceDistribution());

		/* C-38 */
		result.add(
				this.createLawAssumptionParallelismCompositionDistribution());

		/* C-39 */
		result.add(this.createLawAssumptionInterleavingDistribution());

		/* C-41*/
		result.add(this.createLawAssumptionPrefixDistribution());

		/* C-42*/
		result.add(this.createLawAssumptionPrefixDistribution2());

		/* C-43*/
		result.add(this.createLawAssumptionSimplePrefixDistribution());

		/* C-44*/
		result.add(this.createLawAssumptionSimplePrefixDistribution2());

		/* C-45*/
		result.add(this.createLawAssumptionOutputPrefixDistribution());

		/* C-46*/
		result.add(this.createLawAssumptionOutputPrefixDistribution2());

		/* C-47 */
		result.add(this.createLawAssumptionInputPrefixDistribution());

		/* C-48 */
		result.add(this.createLawAssumptionInputPrefixDistribution2());

		/* C-49 */
		result.add(this.createLawAssumptionConstrainedInputPrefixDistribution());

		/* C-50 */
		result.add(this.createLawAssumptionConstrainedInputPrefixDistribution2());

		/* C-53 */
		result.add(this.createLawAssumptionSchemaDistribution());

		/* C-54 */
		result.add(this.createLawAssumptionAssignmentDistribution());
		
		/* C-55 */
		result.add(this.createLawAssumptionUnit());
		
		/* C-56 */
		result.add(this.createLawAssumptionZero());
		
		return result;
	}

	/**
	 * Cria a lei C-26 Assumption Conjunction
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionConjunction() {

		/* LHS "{g_1}; {g_2}" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		JokerPred g1 = this.getFactory().createJokerPred("g_1", null);
		JokerPred g2 = this.getFactory().createJokerPred("g_2", null);
		SpecStmtCommand ss1 = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g1, post));
		SpecStmtCommand ss2 = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g2, post));
		SeqAction left = this.getFactory().createSeqAction(Arrays.asList(ss1, 
				ss2));

		/* RHS "{g_1 \land g_2}" */
		AndPred and = this.getFactory().createAndPred(Arrays.asList(g1, g2), 
				And.Wedge);
		SpecStmtCommand right = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(and, post));


		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0645");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.26", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C-27 Assumption Conjunction
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionIntroduction() {

		/* LHS "{g}" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		JokerPred g = this.getFactory().createJokerPred("g", null);
		SpecStmtCommand left = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));

		/* RHS "{g_1 \land g_2}" */
		JokerPred g1 = this.getFactory().createJokerPred("g_1", null);
		SpecStmtCommand ss1 = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g1, post));
		SeqAction right = this.getFactory().createSeqAction(Arrays.asList(left, 
				ss1));


		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* OP1 "g \implies g1"  */
		ImpliesPred op1 = this.getFactory().createImpliesPred(Arrays.asList(g, 
				g1));
		list.add(op1);

		/* Nome da lei */
		String nome = this.createName("COD0646");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.27", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C-30 Assumption/Guard�introduction
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionGuardIntroduction() {

		/* LHS "{g}; A" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		JokerPred g = this.getFactory().createJokerPred("g", null);
		JokerAction a = this.getFactory().createJokerAction("A", null);
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));
		SeqAction left = this.getFactory().createSeqAction(Arrays.asList(a, 
				ss));

		/* RHS " { g }; g & A" */
		GuardedAction gA = this.getFactory().createGuardedAction(a, g);
		SeqAction right = this.getFactory().createSeqAction(Arrays.asList(ss, 
				gA));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0647");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.30", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C.31 (Guard/Assumption�introduction 1 )
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawGuardAssumptionIntroduction() {

		/* LHS "g & A" */
		JokerPred g = this.getFactory().createJokerPred("g", null);
		JokerAction a = this.getFactory().createJokerAction("A", null);
		GuardedAction left = this.getFactory().createGuardedAction(a, g);

		/* RHS "g & { g }; A" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));
		SeqAction gA = this.getFactory().createSeqAction(Arrays.asList(ss, 
				a));
		GuardedAction right = this.getFactory().createGuardedAction(gA, g);

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0648");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.31", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C.32 (Assumption/Guard�elimination 1)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionGuardElimination1() {

		/* LHS "{ g1 }; (g2 & A)" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		JokerPred g1 = this.getFactory().createJokerPred("g_1", null);
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g1, post));
		JokerPred g2 = this.getFactory().createJokerPred("g_2", null);
		JokerAction a = this.getFactory().createJokerAction("A", null);
		GuardedAction g2A = this.getFactory().createGuardedAction(a, g2);
		SeqAction left = this.getFactory().createSeqAction(Arrays.asList(ss, 
				g2A));

		/* RHS "{ g1 }; A" */
		SeqAction right = this.getFactory().createSeqAction(Arrays.asList(ss,
				a));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* OP1: "g1 \implies g2 */
		ImpliesPred op1 = this.getFactory().createImpliesPred(Arrays.asList(g1, 
				g2));
		list.add(op1);

		/* Nome da lei */
		String nome = this.createName("COD0649");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.32", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C.33 (Assumption/Guard�elimination 2)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionGuardElimination2() {

		/* LHS "{ g1 }; (g2 & A)" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		JokerPred g1 = this.getFactory().createJokerPred("g_1", null);
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g1, post));
		JokerPred g2 = this.getFactory().createJokerPred("g_2", null);
		JokerAction a = this.getFactory().createJokerAction("A", null);
		GuardedAction g2A = this.getFactory().createGuardedAction(a, g2);
		SeqAction left = this.getFactory().createSeqAction(Arrays.asList(ss, 
				g2A));

		/* RHS "{ g1 }; Stop" */
		StopAction stop = this.getFactory().createStopAction();
		SeqAction right = this.getFactory().createSeqAction(Arrays.asList(ss,
				stop));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* OP1: "g_1 \implies �g_2 */
		NegPred notG2 = this.getFactory().createNegPred(g2);
		ImpliesPred op1 = this.getFactory().createImpliesPred(Arrays.asList(g1, 
				notG2));
		list.add(op1);

		/* Nome da lei */
		String nome = this.createName("COD0650");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.33", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C.34 Assumption/Guard�replacement
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionGuardReplacement() {

		/* LHS "{ g_1 }; (g_2 & A)" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		JokerPred g1 = this.getFactory().createJokerPred("g_1", null);
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g1, post));
		JokerPred g2 = this.getFactory().createJokerPred("g_2", null);
		JokerAction a = this.getFactory().createJokerAction("A", null);
		GuardedAction g2A = this.getFactory().createGuardedAction(a, g2);
		SeqAction left = this.getFactory().createSeqAction(Arrays.asList(ss, 
				g2A));

		/* RHS "{ g1 }; (g3 & A)" */
		JokerPred g3 = this.getFactory().createJokerPred("g_3", null);
		GuardedAction g3A = this.getFactory().createGuardedAction(a, g3);
		SeqAction right = this.getFactory().createSeqAction(Arrays.asList(ss,
				g3A));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* OP1: "g_1 \implies (g_2 \iff g_3)" */
		IffPred g2IffG3 = this.getFactory().createIffPred(Arrays.asList(g2, 
				g3));
		ImpliesPred op1 = this.getFactory().createImpliesPred(Arrays.asList(g1, 
				g2IffG3));
		list.add(op1);

		/* Nome da lei */
		String nome = this.createName("COD0651");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.34", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C.35 (Assumption elimination)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionElimination() {

		/* LHS "{ p }" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		JokerPred p = this.getFactory().createJokerPred("p", null);
		SpecStmtCommand left = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(p, post));

		/* RHS "Skip" */
		SkipAction right = this.getFactory().createSkipAction();

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Refinement, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0652");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.35", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C.36 (Assumption substitution 1 )
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionSubstitution1() {

		/* LHS "{ g_1 }" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		JokerPred g1 = this.getFactory().createJokerPred("g_1", null);
		SpecStmtCommand left = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g1, post));

		/* RHS "{ g_2 }" */
		JokerPred g2 = this.getFactory().createJokerPred("g_2", null);
		SpecStmtCommand right = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g2, post));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Refinement, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* OP1: "g1 \implies g2" */
		ImpliesPred op1 = this.getFactory().createImpliesPred(Arrays.asList(g1, 
				g2));
		list.add(op1);

		/* Nome da lei */
		String nome = this.createName("COD0653");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.36", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C.37 (Assumption/External choice�distribution)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionExternalChoiceDistribution() {

		/* LHS "{ p }; ( A_1 \extchoice A_2 )" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		JokerPred p = this.getFactory().createJokerPred("p", null);
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(p, post));
		JokerAction a1 = this.getFactory().createJokerAction("A_1", null);
		JokerAction a2 = this.getFactory().createJokerAction("A_2", null);
		ExtChoiceAction a1ExtCA2 = 
			this.getFactory().createExtChoiceAction(Arrays.asList(a1, a2));
		SeqAction left = this.getFactory().createSeqAction(Arrays.asList(ss, 
				a1ExtCA2));

		/* RHS "({ p }; A_1 ) \extchoice ({ p }; A_2 )" */
		SeqAction seq1 = this.getFactory().createSeqAction(Arrays.asList(ss, 
				a1));
		SeqAction seq2 = this.getFactory().createSeqAction(Arrays.asList(ss, 
				a2));
		ExtChoiceAction right = 
			this.getFactory().createExtChoiceAction(Arrays.asList(seq1, seq2));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0654");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.37", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C.38 (Assumption/Parallelism composition�distribution)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionParallelismCompositionDistribution() {

		/* LHS "{ p }; (A1 |[ ns1 | cs | ns2 ]| A2 )" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		JokerPred p = this.getFactory().createJokerPred("p", null);
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(p, post));
		JokerAction a1 = this.getFactory().createJokerAction("A_1", null);
		JokerAction a2 = this.getFactory().createJokerAction("A_2", null);
		JokerNameSet ns1 = this.getFactory().createJokerNameSet("ns_1", null);
		JokerNameSet ns2 = this.getFactory().createJokerNameSet("ns_2", null);
		JokerChannelSet cs = this.getFactory().createJokerChannelSet("cs", 
				null);
		ParallelAction parAction = 
			this.getFactory().createParallelAction(Arrays.asList(a1, a2), 
					Arrays.asList(ns1, ns2), cs);
		SeqAction left = this.getFactory().createSeqAction(Arrays.asList(ss, 
				parAction));

		/* RHS " ({ p }; A_1 ) |[ ns_1 | cs | ns_2 ]| ({ p }; A_2 )" */
		SeqAction seq1 = this.getFactory().createSeqAction(Arrays.asList(ss, 
				a1));
		SeqAction seq2 = this.getFactory().createSeqAction(Arrays.asList(ss, 
				a2));
		ParallelAction right = 
			this.getFactory().createParallelAction(Arrays.asList(seq1, seq2), 
					Arrays.asList(ns1, ns2), cs);

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0655");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.38", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C.39 (Assumption/Interleaving�distribution)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionInterleavingDistribution() {

		/* LHS "{ p }; (A1 ||[ ns1 | ns2 ]|| A2 )" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		JokerPred p = this.getFactory().createJokerPred("p", null);
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(p, post));
		JokerAction a1 = this.getFactory().createJokerAction("A_1", null);
		JokerAction a2 = this.getFactory().createJokerAction("A_2", null);
		JokerNameSet ns1 = this.getFactory().createJokerNameSet("ns_1", null);
		JokerNameSet ns2 = this.getFactory().createJokerNameSet("ns_2", null);
		InterleaveAction parAction = 
			this.getFactory().createInterleaveAction(Arrays.asList(a1, a2), 
					Arrays.asList(ns1, ns2));
		SeqAction left = this.getFactory().createSeqAction(Arrays.asList(ss, 
				parAction));

		/* RHS "({ p }; A_1) ||[ns_1| ns_2]|| ({ p }; A_2)" */
		SeqAction seq1 = this.getFactory().createSeqAction(Arrays.asList(ss, 
				a1));
		SeqAction seq2 = this.getFactory().createSeqAction(Arrays.asList(ss, 
				a2));
		InterleaveAction right = 
			this.getFactory().createInterleaveAction(Arrays.asList(seq1, seq2), 
					Arrays.asList(ns1, ns2));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0656");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.39", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C.41 (Assumption/Prefix-Distribution)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionPrefixDistribution(){

		/* {g};c -> A refines c -> {g};A */

		/* LRS {g};c -> A*/
		JokerPred g = this.getFactory().createJokerPred("g",null);
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		/* {g}*/
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));

		JokerAction a = this.getFactory().createJokerAction("A", null);

		JokerName nomeC = this.factory.createJokerName("c", null);
		RefExpr c = this.factory.createRefExpr(nomeC, 
				this.factory.createZExprList(), false, false);

		FieldList flist = this.getFactory().createCircusFieldList();
		Communication com = this.factory.createCommunication(c, flist, 
				CommUsage.Normal, CommPattern.Input, null, null);
		/* c -> A*/
		PrefixingAction cThenA = this.getFactory().
		createPrefixingAction(a, com);

		/* {g};c -> A */
		SeqAction left = this.getFactory().createSeqAction
		(Arrays.asList(ss, cThenA));

		/* RHS c -> {g};A*/

		SeqAction right = this.getFactory().createSeqAction
		(Arrays.asList(ss,a));

		PrefixingAction rightH = this.getFactory().createPrefixingAction(right, com);


		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Refinement, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, rightH));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0659");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.41", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;

	}

	/**
	 * Cria a lei C.42 (Assumption/Prefix-Distribution 2)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionPrefixDistribution2(){

		/* LRS {g};c -> A*/
		JokerPred g = this.getFactory().createJokerPred("g",null);
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		/* {g}*/
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));

		JokerAction a = this.getFactory().createJokerAction("A", null);

		JokerName nomeC = this.factory.createJokerName("c", null);
		RefExpr c = this.factory.createRefExpr(nomeC, 
				this.factory.createZExprList(), false, false);

		FieldList flist = this.getFactory().createCircusFieldList();
		Communication com = this.factory.createCommunication(c, flist, 
				CommUsage.Normal, CommPattern.Input, null, null);
		/* c -> A*/
		PrefixingAction cThenA = this.getFactory().
		createPrefixingAction(a, com);

		/* {g};c -> A */
		SeqAction left = this.getFactory().createSeqAction
		(Arrays.asList(ss, cThenA));

		/* RHS c -> {g};A*/

		/* {g};A*/
		SeqAction right = this.getFactory().createSeqAction
		(Arrays.asList(ss,a));

		PrefixingAction rightH = this.getFactory().createPrefixingAction
		(right, com);

		SeqAction rightHS = this.getFactory().createSeqAction(
				Arrays.asList(ss,rightH));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, rightHS));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0660");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.42", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;

	}



	/**
	 * Cria a lei C.43 (Assumption/ Simple Prefix-Distribution)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionSimplePrefixDistribution(){

		/* LRS {g};c.ce -> A*/

		JokerPred g = this.getFactory().createJokerPred("g",null);
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		/* {g}*/
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));

		JokerAction a = this.getFactory().createJokerAction("A", null);

		JokerName nomeC = this.factory.createJokerName("c", null);
		RefExpr c = this.factory.createRefExpr(nomeC, 
				this.factory.createZExprList(), false, false);

		JokerName nomeE = this.factory.createJokerName("e", null);
		RefExpr e = this.factory.createRefExpr(nomeE, null, false, false);
		DotField dotE = this.factory.createDotField(e);
		CircusFieldList listaE = 
			this.factory.createCircusFieldList(Arrays.asList(dotE));

		Communication com = this.factory.createCommunication(c, listaE, 
				CommUsage.Normal, CommPattern.Input, null, null);
		/* c -> A*/
		PrefixingAction cThenA = this.getFactory().
		createPrefixingAction(a, com);

		/* {g};c -> A */
		SeqAction left = this.getFactory().createSeqAction
		(Arrays.asList(ss, cThenA));

		/* RHS c -> {g};A*/

		SeqAction right = this.getFactory().createSeqAction
		(Arrays.asList(ss,a));

		PrefixingAction rightH = this.getFactory().createPrefixingAction(right, com);


		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Refinement, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, rightH));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0661");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.43", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;

	}
	/**
	 * Cria a lei C.44 (Assumption/Prefix - Simples Distribution 2)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionSimplePrefixDistribution2(){

		/* LRS {g};c -> A*/
		JokerPred g = this.getFactory().createJokerPred("g",null);
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		/* {g}*/
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));

		JokerAction a = this.getFactory().createJokerAction("A", null);

		JokerName nomeC = this.factory.createJokerName("c", null);
		RefExpr c = this.factory.createRefExpr(nomeC, 
				this.factory.createZExprList(), false, false);
		/* c.e*/
		JokerName nomeE = this.factory.createJokerName("e", null);
		RefExpr e = this.factory.createRefExpr(nomeE, null, false, false);
		DotField dotE = this.factory.createDotField(e);
		CircusFieldList listaE = 
			this.factory.createCircusFieldList(Arrays.asList(dotE));

		Communication com = this.factory.createCommunication(c, listaE, 
				CommUsage.Normal, CommPattern.Input, null, null);
		/* c.e -> A*/
		PrefixingAction cThenA = this.getFactory().
		createPrefixingAction(a, com);

		/* {g};c -> A */
		SeqAction left = this.getFactory().createSeqAction
		(Arrays.asList(ss, cThenA));

		/* RHS c -> {g};A*/

		/* {g};A*/
		SeqAction right = this.getFactory().createSeqAction
		(Arrays.asList(ss,a));

		PrefixingAction rightH = this.getFactory().createPrefixingAction
		(right, com);

		SeqAction rightHS = this.getFactory().createSeqAction(
				Arrays.asList(ss,rightH));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, rightHS));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0662");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.44", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;

	}

	/**
	 * Cria a lei C.45 (Assumption/Output Prefix - Distribution)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionOutputPrefixDistribution(){

		/* LRS {g};c.ce -> A*/

		JokerPred g = this.getFactory().createJokerPred("g",null);
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		/* {g}*/
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));

		JokerAction a = this.getFactory().createJokerAction("A", null);

		JokerName nomeC = this.factory.createJokerName("c", null);
		RefExpr c = this.factory.createRefExpr(nomeC, 
				this.factory.createZExprList(), false, false);

		JokerName nomeX = this.factory.createJokerName("x", null);
		RefExpr x = this.factory.createRefExpr(nomeX, null, false,false);
		DotField outX = this.getFactory().createDotField(x);
		outX.getAnns().add(factory.createOutputFieldAnn());
		CircusFieldList listaE = 
			this.factory.createCircusFieldList(Arrays.asList(outX));

		Communication com = this.factory.createCommunication(c, listaE, 
				CommUsage.Normal, CommPattern.Input, null, null);
		/* c -> A*/
		PrefixingAction cThenA = this.getFactory().
		createPrefixingAction(a, com);

		/* {g};c -> A */
		SeqAction left = this.getFactory().createSeqAction
		(Arrays.asList(ss, cThenA));

		/* RHS c -> {g};A*/

		SeqAction right = this.getFactory().createSeqAction
		(Arrays.asList(ss,a));

		PrefixingAction rightH = this.getFactory().createPrefixingAction(right, com);


		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Refinement, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, rightH));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0663");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.45", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;

	}

	/**
	 * Cria a lei C.46 (Assumption/Output Prefix - Distribution 2)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionOutputPrefixDistribution2(){

		/* LRS {g};c -> A*/
		JokerPred g = this.getFactory().createJokerPred("g",null);
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		/* {g}*/
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));

		JokerAction a = this.getFactory().createJokerAction("A", null);

		JokerName nomeC = this.factory.createJokerName("c", null);
		RefExpr c = this.factory.createRefExpr(nomeC, 
				this.factory.createZExprList(), false, false);
		/* c.e*/
		JokerName nomeX = this.factory.createJokerName("x", null);
		RefExpr x = this.factory.createRefExpr(nomeX, null, false, false);
		DotField outX = this.getFactory().createDotField(x);
		outX.getAnns().add(factory.createOutputFieldAnn());
		CircusFieldList listaE = 
			this.factory.createCircusFieldList(Arrays.asList(outX));

		Communication com = this.factory.createCommunication(c, listaE, 
				CommUsage.Normal, CommPattern.Input, null, null);
		/* c.e -> A*/
		PrefixingAction cThenA = this.getFactory().
		createPrefixingAction(a, com);

		/* {g};c -> A */
		SeqAction left = this.getFactory().createSeqAction
		(Arrays.asList(ss, cThenA));

		/* RHS c -> {g};A*/

		/* {g};A*/
		SeqAction right = this.getFactory().createSeqAction
		(Arrays.asList(ss,a));

		PrefixingAction rightH = this.getFactory().createPrefixingAction
		(right, com);

		SeqAction rightHS = this.getFactory().createSeqAction(
				Arrays.asList(ss,rightH));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, rightHS));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0664");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.46", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;

	}


	/**
	 * Cria a lei C-47 Assumption/Input prefix -- distribution
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionInputPrefixDistribution() {

		/* LHS "c?x \then A" */
		JokerName nomeX = this.factory.createJokerName("x", null);
		InputField inX = this.factory.createInputField(nomeX, 
				this.factory.createTruePred());
		CircusFieldList listaInX = 
			this.factory.createCircusFieldList(Arrays.asList(inX));
		JokerName nomeC = this.factory.createJokerName("c", null);
		RefExpr c = this.factory.createRefExpr(nomeC, 
				this.factory.createZExprList(), false, false);
		Communication cInX = this.factory.createCommunication(c, listaInX, 
				CommUsage.Normal, CommPattern.Input, null, null);
		JokerAction a = this.factory.createJokerAction("A", null);
		PrefixingAction cInXThenA = this.factory.createPrefixingAction(a, cInX);

		/* RHS "c?x \then ({g} \circseq A)" */
		Pred g = this.factory.createJokerPred("g", null);
		SpecStmtCommand assumptionG = 
			this.factory.createSpecStmtCommand(this.factory.createZNameList(), 
					Arrays.asList(g, this.factory.createTruePred()));
		SeqAction assumptionGCircSeqA = 
			this.factory.createSeqAction(Arrays.asList(assumptionG, a));
		PrefixingAction cInXTheAssumptionGCircseqA = 
			this.factory.createPrefixingAction(assumptionGCircSeqA, cInX);

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Refinement, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(cInXThenA, cInXTheAssumptionGCircseqA));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* OP1: "\not(x \in FV_Expr(g))" */
		RefExpr x = this.factory.createRefExpr(nomeX, 
				this.factory.createZExprList(), false, false);
		RefExpr fv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Expr);
		OzFactory factoryAux = new OzFactoryImpl();
		PredExpr exprG = factoryAux.createPredExpr(g);
		ApplExpr fvG = this.factory.createApplExpr(Arrays.asList(fv, exprG), 
				false);
		MemPred xInFvG = this.factory.createMemPred(Arrays.asList(x, fvG), 
				false);
		NegPred notXInFvG = this.factory.createNegPred(xInFvG);

		/* Adiciona a OP1 */
		list.add(notXInFvG);

		/* Nome da lei */
		String nome = this.createName("COD0597");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.47", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C-48 Assumption/Input prefix -- distribution 2
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionInputPrefixDistribution2() {

		/* LRS {g};c -> A*/
		JokerPred g = this.getFactory().createJokerPred("g",null);
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		/* {g}*/
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));

		JokerAction a = this.getFactory().createJokerAction("A", null);

		JokerName nomeC = this.factory.createJokerName("c", null);
		RefExpr c = this.factory.createRefExpr(nomeC, 
				this.factory.createZExprList(), false, false);
		/* c.e*/
		JokerName nomeX = this.factory.createJokerName("x", null);
		InputField inX = this.getFactory().createInputField
		(nomeX, getFactory().createTruePred());
		CircusFieldList listaE = 
			this.factory.createCircusFieldList(Arrays.asList(inX));

		Communication com = this.factory.createCommunication(c, listaE, 
				CommUsage.Normal, CommPattern.Input, null, null);
		/* c.e -> A*/
		PrefixingAction cThenA = this.getFactory().
		createPrefixingAction(a, com);

		/* {g};c -> A */
		SeqAction left = this.getFactory().createSeqAction
		(Arrays.asList(ss, cThenA));

		/* RHS c -> {g};A*/

		/* {g};A*/
		SeqAction right = this.getFactory().createSeqAction
		(Arrays.asList(ss,a));

		PrefixingAction rightH = this.getFactory().createPrefixingAction
		(right, com);

		SeqAction rightHS = this.getFactory().createSeqAction(
				Arrays.asList(ss,rightH));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, rightHS));

		/* Obriga��es de Prova */
		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* OP1: "\not(x \in FV_Expr(g))" */
		RefExpr x = this.factory.createRefExpr(nomeX, 
				this.factory.createZExprList(), false, false);
		RefExpr fv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Expr);
		OzFactory factoryAux = new OzFactoryImpl();
		PredExpr exprG = factoryAux.createPredExpr(g);
		ApplExpr fvG = this.factory.createApplExpr(Arrays.asList(fv, exprG), 
				false);
		MemPred xInFvG = this.factory.createMemPred(Arrays.asList(x, fvG), 
				false);
		NegPred notXInFvG = this.factory.createNegPred(xInFvG);

		/* Adiciona a OP1 */
		list.add(notXInFvG);

		/* Nome da lei */
		String nome = this.createName("COD0665");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.48", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}


	/**
	 * Cria a lei C-49 Assumption/Constrained Input prefix -- distribution
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionConstrainedInputPrefixDistribution() {

		/* LHS "c?x \then A" */
		JokerName nomeX = this.factory.createJokerName("x", null);
		JokerPred t = this.getFactory().createJokerPred("T", null);

		InputField inX = this.factory.createInputField(nomeX, 
				t);
		CircusFieldList listaInX = 
			this.factory.createCircusFieldList(Arrays.asList(inX));
		JokerName nomeC = this.factory.createJokerName("c", null);
		RefExpr c = this.factory.createRefExpr(nomeC, 
				this.factory.createZExprList(), false, false);
		Communication cInX = this.factory.createCommunication(c, listaInX, 
				CommUsage.Normal, CommPattern.Input, null, null);
		JokerAction a = this.factory.createJokerAction("A", null);
		PrefixingAction cInXThenA = this.factory.createPrefixingAction(a, cInX);

		/* RHS "c?x \then ({g} \circseq A)" */
		Pred g = this.factory.createJokerPred("g", null);
		SpecStmtCommand assumptionG = 
			this.factory.createSpecStmtCommand(this.factory.createZNameList(), 
					Arrays.asList(g, this.factory.createTruePred()));
		SeqAction assumptionGCircSeqA = 
			this.factory.createSeqAction(Arrays.asList(assumptionG, a));
		PrefixingAction cInXTheAssumptionGCircseqA = 
			this.factory.createPrefixingAction(assumptionGCircSeqA, cInX);

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Refinement, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(cInXThenA, cInXTheAssumptionGCircseqA));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* OP1: "\not(x \in FV_Expr(g))" */
		RefExpr x = this.factory.createRefExpr(nomeX, 
				this.factory.createZExprList(), false, false);
		RefExpr fv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Expr);
		OzFactory factoryAux = new OzFactoryImpl();
		PredExpr exprG = factoryAux.createPredExpr(g);
		ApplExpr fvG = this.factory.createApplExpr(Arrays.asList(fv, exprG), 
				false);
		MemPred xInFvG = this.factory.createMemPred(Arrays.asList(x, fvG), 
				false);
		NegPred notXInFvG = this.factory.createNegPred(xInFvG);

		/* Adiciona a OP1 */
		list.add(notXInFvG);

		/* Nome da lei */
		String nome = this.createName("COD0667");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.47", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C-50 Assumption/Constrained Input prefix -- distribution 2
	 * 
	 * @return a nova lei Circus
	 */

	public CircusLaw createLawAssumptionConstrainedInputPrefixDistribution2() {

		/* LRS {g};c -> A*/
		JokerPred g = this.getFactory().createJokerPred("g",null);
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		/* {g}*/
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));

		JokerAction a = this.getFactory().createJokerAction("A", null);

		JokerName nomeC = this.factory.createJokerName("c", null);
		RefExpr c = this.factory.createRefExpr(nomeC, 
				this.factory.createZExprList(), false, false);
		/* c.e*/

		JokerName nomeX = this.factory.createJokerName("x", null);
		JokerPred t = this.getFactory().createJokerPred("T",null);
		InputField inX = this.getFactory().createInputField
		(nomeX, t);
		CircusFieldList listaE = 
			this.factory.createCircusFieldList(Arrays.asList(inX));

		Communication com = this.factory.createCommunication(c, listaE, 
				CommUsage.Normal, CommPattern.Input, null, null);
		/* c. -> A*/
		PrefixingAction cThenA = this.getFactory().
		createPrefixingAction(a, com);

		/* {g};c -> A */
		SeqAction left = this.getFactory().createSeqAction
		(Arrays.asList(ss, cThenA));

		/* RHS c -> {g};A*/

		/* {g};A*/
		SeqAction right = this.getFactory().createSeqAction
		(Arrays.asList(ss,a));

		PrefixingAction rightH = this.getFactory().createPrefixingAction
		(right, com);

		SeqAction rightHS = this.getFactory().createSeqAction(
				Arrays.asList(ss,rightH));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, rightHS));

		/* Obriga��es de Prova */
		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* OP1: "\not(x \in FV_Expr(g))" */
		RefExpr x = this.factory.createRefExpr(nomeX, 
				this.factory.createZExprList(), false, false);
		RefExpr fv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Expr);
		OzFactory factoryAux = new OzFactoryImpl();
		PredExpr exprG = factoryAux.createPredExpr(g);
		ApplExpr fvG = this.factory.createApplExpr(Arrays.asList(fv, exprG), 
				false);
		MemPred xInFvG = this.factory.createMemPred(Arrays.asList(x, fvG), 
				false);
		NegPred notXInFvG = this.factory.createNegPred(xInFvG);

		/* Adiciona a OP1 */
		list.add(notXInFvG);

		/* Nome da lei */
		String nome = this.createName("COD0668");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.48", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}

	/**
	 * Cria a lei C-53 Assumption/Schema - Distribution 
	 * 
	 * @return a nova lei Circus
	 */

	public CircusLaw createLawAssumptionSchemaDistribution() {

		/* LHS "{g}; A" */
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		JokerPred g = this.getFactory().createJokerPred("g", null);

		JokerDeclList decl = this.getFactory().createJokerDeclList("decl", null);
		JokerPred p = this.getFactory().createJokerPred("p", null);

		SchText schText = this.getFactory().createZSchText(decl, p);
		SchExpr schExpr = this.getFactory().createSchExpr(schText);
		SchExprAction schAct = this.getFactory().createSchExprAction(schExpr);


		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));

		SeqAction left = this.getFactory().createSeqAction(Arrays.asList(ss, 
				schAct));

		/* RHS " { g }; g & A" */

		SeqAction right = this.getFactory().createSeqAction(Arrays.asList(schAct
				,ss));

		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Refinement, 
				CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* OP1*/

		ImpliesPred imp = this.getFactory().
		createImpliesPred(Arrays.asList(p,g));
		AndPred and = this.getFactory().createAndPred
		(Arrays.asList(g,imp), And.Wedge);

		list.add(and);

		/* Nome da lei */
		String nome = this.createName("COD0669");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.53", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;
	}


	/**
	 * Cria a lei C.54 (Assumption/Assignment-Distribution)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionAssignmentDistribution(){

		/* x := e*/
		JokerNameList x = this.getFactory().createJokerNameList("x", null);
		JokerExprList e = this.getFactory().createJokerExprList("e", null);
		AssignmentPairs pares = this.getFactory().createAssignmentPairs(x, e);
		AssignmentCommand assign = this.getFactory().createAssignmentCommand(pares);

		/* LRS {g};x :=e*/
		JokerPred g = this.getFactory().createJokerPred("g",null);
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		/* {g}*/
		SpecStmtCommand ss = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(g, post));

		SeqAction left = this.getFactory().createSeqAction
		(Arrays.asList(ss, assign));

		
		SeqAction right = this.getFactory().createSeqAction
		(Arrays.asList(left, ss));


		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();
		
		//TODO ajeitar OP
		
		/* OP1: "\not(x \in FV_Expr(g))" */
		JokerName name = this.getFactory().createJokerName(x.getName(), null);
		RefExpr xis = this.factory.createRefExpr(name, 
				this.factory.createZExprList(), false, false);
		RefExpr fv = OPsDischargeUtils.refFuncao(OPsDischargeUtils.FV_Expr);
		OzFactory factoryAux = new OzFactoryImpl();
		PredExpr exprG = factoryAux.createPredExpr(g);
		ApplExpr fvG = this.factory.createApplExpr(Arrays.asList(fv, exprG), 
				false);
		MemPred xInFvG = this.factory.createMemPred(Arrays.asList(xis, fvG), 
				false);
		NegPred notXInFvG = this.factory.createNegPred(xInFvG);

		/* Adiciona a OP1 */
		list.add(notXInFvG);

		/* Nome da lei */
		String nome = this.createName("COD0670");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.54", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;

	}

	/**
	 * Cria a lei C.55 (Assumption Unit)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionUnit(){

				/* LRS {g};x :=e*/
		ZNameList frame = this.getFactory().createZNameList();
		TruePred post = this.getFactory().createTruePred();
		TruePred pre = this.getFactory().createTruePred();		
		/* {g}*/
		SpecStmtCommand left = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(post,pre));

		
		SkipAction right = this.getFactory().createSkipAction(); 
		
		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0671");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.55", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;

	}
	
	
	
	/**
	 * Cria a lei C.56 (Assumption Zero)
	 * 
	 * @return a nova lei Circus
	 */
	public CircusLaw createLawAssumptionZero(){

		/* LRS {g};x :=e*/
		ZNameList frame = this.getFactory().createZNameList();
		FalsePred post = this.getFactory().createFalsePred();
		TruePred pre = this.getFactory().createTruePred();		
		/* {g}*/
		SpecStmtCommand left = this.getFactory().createSpecStmtCommand(frame, 
				Arrays.asList(post,pre));

		
		ChaosAction right = this.getFactory().createChaosAction(); 
		
		/* Criando o Transformer */
		ActionTransformerPred trans = factory.createActionTransformerPred(null, 
				Transformation.Equivalence, CircusUtils.DEFAULT_REFINEMENT_MODEL, 
				Arrays.asList(left, right));

		/* Obriga��es de Prova */
		List<Pred> list = new ArrayList<Pred>();

		/* Nome da lei */
		String nome = this.createName("COD0672");

		CircusLaw result = CircusPattUtils.createCircusLaw(nome, trans, list);

		LawNumberAnn id = new LawNumberAnn("C.56", nome);
		result.getAnns().add(id);
		LawTypeAnnUtils.insertAnnLawType(result, 
				LawType.ACTION_REFINEMENT_ASSUMPTION);

		return result;

	}
	
}
