/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.anotations;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.IffPred;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.visitor.AndPredVisitor;
import net.sourceforge.czt.z.visitor.MemPredVisitor;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerExprBinding;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerPredBinding;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesException;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.messages.MessagesManager;
import circusRefine.core.crules.utils.NormalizeApplier;
import circusRefine.core.crules.utils.ProcessOfATermGetter;
import circusRefine.core.opsdischarge.NormalASTForComparisonGenerator;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.core.opsdischarge.SyntacticFunctionsUtils;
import circusRefine.core.opsdischarge.syntacticfunctions.WrittenVariablesApplier;
import circusRefine.core.util.ParaNameGetter;
import circusRefine.util.Pair;

/**
 * A anotação para aplicar a lei de definição da função \Xi da direita
 * para a esquerda.
 * 
 * @author Cristiano Castro
 */
public class XiRuleApplicationLeftAnn extends LawApplAnn {

	/** 
	 * A lista de variáveis do esquema o qual eu quero transformar
	 * na definição de \Xi  
	 */
	JokerDeclList variablesList;
	
	/**
	 * O predicado do esquema o qual eu quero transformar na definição
	 * de \Xi
	 */
	JokerPred pred;
	
	/**
	 * JokerPred a unificar com a obrigação de prova 
	 */
	JokerPred invSch;
	
	/** 
	 * Nome do parágrafo do processo o qual será utilizado para o 
	 * argumento do \Xi 
	 */
	JokerExpr paraName;
	
	private JokerDeclList getVariablesList() {
		return variablesList;
	}

	private void setVariablesList(JokerDeclList variablesList) {
		this.variablesList = variablesList;
	}

	private JokerPred getPred() {
		return pred;
	}

	private void setPred(JokerPred pred) {
		this.pred = pred;
	}

	private JokerPred getInvSch() {
		return invSch;
	}

	private void setInvSch(JokerPred invSch) {
		this.invSch = invSch;
	}

	private JokerExpr getParaName() {
		return paraName;
	}

	private void setParaName(JokerExpr paraName) {
		this.paraName = paraName;
	}

	/** 
	 * Inicia a anotação de aplicação da lei informando a lista de 
	 *  variáveis a ser unificada e os componentes do esquema a ter
	 *  a lei aplicada
	 *  
	 * @param variaveis o conjunto de variáveis a ser unificada
	 * @param variaveisDashed a lista de variáveis que contem os x 
	 *  e x'
	 * @param predicado o predicado do esquema 
	 */
	public XiRuleApplicationLeftAnn(JokerDeclList variaveis, 
			JokerPred predicado, JokerPred invEquiv, JokerExpr nameOfThePara) {
		this.setVariablesList(variaveis);
		this.setPred(predicado);
		this.setInvSch(invEquiv);
		this.setParaName(nameOfThePara);
	}

	/**
	 * Método que efetivamente aplica a lei de definição de \Xi
	 * 
	 * @param crUtils o objeto que chamou esse método
	 * @param unificacao o conjunto das unificações feitas
	 * @param parametro
	 * @param resposta
	 */
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {

		try {
			
			/* 
			 * C—digo para capturar nome do esquema para qual 
			 * resultar‡ a defini�‹o de \Xi 
			 */
			String schemaMsg = 
				MessagesManager.getInstance().getMessage("SchemaNameCRulesMsg");
			JokerName jokerNameVarSch = this.factory.createJokerName(schemaMsg, 
					null);
			Set<Binding> binds = 
				crUtils.getParameters(Collections.singletonList((Term) 
						jokerNameVarSch), resposta);
			ZName nameParagraph = (ZName)
				XiRuleApplicationLeftAnn.findOriginal(jokerNameVarSch.getName(), 
					binds);
			
			Pred schPred = (Pred) 
				LawApplAnn.findOriginal(this.getPred().getName(), 
					unificacao);
			
			/* Procura o processo no qual foi aplicada a lei */
			CircusProcess proc = ProcessOfATermGetter.getProcess(schPred, 
					crUtils.getInterno().retornarProgAtual());
			
			if (proc instanceof BasicProcess) {
				BasicProcess bp = (BasicProcess) proc;
				
				/* Busca o par‡grafo */
				Para s = null;
				for (Para p : bp.getZParaList()) {
					ZName paraName = ParaNameGetter.getNameList(p);
					if (paraName.getWord().equals(nameParagraph.getWord())) {
						
						/* Achei o par‡grafo */
						s = p;
					}
				}
				
				/* Testa se o par‡grafo s Ž um AxPara */
				if (s instanceof AxPara) {
					
					/* Achei o par‡grafo */
					ConstDecl declSch = (ConstDecl) 
					((AxPara)s).getZSchText().getZDeclList().get(0);
					
					/* Esquema a normalizar */
					Expr sch = declSch.getExpr();
					
					/* Substitui os nomes */
					Term ast = crUtils.getInterno().retornarProgAtual();
					sch = NormalizeApplier.getInstance().substituteNames(sch, 
								ast, crUtils.getInterno());
					
					/* Cria a aplicação do Delta */
					RefExpr deltaFun = 
						OPsDischargeUtils.refFuncao(ZString.DELTA);
					
					/* Aplicação do delta do esquema */
					ApplExpr deltaSch = 
						this.factory.createApplExpr(Arrays.asList(deltaFun, 
								sch), false);
					SchExpr expr = 
						NormalizeApplier.getInstance().applyRewrite(deltaSch);
					Pred invSSDashed = expr.getZSchText().getPred();
					
					/* 
					 * Testa se o esquema é da forma 
					 * P \land (inv(S) \land inv(S'))
					 */
					if (schPred instanceof AndPred) {
						Pred varEquals = ((AndPred) schPred).getLeftPred();
						Pred inv = ((AndPred) schPred).getRightPred();
						
						/* *****************************************
						Compara as listas de declarações 
						***************************************** */
						
						DeclList deltaSDeclList = 
							expr.getZSchText().getDeclList();
						ZDeclList listaSch2 = (ZDeclList)
						LawApplAnn.findOriginal(
								this.getVariablesList().getName(), 
							unificacao);
						
						Term ast1 = 
							NormalASTForComparisonGenerator.gerarFormaNormal(
									deltaSDeclList);
						
						
						Term ast2 = 
							NormalASTForComparisonGenerator.gerarFormaNormal(
									listaSch2);
						
						
						if (! ast1.equals(ast2)){
							
							/* As ASTs da lista de declarações não bate */
							String invalidDeclListMsg = 
								MessagesManager.getInstance().getMessage("COD" +
										"0615");
							throw new XiRuleApplicationException(
									invalidDeclListMsg);
							
						}
						
						/* *****************************************
						Compara se o primeiro termo do predicado é da 
						forma: 
						x = x' \land y = y' \land ... \land	z = z' 
						***************************************** */
						
						/* Captura os pares (x, x') de ZNames */
						HashSet<Pair<ZName, ZName>> vars = 
							this.capturarClausulas(varEquals);
						
						/* Vê se a lista de declaração é do tipo S, S' */
						HashSet<ZName> variaveisDelaradas = 
							SyntacticFunctionsUtils.variaveisDeclaradas(
									listaSch2);
						
						/* Vê se o tamanho das listas são equivalentes */
						if (variaveisDelaradas.size() != 2 * vars.size()) {
							
							String uncompatibleSizeMsg = 
								MessagesManager.getInstance().getMessage("Un" +
										"compatibleVarNumberCRulesMsg");
							throw new 
							XiRuleApplicationException(uncompatibleSizeMsg);
						}
						
						/* Normaliza antes de comparar */
						HashSet<ZName> formaNormalvariaveisDelaradas = 
							new HashSet<ZName>();
						for ( ZName var : variaveisDelaradas ) {
							ZName varToAdd = ( ZName ) 
								NormalASTForComparisonGenerator.gerarFormaNormal( var );
							formaNormalvariaveisDelaradas.add( varToAdd );
						}
							
						for (Pair<ZName, ZName> par : vars) {
							
							/* Normaliza antes de comparars */
							ZName first = ( ZName ) 
							NormalASTForComparisonGenerator.gerarFormaNormal( 
									par.getFirst() );
							ZName second = ( ZName ) 
							NormalASTForComparisonGenerator.gerarFormaNormal( 
									par.getSecond() );
							
							if (!(formaNormalvariaveisDelaradas.contains( first ) && 
								formaNormalvariaveisDelaradas.contains( second ))) {
								
								/* Declaração de variáveis inválida */
								throw new XiRuleApplicationException("COD0615");
							}
						}
						
						/* Passou no teste, agora á montar a lista de declarações */
						ZDeclList aMontar = this.factory.createZDeclList();
						
						/* Variáveis sem marcas */
						HashSet<ZName> undashedVars = new HashSet<ZName>();
						for (Pair<ZName, ZName> par : vars) {
							undashedVars.add(par.getFirst());
						}
						
						/* 
						 * Percorre as declarações da lista de declarações do 
						 * esquema 
						 */
						for (Decl declaracao : listaSch2) {
							if (declaracao instanceof VarDecl) {
								VarDecl varDecl = (VarDecl) declaracao;
								VarDecl nova = 
									this.factory.createVarDecl(
											this.factory.createZNameList(), 
											varDecl.getExpr());
								
								/* Checa os nomes das variáveis declaradas */
								for (Name nome : varDecl.getZNameList()) {
									if (undashedVars.contains(nome)) {
										
										/* 
										 * o nome está na lista de variáveis sem 
										 * strokes 
										 */
										nova.getZNameList().add(nome);
									}
								}
								
								if (!nova.getZNameList().isEmpty()) {
									
									/* 
									 * Lista de nomes é não vazia. Adiciona a 
									 * declaração na lista a ser montada 
									 */
									aMontar.add(nova);
								}
								
								
							} else {
								
								/* Existe uma declaração que não é uma VarDecl */
								throw new XiRuleApplicationException("COD0615");
							}
						}

						/* Preparando o retorno da função */
						RefExpr nomeExpr = 
							this.factory.createRefExpr(nameParagraph, 
									this.factory.createZExprList(), false, 
									false);
						JokerExprBinding nameBind = 
							this.factory.createJokerExprBinding(
									this.getParaName(), nomeExpr);
						unificacao.add(nameBind);
						
						/* 
						 * Cria uma op para verificar a igualdade dos 
						 * invariantes 
						 */
						IffPred op = this.factory.createIffPred(
								Arrays.asList(invSSDashed, inv));
						JokerPredBinding bind = 
							this.factory.createJokerPredBinding(
									this.getInvSch(), op);
						unificacao.add(bind);
						
						HashSet<Term> result = new HashSet<Term>();
						result.add(this.getParaName());
						result.add(this.getPred());
						return result;
						
					} else {
						
						/* 
						 * Predicado inválido para a aplicação da lei 
						 * de \Xi 
						 */
						String invalidPredMsg = 
							MessagesManager.getInstance().getMessage("COD0614");
						throw new XiRuleApplicationException(invalidPredMsg);
					}
					
				} else {
					
					/* 
					 * Esquema passada pelo usuário não é uma definição 
					 * axiomática 
					 */
					String invalidParaMsg = 
						MessagesManager.getInstance().getMessage("InvalidVar" +
								"SchCRulesMsg");
					throw new XiRuleApplicationException(invalidParaMsg);
				}
			} else {
				
				/* Processo não é um BasicProcess*/
				String msg = MessagesManager.getInstance().getMessage("Invali" +
						"dProcessCRulesMsg");
				throw new XiRuleApplicationException(msg);
			}
		} catch (ClassCastException e) {
			throw new XiRuleApplicationException("XiLawError");
		} catch (UnsupportedAstClassException e) {
			throw new XiRuleApplicationException("XiLawError");
		}

	}

	/**
	 * Método utilitário para capturar os nomes sem strokes de um 
	 * predicado da forma x = x' \land ... \land z = z'
	 * 
	 * @param pred o predicado a ser analisado.
	 * @return o conjunto de nomes sem strokes do predicado analisado
	 * @throws XiRuleApplicationException caso ocorra algum erro na 
	 *  operação
	 */
	private HashSet<Pair<ZName, ZName>> capturarClausulas(Pred pred) 
	throws CRulesException {
		try {
			CapturadorClausulas visitor = new CapturadorClausulas();
			return pred.accept(visitor);
		} catch ( XiRuleApplicationRuntimeException e ) {
			
			/* 
			 * Dispara uma excessão informando que não foi possível 
			 * aplicar a XiRule 
			 */
			throw new XiRuleApplicationException( e.getMessage() , e );
		}
	}



	/**
	 * Classe para capturar cláusulas do predicado. Se o predicado for
	 * da forma x' = x \land ... \land z = z', o visitor irá retornar
	 * os nomes das variáveis sem marcas.
	 * 
	 * @author Cristiano Castro
	 */
	private class CapturadorClausulas implements 
		AndPredVisitor<HashSet<Pair<ZName, ZName>>>, 
		MemPredVisitor<HashSet<Pair<ZName, ZName>>>, 
		TermVisitor<HashSet<Pair<ZName, ZName>>> {

		/**
		 * Captura os nomes dos dois lados de uma conjunção
		 * 
		 * @param arg0 a conjunção a ser visitada
		 * @return o conjunto de nomes das variáveis sem marcas dos
		 *  dois lados da conjunção.
		 */
		public HashSet<Pair<ZName, ZName>> visitAndPred(AndPred arg0) {
			HashSet<Pair<ZName, ZName>> result = arg0.getLeftPred().accept(this);
			result.addAll(arg0.getRightPred().accept(this));
			return result;
		}

		/**
		 * Visita um termo de um predicado genérico. Dispara uma 
		 * excessão
		 * 
		 * @param arg0 o termo genérico a ser visitado
		 * @throws XiRuleApplicationException
		 */
		public HashSet<Pair<ZName, ZName>> visitTerm(Term arg0) {
			throw new XiRuleApplicationRuntimeException("COD0614");
		}

		/**
		 * Verifica se o predicado é da forma x' = x ou x = x'. 
		 * Caso positivo o nome com menos {@link Stroke}s é retornado
		 * 
		 * @param arg0 o predicado a ser visitado
		 * @return o conjunto unitário com o nome de menos strokes 
		 *  caso o predicado seja da forma descrita acima.
		 * @throws XiRuleApplicationException caso o predicado não 
		 *  seja da forma descrita acima
		 */
		public HashSet<Pair<ZName, ZName>> visitMemPred(MemPred arg0) {
			HashSet<Pair<ZName, ZName>> result = 
				new HashSet<Pair<ZName, ZName>>(); 
			if (arg0.getMixfix().equals(Boolean.TRUE) && 
					arg0.getRightExpr() instanceof SetExpr) {

				try {

					/* Pode ser uma cláusula de variáveis do tipo x' = x */
					SetExpr singleton = (SetExpr) arg0.getRightExpr();
					RefExpr left = (RefExpr) arg0.getLeftExpr();
					ZExprList listaConjunto = singleton.getZExprList();
					RefExpr right = (RefExpr) listaConjunto.get(0);

					Pair<Boolean, Pair<ZName, ZName>> verificacao = 
						WrittenVariablesApplier.isXDashEqualXType(left, right); 	

					if (verificacao.getFirst()) {

						/* É do tipo x' = x ou x = x' */
						result.add(verificacao.getSecond());
						
					} else {

						/* As variáveis não tem o mesmo nome */
						throw new XiRuleApplicationRuntimeException("COD0614");
					}

				} catch (ClassCastException e) {
					throw new XiRuleApplicationRuntimeException("COD0614", e);
				} catch (UnsupportedAstClassException e) {
					throw new XiRuleApplicationRuntimeException("COD0614", e);
				} catch (IndexOutOfBoundsException e) {
					throw new XiRuleApplicationRuntimeException("COD0614", e);
				}

			}
			
			return result;
		}

	}
	
	// TODO comentar esta classe
	private class XiRuleApplicationRuntimeException extends RuntimeException {

		/**
		 * 
		 */
		private static final long serialVersionUID = -2800804049817674384L;

		/**
		 * 
		 */
		public XiRuleApplicationRuntimeException() {
			super();
			// TODO Auto-generated constructor stub
		}

		/**
		 * @param message
		 * @param cause
		 */
		public XiRuleApplicationRuntimeException(String message, Throwable cause) {
			super(message, cause);
			// TODO Auto-generated constructor stub
		}

		/**
		 * @param message
		 */
		public XiRuleApplicationRuntimeException(String message) {
			super(message);
			// TODO Auto-generated constructor stub
		}

		/**
		 * @param cause
		 */
		public XiRuleApplicationRuntimeException(Throwable cause) {
			super(cause);
			// TODO Auto-generated constructor stub
		}
		
	}

}
