/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.anotations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.z.ast.And;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NextStroke;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TruePred;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerDeclListBinding;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerPredBinding;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.util.ClonerVisitor;

/**
 * Anota��o para a aplica��o da lei de defini��o de \Xi
 * 
 * @author Cristiano Castro
 */
public class XiRuleApplicationAnn extends LawApplAnn {

	/** 
	 * A lista de vari�veis do tipo x, ..., z do esquema cuja 
	 * aplica��o da fun��o \Xi deve ser efetuada
	 */
	private JokerDeclList variaveis;

	/** Lista com as vari�veis a serem montadas, essa lista cont�m  */
	private JokerDeclList variaveisDashed;

	/** 
	 * Predicado a ser montado para a defini��o de Xi. Da forma 
	 * x' = x \land ... \land z' = z 
	 */
	private JokerPred predicado;
	
	/** Op relacionara ao invariante do predicado */
	private JokerPred invariant;

	/**
	 * Inicia o objeto informando as vari�veis a serem trabalhadas 
	 * para aplicar a fun��o \Xi e os jokers a serem unificados com os
	 * resultados dessa aplica��o
	 * 
	 * @param variaveis a joker unificado com lista de vari�veis do 
	 *  esquema no qual ser� aplicada a fun��o \Xi
	 * @param variaveisDashed o joker a ser unificado com a lista de 
	 *  vari�veis do esquema resultante da aplica��o de \Xi
	 * @param predicado o joker a ser unificado com o predicado do 
	 *  esquema a resultante da aplica��o de \Xi
	 */
	public XiRuleApplicationAnn(JokerDeclList variaveis, 
			JokerDeclList variaveisDashed, JokerPred predicado, 
			JokerPred invEquiv) {
		this.setVariaveis(variaveis);
		this.setVariaveisDashed(variaveisDashed);
		this.setPredicado(predicado);
		this.setInvariant(invEquiv);
	}

	/**
	 * @return the predicado
	 */
	protected JokerPred getPredicado() {
		return predicado;
	}

	/**
	 * @param predicado the predicado to set
	 */
	protected void setPredicado(JokerPred predicado) {
		this.predicado = predicado;
	}

	/**
	 * @return the variaveis
	 */
	protected JokerDeclList getVariaveis() {
		return variaveis;
	}

	/**
	 * @param variaveis the variaveis to set
	 */
	protected void setVariaveis(JokerDeclList variaveis) {
		this.variaveis = variaveis;
	}

	/**
	 * @return the variaveisDashed
	 */
	protected JokerDeclList getVariaveisDashed() {
		return variaveisDashed;
	}

	/**
	 * @param variaveisDashed the variaveisDashed to set
	 */
	protected void setVariaveisDashed(JokerDeclList variaveisDashed) {
		this.variaveisDashed = variaveisDashed;
	}

	/**
	 * @return the invariant
	 */
	private JokerPred getInvariant() {
		return invariant;
	}

	/**
	 * @param invariant the invariant to set
	 */
	private void setInvariant(JokerPred invariant) {
		this.invariant = invariant;
	}

	/**
	 * M�todo que efetivamente aplica a lei de defini��o de \Xi.
	 * 
	 * @param crUtils para capturar par�metros
	 * @param unificacao unifica��o dos termos
	 * @param parametro 
	 * @param resposta 
	 * @return os jokers que n�o ser�o mais argumentos a serem definidos 
	 *  pelo usu�rio 
	 */
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {

		/* A lista de vari�veis do esquema */
		ArrayList<Pred> clausulas = new ArrayList<Pred>(); 
		Term listaVariaveis = 
			XiRuleApplicationAnn.findOriginal(this.getVariaveis().getName(), 
					unificacao);
		String msg = "XiLawError";
		
		try {
			ZDeclList declList = (ZDeclList) 
				ClonerVisitor.cloneTermRemovingRelationsStack(listaVariaveis);

			for (Decl declaracao : declList) {
				if (declaracao instanceof VarDecl) {

					/* Declara��o de vari�vel simples */
					ZNameList nomes = ((VarDecl) declaracao).getZNameList();
					ZNameList copia = 
						ClonerVisitor.cloneTermRemovingRelationsStack(nomes);
					Iterator<Name> itr = nomes.iterator(); 
					
					for (Name nome : copia) {
						Name undashedName = itr.next();
						ZName nomeZ = (ZName) nome;
						NextStroke toAdd = this.factory.createNextStroke();
						nomeZ.getZStrokeList().add(toAdd);
						
						/* Adiciona predicado �s clausulas */
						RefExpr undashed = 
							this.factory.createRefExpr(undashedName, 
									this.factory.createZExprList(), false, 
									false);
						RefExpr dashed = this.factory.createRefExpr(nomeZ, 
								this.factory.createZExprList(), false, false);
						List<? extends Expr> singletonList = 
							Collections.singletonList(undashed);
						ZExprList singleList = 
							this.factory.createZExprList(singletonList);
						SetExpr single = this.factory.createSetExpr(singleList);
						MemPred clausula = 
							this.factory.createMemPred(Arrays.asList(dashed, 
									single), true);
						
						clausulas.add(clausula);
					}
					
					/* Adiciona os novos elementos da lista de declara��o */
					((VarDecl) declaracao).getZNameList().addAll(copia);
				} else {
					
					/* Excess�o por lista de nomes inv�lida */
					
					throw new XiRuleApplicationException(msg);
				}

			}
			
			/* Monta as unifica��es para o retorno */
			JokerDeclList jokerAUnificar = this.getVariaveisDashed();
			JokerPred jokerPredAUnificar = this.getPredicado();
			JokerDeclListBinding dlBind = 
				this.factory.createJokerDeclListBinding(jokerAUnificar, 
						declList);
			
			/* Unifica��o para o predicado */
			AndPred and = this.factory.createAndPred(clausulas, And.Chain);
			JokerPredBinding predBind = 
				this.factory.createJokerPredBinding(jokerPredAUnificar,	and);
			unificacao.add(dlBind);
			unificacao.add(predBind);
			
			/* Unificação da op com o true Pred */
			TruePred truePred = this.factory.createTruePred();
			JokerPredBinding opBind = 
				this.factory.createJokerPredBinding(this.getInvariant(), 
						truePred);
			unificacao.add(opBind);
			
			/* Retorna o resultado */
			HashSet<Term> result = new HashSet<Term>();
			result.add(jokerAUnificar); 
			result.add(jokerPredAUnificar);
			result.add(this.getInvariant());
			return result;
			
		} catch (ClassCastException e) {

			/* Excess�o por lista de nomes inv�lida */
			throw new XiRuleApplicationException(msg);
		}

		
	}

}
