/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.anotations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerDeclListBinding;
import net.sourceforge.czt.zpatt.ast.JokerNameList;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.util.BindingGetterVisitor;
import circusRefine.core.util.ClonerVisitor;
import circusRefine.util.Pair;

/**
 * Anotação para a aplicação da lei c-72. Utilizado para separar a
 * DeclList original em duas declList definido a partir dos nomes
 * passados como parâmetro pelo usuário
 * 
 * @author crisgc
 *
 */
public class SeparateDeclListAnn extends LawApplAnn {

	/** O joker a ser unificado com a DeclList original */
	private JokerDeclList original;
	
	/** O joker a ser unificado com a primeira declList */
	private JokerDeclList first;
	
	/** O joker a ser unificado com a segunda declList */
	private JokerDeclList second;

	public SeparateDeclListAnn(JokerDeclList dl, JokerDeclList fst, 
			JokerDeclList snd) {
		this.setOriginal(dl);
		this.setFirst(fst);
		this.setSecond(snd);
	}
	
	public JokerDeclList getOriginal() {
		return original;
	}
	
	public void setOriginal(JokerDeclList original) {
		this.original = original;
	}
	
	public JokerDeclList getFirst() {
		return first;
	}
	
	public void setFirst(JokerDeclList first) {
		this.first = first;
	}
	
	public JokerDeclList getSecond() {
		return second;
	}
	
	public void setSecond(JokerDeclList second) {
		this.second = second;
	}

	@Override
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		
		/* Procura pela lista a ser quebrada em duas */
		ZDeclList original = (ZDeclList)
			LawApplAnn.findOriginal(this.getOriginal().getName(), unificacao);
		
		/* Usuário define os nomes presentes na primeira lista */
		JokerNameList names = 
			this.factory.createJokerNameList("names", null);
		List<Term> nomesUsuario = new LinkedList<Term>();
		nomesUsuario.add(names);
		
		Set<Binding> nomesDefinidos = crUtils.getParameters(nomesUsuario, 
				resposta);
		Term term = null;
		
		for (Binding bind : nomesDefinidos) {
			Pair<String, Term> mapeamento = BindingGetterVisitor.getMap(bind);
			term = mapeamento.getSecond();
		}
		
		/* Nomes que o usuário quer manter no primeiro esquema */
		ZNameList nomeDefUsuario = (ZNameList)term;
		
		/* Monta a lista de Strings usada na comparação */
		List<String> listaNomesUsuario = new LinkedList<String>();
		for (Name n : nomeDefUsuario) {
			listaNomesUsuario.add(((ZName)n).getWord());
		}
		
		/* Montagem das listas */
		ZDeclList dl1 = factory.createZDeclList();
		ZDeclList dl2 = factory.createZDeclList();
		
		for (Decl decl : original) {
			VarDecl declaration = (VarDecl)decl;
			ZNameList nomes = declaration.getZNameList();
			
			/* Nomes na declaração da declList original */
			for (Name nome : nomes) {
				
				/* Monta a declaração de variável */
				List<Name> listaUnit = 
					Arrays.asList((Name)ClonerVisitor.cloneTerm(nome));
				ZNameList novaLista = 
					this.factory.createZNameList(listaUnit);
				Expr expr = 
					(Expr)ClonerVisitor.cloneTerm(declaration.getExpr());
				VarDecl aAdicionar = 
					this.factory.createVarDecl(novaLista, expr);
				
				if ( listaNomesUsuario.contains(((ZName)nome).getWord())) {
					
					/* Adicionar o nome a lista1 */
					
					dl1.add(aAdicionar);
				} else {
					
					/* Adicionar o nome a lista2 */
					dl2.add(aAdicionar);
				}
			}

			
		}
		
		/* Ajusta os bindings da declList1 e declList2 */
		JokerDeclListBinding bind1 = 
			factory.createJokerDeclListBinding(this.getFirst(), dl1);
		JokerDeclListBinding bind2 = 
			factory.createJokerDeclListBinding(this.getSecond(), dl2);
		unificacao.add(bind1);
		unificacao.add(bind2);
		
		Set<Term> toReturn = new HashSet<Term>();
		toReturn.add(this.getFirst());
		toReturn.add(this.getSecond());
		return toReturn;
		
	}

}
