/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.anotations;

import java.util.Set;

import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NextStroke;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;

/**
 * 
 * @author CrisGC
 *
 */
public class SeparateDashedDeclListAnn extends SeparateDeclListAnn {

	/**
	 * Inicia o objeto informando a lista que ir� ser separada. A 
	 * primeira lista e a segunda lista
	 * 
	 * @param dl a lista a ser separada
	 * @param fst a primeira lista a ser montada
	 * @param snd a segunda lista a ser montada
	 */
	public SeparateDashedDeclListAnn(JokerDeclList dl, JokerDeclList fst,
			JokerDeclList snd) {
		super(dl, fst, snd);
	}
	
	@Override
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		
		/* Procura pela lista a ser quebrada em duas */
		ZDeclList original = (ZDeclList)
			LawApplAnn.findOriginal(this.getOriginal().getName(), unificacao);
		
		/* Testa se as declarações são de dashed variables */
		for (Decl decl : original) {
			VarDecl declDashed = (VarDecl)decl;
			ZNameList nomesDashed = declDashed.getZNameList();
			
			/* Nomes presentes na declaração de variáveis */
			for (Name nomeDashed : nomesDashed) {
				ZName zNomeDashed = (ZName)nomeDashed;
				
				/* Checagem para ver o nome está marcado (dashed) */
				boolean check = false; 
				for (Stroke stk : zNomeDashed.getZStrokeList()) {
					if (stk instanceof NextStroke) {
						check = true;
					}
				}
				
				/* Não tem NextStroke */
				if (!check) {
					
					/* Erro na aplicação da lei */
					throw new RuntimeException();
				}
			}
			
		}
		
		return super.apply(crUtils, unificacao, parametro, resposta);
	}

}
