/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.anotations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.rules.RuleApplicationException;
import net.sourceforge.czt.rules.rewriter.RewriteUtils;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import circusRefine.core.InternalManager;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.util.ComparatorVisitor;

/**
 * Classe para testar a aplicabilidade da decomposio de esquemas
 * 
 * @author Cristiano Castro
 */
public class SchemaDecompositionApplAnn extends LawApplAnn {

	/** O esquema original */
	private JokerExpr original;
	
	/** Composicao do esquema original */
	private JokerExpr composition;
	
	/**
	 * @param original
	 * @param composition
	 */
	public SchemaDecompositionApplAnn(JokerExpr original, JokerExpr composition) {
		this.setOriginal(original);
		this.setComposition(composition);
	}

	/**
	 * @return the original
	 */
	private JokerExpr getOriginal() {
		return original;
	}

	/**
	 * @param original the original to set
	 */
	private void setOriginal(JokerExpr original) {
		this.original = original;
	}

	/**
	 * @return the composition
	 */
	private JokerExpr getComposition() {
		return composition;
	}

	/**
	 * @param composition the composition to set
	 */
	private void setComposition(JokerExpr composition) {
		this.composition = composition;
	}

	@Override
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		
		/* Esquema original */
		Expr originalReal = (Expr)
			SchemaDecompositionApplAnn.findOriginal(this.getOriginal().getName(), 
					unificacao);
		
		List<Term> listaJokers = 
			new LinkedList<Term>(Arrays.asList(this.getComposition()));
		Set<Binding> args = 
			crUtils.getInterno().unificarParametros(listaJokers, resposta);
		
		/* Esquema composio */
		Expr compositionReal = (Expr)
		SchemaDecompositionApplAnn.findOriginal(this.getComposition().getName(),
				args);
		
		/* Esquemas normalizados */
		Expr normalOriginal = (Expr)RewriteUtils.rewrite(originalReal, 
				InternalManager.getManager(), "expansion_rules");
		Expr normalComposition = (Expr)RewriteUtils.rewrite(compositionReal, 
				InternalManager.getManager(), "expansion_rules");
		
		if (!ComparatorVisitor.compareStrings(normalOriginal, 
				normalComposition)) {
			throw new RuleApplicationException(null, null, null);
		}
		
		Set<Term> result = new HashSet<Term>();
		result.add(this.getComposition());
		return result;
	}

}
