package circusRefine.core.crules.anotations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.SchExprAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.z.ast.And;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DecorExpr;
import net.sourceforge.czt.z.ast.NextStroke;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerExprBinding;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerNameList;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.CircusLawApplicationException;
import circusRefine.core.crules.utils.DashedTerm;
import circusRefine.core.crules.utils.DefinitionFromATermGetter;
import circusRefine.core.crules.utils.NamesDecFinder;
import circusRefine.core.crules.utils.NamesFinder;
import circusRefine.core.finder.SchemaFinder;
import circusRefine.core.print.Printer;
import circusRefine.core.util.ClonerVisitor;
import circusRefine.util.Pair;

public class ReduceStepAnn extends LawApplAnn {
	
	/** Esquema a ser substitu�do */
	private JokerExpr oldSchema;
	
	/** Esquema substituto */
	private JokerExpr newSchema;
	
	private JokerName name;
	
	
	public ReduceStepAnn(JokerExpr sch1, JokerExpr sch2) {
		oldSchema = sch1;
		newSchema = sch2;
	}
	
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		
		name = factory.createJokerName("Name",null);
		
		/* Procura pelo Ação original */
		Term original =  
			LawApplAnn.findOriginal(oldSchema.getName(),	unificacao);
		
		/** Requisitar inserção do Parametro*/
		/* Para isso define inicialmente o conjunto de parâmetros*/
		List< Term > parametros = new LinkedList<Term>();
		parametros.add(name);

		/* requisita inserção do parâmetro e*/
		Set< Binding > retorno = crUtils.getParameters(parametros, resposta);

		/* Captura o nome da variavel que sera alterada*/
		ZName nome = (ZName)this.findOriginal(name.getName(), retorno);
		
		
		
		List<Pair<ZName, Term>> lista = NamesDecFinder.findAllName(original);
		ZName nomeSchema = null;
		boolean decoratedExpr = false;
		
		for (Pair<ZName, Term> par : lista) {
			if (par.getFirst().getWord().equals(nome.getWord())) {
				
				nomeSchema = par.getFirst();
				if (par.getSecond() instanceof DecorExpr) {
					 DecorExpr expr = (DecorExpr) par.getSecond();
					 if (expr.getStroke() instanceof NextStroke){
						 decoratedExpr = true;
					 }
				}
			}
		}
		
		if (nomeSchema == null) {
			throw new CircusLawApplicationException("The schema does not contain the name");
		}
		/* Busca a ação definida pelo nome */
		
		SchExpr schema = SchemaFinder.getSchema(nome.getWord(), crUtils.getInterno().retornarProgAtual());
		if (schema == null) {
			throw new CircusLawApplicationException("The Definition of the name was not found");
		}
		
		if (decoratedExpr) {
			schema = (SchExpr) DashedTerm.getDashedTerm(schema);
		}
		
		SchExpr termoinicial = (SchExpr) ClonerVisitor.cloneTerm(original);
		
		ZDeclList listaTermoinicial = termoinicial.getZSchText().getZDeclList();
		Pred pred = termoinicial.getZSchText().getPred();
		
		// adicionando as variaveis de declaracao
		listaTermoinicial.addAll(schema.getZSchText().getZDeclList());
		
		Decl aremover = null;
		for (Decl decl : listaTermoinicial) {
			if (Printer.printLATTEX(decl).contains(nome.getWord())) {
				aremover = decl;
			}
		}
		listaTermoinicial.remove(aremover);
		//adicionando predicado
		AndPred andPred = factory.createAndPred(Arrays.asList(pred, schema.getZSchText().getPred()), And.NL);
		
		SchExpr result = factory.createSchExpr(factory.createZSchText(listaTermoinicial, andPred));
		//SchExprAction resultFinal = factory.createSchExprAction(result);
		/* Unificando o x */
		JokerExprBinding  bind1= 
			this.factory.createJokerExprBinding(newSchema, result);
		/* Unificar a Acao*/
		
		unificacao.add(bind1);
		
		
		schema.getZSchText().getZDeclList();
		Set<Term> toReturn = new HashSet<Term>();
		toReturn.add(newSchema);
		return toReturn;
	}

}
