package circusRefine.core.crules.anotations;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerNameBinding;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.CircusLawApplicationException;
import circusRefine.core.crules.UpdateVisitor;
import circusRefine.core.crules.messages.MessagesManager;
import circusRefine.core.crules.utils.CheckRecursitivity;
import circusRefine.core.print.Printer;
import circusRefine.core.util.EqualsTermsUtils;

/**
 * Classe de anota��o utilizada para auxiliar a aplica��o da lei
 * Recursion Unfold
 * @author alessandro87
 *
 */
public class RecursionUnfoldPart2Ann extends LawApplAnn {

	private JokerName x;

	private JokerAction fx;

	private JokerAction FuXFx;

	public RecursionUnfoldPart2Ann(JokerName x, JokerAction fx, JokerAction right) {
		super();
		this.x = x;
		this.FuXFx = right;
		this.fx = fx;
	}


	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao, Term parametro, LawAnswer resposta) throws Exception {

		/** Requisitar inserção do Parametro(Name) X*/
		/* Para isso define inicialmente o conjunto de par�metros*/
		List< Term > parametros = new LinkedList<Term>();
		parametros.add(x);

		/* requisita inserção do parâmetro e*/
		Set< Binding > retorno = crUtils.getParameters(parametros, resposta);

		/* Captura o nome da variavel de recursao*/
		ZName xName = (ZName)this.findOriginal(x.getName(), retorno);		

		CircusAction acaoFuXFx = (CircusAction) 
		LeastFixedPointApplAnn.findOriginal(FuXFx.getName(), 
				unificacao);

		MuAction uXFx =  CheckRecursitivity.getRecursitivityAction(xName, acaoFuXFx);
		boolean teste1 = uXFx != null;
		boolean teste2 = false;
		
		if (teste1){
			/* Substituir em F(x)uXFX, uXFx por X*/
			CallAction xCall = factory.createCallAction(xName);
			CircusAction acao = (CircusAction)UpdateVisitor.update(uXFx, xCall,acaoFuXFx,false);
			teste2 = EqualsTermsUtils.equals(acao, uXFx.getCircusAction());
			if (teste2){
				/* Construir Termo*/
				/* Unificando o x */
				JokerNameBinding  bind1= 
					this.factory.createJokerNameBinding(x, xName);
				/* Unificar a Acao*/
				
				JokerActionBinding bind2 = 
					this.factory.createJokerActionBinding(this.fx, 
							uXFx.getCircusAction());
				
				unificacao.add(bind1);
				unificacao.add(bind2);
				
			}
		}


		if (!teste1 || !teste2){
			/* Nao pode aplicar a lei*/ 
			String msg = MessagesManager.getInstance().getMessage("CRefineLawApplErrorRecursionUnfold");
			throw  new CircusLawApplicationException(msg);
		}

		Set<Term> aRetornar = new HashSet<Term>();
		aRetornar.add(fx);
		aRetornar.add(FuXFx);
		aRetornar.add(x);
		return aRetornar;
	}

}
