/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.anotations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerProcess;
import net.sourceforge.czt.circuspatt.ast.JokerProcessBinding;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.z.impl.ZParaListImpl;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerPredBinding;
import circusRefine.core.InternalManager;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.utils.ParaListGetter;
import circusRefine.core.crules.utils.ProcessFromMainActionMounter;
import circusRefine.core.crules.utils.ProcessesMounter;
import circusRefine.util.Internacional;
import circusRefine.util.Pair;

/**
 * Anota��o para a aplica��o da lei C-146 Process Splitting
 * 
 * @author Cristiano Castro
 */
public class ProcessSplittingApplAnn extends LawApplAnn {

	/**
	 * O joker para a lista de processo no qual a lei deve ser 
	 * aplicada. 
	 */
	private JokerParaList jokerCorpo;
	
	/** Nova defini��o do processo original */
	private JokerProcess novoProcesso;
	
	/** Predicado a ser unificado com a obriga��o de prova da lei  */
	private JokerPred op;
	
	/**
	 * Atributo para a internacionaliza��o das mensagens dos par�metros
	 */
	private Internacional inter;
	
	private InternalManager gerInterno;
	
	/**
	 * O construtor do aplicador da lei
	 * 
	 * @param lista a lista com os par�grafos do BasicProcess que se
	 *  pretende quebrar segundo a lei C-146
	 */
	public ProcessSplittingApplAnn(JokerParaList lista, Internacional inter, 
			JokerProcess novaDefinicaoProcesso, JokerPred op, InternalManager gerInt) {
		this.setJokerCorpo(lista);
		this.setInter(inter);
		this.setNovoProcesso(novaDefinicaoProcesso);
		this.setOp(op);
		gerInterno = gerInt;
	}
	
	private JokerParaList getJokerCorpo() {
		return jokerCorpo;
	}
	
	private void setJokerCorpo(JokerParaList jokerCorpo) {
		this.jokerCorpo = jokerCorpo;
	}
	
	private Internacional getInter() {
		return inter;
	}
	
	private void setInter(Internacional inter) {
		this.inter = inter;
	}
	
	/**
	 * @return the novoProcesso
	 */
	private JokerProcess getNovoProcesso() {
		return novoProcesso;
	}

	/**
	 * @param novoProcesso the novoProcesso to set
	 */
	private void setNovoProcesso(JokerProcess novoProcesso) {
		this.novoProcesso = novoProcesso;
	}

	private JokerPred getOp() {
		return op;
	}

	private void setOp(JokerPred op) {
		this.op = op;
	}

	@Override
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception  {
		
		ZParaList paragrafos = 
			(ZParaList)LawApplAnn.findOriginal(this.getJokerCorpo().getName(), 
					unificacao);
		Vector z = new Vector();
		Vector z2 = new Vector();
		z.addAll(paragrafos.get(0).getAnns());
		z.addElement(paragrafos.get(1).getChildren());
		
		BasicProcess processo = factory.createBasicProcess(paragrafos);
		
		ZParaListImpl z3 = (ZParaListImpl) paragrafos;
		z3.getChildren();
		
		processo.getLocalPara();
		processo.getMainAction();
		processo.getOnTheFlyPara();
		processo.getChildren();
		z2.addElement(processo.getParaList());
		processo.getStatePara();
		processo.getZParaList();
		processo.getStateParaZName();
		processo.getStateParaName();
		processo.getStatePara();
		
		
		/* Par�metros a serem definidos pelo usu�rio */
		/* Nomes dos novos processos */
		JokerName nomePrimeiroProcesso = 
			factory.createJokerName(this.getInter().retornarMensagem("COD0561"),
					null);
		JokerName nomeSegundoProcesso =
			factory.createJokerName(this.getInter().retornarMensagem("COD0562"),
					null);
		
		/* A��o principal dos novos processo */
		JokerAction acaoPrincipalPrimeiroProcesso = 
			this.factory.createJokerAction(
					this.getInter().retornarMensagem("COD0564"), null);
		JokerAction acaoPrincipalSegundoProcesso = 
			this.factory.createJokerAction(
					this.getInter().retornarMensagem("COD0565"), null);
		
		/* Par�metros a serem definidos pelo usu�rio */
		List<Term> parametros = new LinkedList<Term>();
		parametros.add(nomePrimeiroProcesso);
		parametros.add(nomeSegundoProcesso);
		parametros.add(acaoPrincipalPrimeiroProcesso);
		parametros.add(acaoPrincipalSegundoProcesso);
		
		Set<Binding> ligacoes = crUtils.getParameters(parametros, resposta);
		
		/* Monta o processo de acordo com os par�metros */
		Pair<Pair<Pair<ProcessPara, ProcessPara>, Pred>, CircusProcess> par = 
			this.montarProcessos(processo, ligacoes, 
					(Spec) crUtils.getInterno().retornarProgAtual());
		Pair<Pair<ProcessPara, ProcessPara>, Pred> montados = par.getFirst();
		Pair<ProcessPara, ProcessPara> montagem = montados.getFirst();
		
		Term progAtual = crUtils.getInterno().retornarProgAtual();
		ZParaList paragrafosSpec = 
			ParaListGetter.retornarZParaList(progAtual, 
					paragrafos);
		
		/* procura pelo �ndice do par�grafo */
		int idx = 0;
		for (Para para : paragrafosSpec) {
			if (para instanceof ProcessPara) {
				ProcessPara processPara = (ProcessPara) para;
				
				if (processPara.getCircusProcess() instanceof BasicProcess) {
					BasicProcess basicProcess = 
						(BasicProcess)processPara.getCircusProcess();
					
					if (basicProcess.getParaList().equals(paragrafos)) {
						
						/* Achou!! */
						break;
					}
				}
			}
			idx++;
		}
		
		paragrafosSpec.addAll(idx, 
				Arrays.asList(montagem.getFirst(), montagem.getSecond()));
		
		/* Faz a liga��o do processo com sua nova defini��o */
		JokerProcessBinding bind = 
			this.factory.createJokerProcessBinding(
					this.getNovoProcesso(), par.getSecond());
		JokerPredBinding bindOP = 
			this.factory.createJokerPredBinding(this.getOp(), 
					montados.getSecond());
		
		/* Adiciona nova unifica��o */
		unificacao.add(bind);
		unificacao.add(bindOP);
		
		/* Tira o novo processo do conjunto de par�metros */
		return new HashSet<Term>(Arrays.asList(this.getNovoProcesso()));
	}
	
	
	/**
	 * Monta os novos processos resultantes da aplica��o da lei e a 
	 * nova defini��o do processo Original
	 * 
	 * @param original o processo original
	 * @param parametros as unifica��es
	 * @return o par com os novos par�grafos do processo e a nova 
	 *  defini��o do processo original
	 */
	private Pair<Pair<Pair<ProcessPara, ProcessPara>, Pred>, CircusProcess>
		montarProcessos(BasicProcess original, Set<Binding> parametros, 
				Spec ast) {

		/* Recupera os nomes dos processos */
		ZName nomePrimeiroProcesso = (ZName) 
			LawApplAnn.findOriginal(this.getInter().retornarMensagem("COD0561"),
					parametros);
		ZName nomeSegundoProcesso = (ZName)
			LawApplAnn.findOriginal(this.getInter().retornarMensagem("COD0562"), 
					parametros);
		
		/* A��es principais dos processos */
		CircusAction acaoPrincipalPrimeiroProcesso = (CircusAction)
			LawApplAnn.findOriginal(this.getInter().retornarMensagem("COD0564"),
					parametros);
		CircusAction acaoPrincipalSegundoProcesso = (CircusAction)
			LawApplAnn.findOriginal(this.getInter().retornarMensagem("COD0565"),
					parametros);
		
		/* 
		 * Monta os novos par�grafos do processo e a nova defini��o do
		 * processo orginal 
		 */
		Pair<Pair<ProcessPara, ProcessPara>, Pred> paras = 
			ProcessesMounter.montarProcessos(nomePrimeiroProcesso, 
				nomeSegundoProcesso, acaoPrincipalPrimeiroProcesso, 
				acaoPrincipalSegundoProcesso, original, ast, gerInterno);
		CircusAction mainAction = original.getMainAction();
		CircusProcess novaDef = 
			ProcessFromMainActionMounter.montarProcesso(mainAction, 
					acaoPrincipalPrimeiroProcesso, acaoPrincipalSegundoProcesso, 
					nomePrimeiroProcesso, nomeSegundoProcesso);		
		return new Pair<Pair<Pair<ProcessPara, ProcessPara>, Pred>, CircusProcess>(paras, novaDef);
	}
	
	
	
}
