/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.anotations;

import java.util.HashSet;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.rules.UnboundJokerException;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerExprBinding;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.utils.NormalizationApplicationException;
import circusRefine.core.crules.utils.NormalizeApplier;
import circusRefine.core.opsdischarge.syntacticfunctions.CannotEvaluateRunTimeException;
import circusRefine.core.print.Printer;

/**
 * Anota��o para aplicar uma normaliza��o a um esquema
 * 
 * @author Cristiano Gurgel
 */
public class NormalizeApplAnn extends LawApplAnn {

	/** Esquema a ser substitu�do */
	private JokerExpr oldSchema;
	
	/** Esquema substituto */
	private JokerExpr newSchema;

	/**
	 * Inicia a classe com o joker que ir� fazer refer�ncia ao esquema
	 * que ser� normalizado
	 * 
	 * @param newSchema o joker para o esquema a ser normalizado
	 */
	public NormalizeApplAnn(JokerExpr sch1, JokerExpr sch2) {
		this.setOldSchema(sch1);
		this.setNewSchema(sch2);
	}

	private JokerExpr getOldSchema() {
		return oldSchema;
	}

	private void setOldSchema(JokerExpr schema) {
		this.oldSchema = schema;
	}

	/**
	 * @return the newSchema
	 */
	private JokerExpr getNewSchema() {
		return newSchema;
	}

	/**
	 * @param newSchema the newSchema to set
	 */
	private void setNewSchema(JokerExpr newSchema) {
		this.newSchema = newSchema;
	}

	@Override
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer reposta) throws CommandException, 
			UnboundJokerException {

		/* Procura pelo Ação original */
		Term result =  
			LawApplAnn.findOriginal(this.getOldSchema().getName(),	unificacao);
		
		
		/* Achou!!! */
		Expr original = (Expr) result;
		original = NormalizeApplier.getInstance().substituteNames(original, 
				crUtils.getInterno().retornarProgAtual(), crUtils.getInterno());
		

		SchExpr resultRewrite;
		try {
			resultRewrite = 
				NormalizeApplier.getInstance().applyRewrite(original);
			
		} catch (NormalizationApplicationException e) {
			
			/* Erro na aplica��o da lei */
			throw new CannotEvaluateRunTimeException(e);
		}

		/* Cria o binding para o circusAction */
		JokerExprBinding binding = 
			factory.createJokerExprBinding(this.getNewSchema(),	
					(Expr)resultRewrite);
		unificacao.add(binding);

		Set<Term> toReturn = new HashSet<Term>();
		toReturn.add(this.getNewSchema());
		return toReturn;
	}
	

	
	
}
