/*
 * Projeto: Circus Refine
 * Autor: Cristiano Gurgel de Castro
 */
package circusRefine.core.crules.anotations;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerName;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.UpdateVisitor;

/**
 * Anotao para a aplicao da lei Recursion--least Fixed Point
 * 
 * @author Cristiano Castro
 */
public class LeastFixedPointApplAnn extends LawApplAnn {

	/** O joker que ir se ligar com o nome X */
	private JokerName x;
	
	/** O joker que ir se ligar com a ao F(X) */
	private JokerAction fX;
	
	/** O joker que ir se ligar com a ao Y */
	private JokerAction y;
	
	/** O joker que ir se ligar com a ao F(Y) */
	private JokerAction fY;

	/**
	 * Construtor.  inicializado com as variveis usadas para montar
	 * as parties do processo.
	 * 
	 * @param newX o joker que ir se unificar ao nome X
	 * @param newFX o joker que ir se unificar  ao F(X)
	 * @param newY o joker que ir se unificar  ao Y
	 * @param newFY o joker que ir se unificar  ao F(Y)
	 */
	public LeastFixedPointApplAnn( JokerName newX, JokerAction newFX,
			JokerAction newY, JokerAction newFY ) {
		this.setX(newX);
		this.setFX(newFX);
		this.setY(newY);
		this.setFY(newFY);
	}
	
	private JokerName getX() {
		return x;
	}
	
	private void setX(JokerName x) {
		this.x = x;
	}
	
	private JokerAction getFX() {
		return fX;
	}
	
	private void setFX(JokerAction fx) {
		fX = fx;
	}
	
	private JokerAction getY() {
		return y;
	}
	
	private void setY(JokerAction y) {
		this.y = y;
	}
	
	private JokerAction getFY() {
		return fY;
	}
	
	private void setFY(JokerAction fy) {
		fY = fy;
	}
	
	@Override
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		
		CircusAction acaoFX = (CircusAction) 
			LeastFixedPointApplAnn.findOriginal(this.getFX().getName(), 
					unificacao);
		ZName acaoX = (ZName) 
			LeastFixedPointApplAnn.findOriginal(this.getX().getName(), 
					unificacao);
		
		CallAction aSubstituir = this.factory.createCallAction(acaoX);
		List< Term > parametros = new LinkedList<Term>();
		parametros.add(this.getY());
		
		/* Definio do Y */
		Set< Binding > result = crUtils.getParameters(parametros, resposta);
		
		CircusAction acaoY = (CircusAction)
			LeastFixedPointApplAnn.findOriginal(this.getY().getName(), result);
		
		/* Substituindo a ao X pela ao Y para montar F(Y) */
		Term acaoFY = UpdateVisitor.update(aSubstituir, acaoY, acaoFX,false);

		unificacao.addAll(result); /* Unificando y  */
		
		/* Unificando o F(Y) */
		JokerActionBinding bind = 
			this.factory.createJokerActionBinding(this.getFY(), 
					(CircusAction)acaoFY);
		unificacao.add(bind);
		
		Set<Term> aRetornar = new HashSet<Term>();
		aRetornar.add(this.getY());
		aRetornar.add(this.getFY());
		return aRetornar;
	}

}
