package circusRefine.core.crules.anotations;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.circuspatt.ast.JokerPara;
import net.sourceforge.czt.circuspatt.ast.JokerParaBinding;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerProcess;
import net.sourceforge.czt.circuspatt.ast.JokerProcessBinding;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ParaList;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.util.ClonerVisitor;

/**
 * Utilizado para realizar o processo
 * @author Alessandro
 *
 */
public class DataRefinementProcessLawAnn extends LawApplAnn {

	private JokerProcess left;
	private JokerProcess right;
	
	private JokerAction act1;
	private JokerAction act2;
	
	
	
	public DataRefinementProcessLawAnn(JokerProcess left, JokerProcess right,
				JokerAction act1, JokerAction act2) {
		this.left = left;
		this.right = right;
		this.act1 = act1;
		this.act2 = act2;
	}

	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		
		BasicProcess procAntigo = (BasicProcess) findOriginal(left.getName(), unificacao);
		
		/* Parâmetros*/
		
		LinkedList<Term> lista = new LinkedList<Term>();
		lista.add(right);
		Set< Binding > retorno = crUtils.getParameters(lista, resposta);
		
		BasicProcess procNovo = (BasicProcess) findOriginal(right.getName(), retorno);
		
		CircusAction main1 = procAntigo.getMainAction();
		CircusAction main2 = procNovo.getMainAction();
		
		
		
		JokerProcessBinding binding = factory.createJokerProcessBinding(right, procNovo);
		
		JokerActionBinding binding2 = factory.createJokerActionBinding(act1, main1);
		JokerActionBinding binding3 = factory.createJokerActionBinding(act2, main2);
		
		unificacao.add(binding);
		unificacao.add(binding2);
		unificacao.add(binding3);
		
		Set<Term> aRetornar = new HashSet<Term>();
		aRetornar.add(right);
		aRetornar.add(act1);
		aRetornar.add(act2);
		
		return aRetornar;
	}

}
