package circusRefine.core.crules.anotations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.SchExprAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import circusRefine.core.LawAnswer;
import circusRefine.core.annotations.StatementSchExprAnn;
import circusRefine.core.crules.CRulesUtils;

public class ConjuctionConversionAnn extends LawApplAnn{

	private JokerAction right;
	private JokerExpr expr1, expr2;
	
	public ConjuctionConversionAnn(JokerExpr expr1, JokerExpr expr2,
			JokerAction right) {
		this.right = right;
		this.expr1 = expr1;
		this.expr2 = expr2;
	}

	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		
		SchExpr action1 =  (SchExpr) LawApplAnn.findOriginal(expr1.getName(), unificacao);
		SchExpr action2 =  (SchExpr) LawApplAnn.findOriginal(expr2.getName(), unificacao);
		
		SchExprAction act1 = factory.createSchExprAction(action1);
		SchExprAction act2 = factory.createSchExprAction(action2);
		
		SeqAction  result = factory.createSeqAction(Arrays.asList(act1, act2));
		
		/* Não é aceito a aplicação de lei sobre um statement, pois quebra o ConstDecl == Expr
		 * Então será utilizado esse termo para guardar o real termo(anotação)*/
		SchExprAction capsula = factory.createSchExprAction(factory.createSchExpr());
		capsula.getExpr().getAnns().add(new StatementSchExprAnn(result));
		
		/* Unificando o termo da direita */
		JokerActionBinding  bind1= 
			this.factory.createJokerActionBinding(right, capsula);
		/* Unificar a Acao*/
		
		unificacao.add(bind1);
		
		
		Set<Term> aRetornar = new HashSet<Term>();
		aRetornar.add(right);
		return aRetornar;
	}

}
