package circusRefine.core.crules.anotations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.SchExprAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.oz.ast.PredExpr;
import net.sourceforge.czt.z.ast.And;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.CompExpr;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.ExprPred;
import net.sourceforge.czt.z.ast.ImpliesPred;
import net.sourceforge.czt.z.ast.InStroke;
import net.sourceforge.czt.z.ast.InclDecl;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.PreExpr;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.impl.InStrokeImpl;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerPredBinding;
import circusRefine.core.LawAnswer;
import circusRefine.core.annotations.StatementSchExprAnn;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.CircusLawApplicationException;
import circusRefine.core.crules.messages.MessagesManager;
import circusRefine.core.crules.utils.DashedTerm;
import circusRefine.core.crules.utils.RestrictionsGetter;
import circusRefine.core.finder.SchemaFinder;
import circusRefine.core.print.Printer;

public class CompositionConversationAnn extends LawApplAnn {

	private JokerAction right;
	private JokerExpr expr1, expr2;
	private JokerPred pred;
	
	public CompositionConversationAnn(JokerExpr expr1, JokerExpr expr2,
			JokerAction right, JokerPred pred) {
		this.right = right;
		this.expr1 = expr1;
		this.expr2 = expr2;
		this.pred = pred;
	}
	
	
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		SchExpr action1 =  (SchExpr) LawApplAnn.findOriginal(expr1.getName(), unificacao);
		SchExpr action2 =  (SchExpr) LawApplAnn.findOriginal(expr2.getName(), unificacao);
		
		SchExprAction act1 = factory.createSchExprAction(action1);
		SchExprAction act2 = factory.createSchExprAction(action2);
		
		SeqAction  result = factory.createSeqAction(Arrays.asList(act1, act2));
		
		/* Não é aceito a aplicação de lei sobre um statement, pois quebra o ConstDecl == Expr
		 * Então será utilizado esse termo para guardar o real termo(anotação)*/
		SchExprAction capsula = factory.createSchExprAction(factory.createSchExpr());
		capsula.getExpr().getAnns().add(new StatementSchExprAnn(result));
		
		/* Unificando o termo da direita */
		JokerActionBinding  bind1= 
			this.factory.createJokerActionBinding(right, capsula);
		/* Unificar a Acao*/
		
		unificacao.add(bind1);
		
		ZDeclList declaracoesOperacao = action1.getZSchText().getZDeclList();
		boolean notDeltaS = true;
		
		String nomeState = ""; //guarda o nome do estado
		
		ZDeclList listInputA1 = factory.createZDeclList();
		
		for (Decl decl : declaracoesOperacao) {
			if (decl instanceof InclDecl){
				InclDecl incDecl = (InclDecl)decl;
				String strName = Printer.printLATTEX(incDecl);
				if (strName.contains("\\Delta") || strName.contains(ZString.DELTA) ) {
					notDeltaS = false;
					nomeState = strName.replace("\\Delta", "");
					nomeState = nomeState.replace(" ", "");
				}
			}
			else if (decl instanceof VarDecl) {
				ZNameList nomes = ((VarDecl)decl).getZNameList();
				for (Name a : nomes){
					ZName az = (ZName)a;
					for (Stroke s: az.getZStrokeList()){
						if (s instanceof InStroke){
							listInputA1.add(factory.createVarDecl(factory.createZNameList(Arrays.asList(a)),
									((VarDecl)decl).getExpr()));
						}
					}
				}
				
			}
		}
		
		
		if (notDeltaS) {
			String msg = MessagesManager.getInstance().getMessage("DeltaSError");
			throw  new CircusLawApplicationException(msg); 
		}
		/* Teste para segunda acao*/
		notDeltaS = false;
		ZDeclList listInputA2 = factory.createZDeclList();
		ZDeclList declaracoesOperacao2 = action2.getZSchText().getZDeclList();
		
		
		for (Decl decl : declaracoesOperacao2) {
			if (decl instanceof InclDecl){
				InclDecl incDecl = (InclDecl)decl;
				String strName = Printer.printLATTEX(incDecl);
				if (strName.contains("\\Delta") || strName.contains(ZString.DELTA) ) {
					notDeltaS = false;
					nomeState = strName.replace("\\Delta", "");
					nomeState = nomeState.replace(" ", "");
				}
			}
			else if (decl instanceof VarDecl) {
				ZNameList nomes = ((VarDecl)decl).getZNameList();
				for (Name a : nomes){
					ZName az = (ZName)a;
					for (Stroke s: az.getZStrokeList()){
						if (s instanceof InStroke){
							listInputA2.add(factory.createVarDecl(factory.createZNameList(Arrays.asList(a)),
									((VarDecl)decl).getExpr()));
						}
					}
				}
				
			}
		}
		
		if (notDeltaS) {
			String msg = MessagesManager.getInstance().getMessage("DeltaSError");
			throw  new CircusLawApplicationException(msg); 
		}
		
		/* Pegar o schema com o nomeState*/
		SchExpr estado = SchemaFinder.getSchema(nomeState, crUtils.getInterno().retornarProgAtual());

		if (estado == null) {
			String msg = MessagesManager.getInstance().getMessage("SNotFoundError");
			throw  new CircusLawApplicationException(msg);
		}
		
		/* Pegar o invariante do Schema Estado*/
		Pred invariante = estado.getZSchText().getPred();
		if (invariante == null) {invariante = factory.createTruePred();}
		
		ZDeclList list = estado.getZSchText().getZDeclList();
		Pred restricaoT = RestrictionsGetter.getRestriction(list, invariante);
		
		
		Pred predOp1 = action1.getZSchText().getPred();
		Pred predOp2 = action2.getZSchText().getPred();
		
		Pred restricaoT1 =  RestrictionsGetter.getRestriction(listInputA1, predOp1);
		Pred restricaoT2 =  RestrictionsGetter.getRestriction(listInputA2, predOp2);
		
		
		/*Montar o predicado*/
		
		CompExpr comp = factory.createCompExpr(Arrays.asList(action1,action2));
		PreExpr preComp = factory.createPreExpr(comp);
		ExprPred pred0 = factory.createExprPred(preComp);
		
		
		AndPred pred1 = factory.createAndPred(Arrays.asList(pred0, restricaoT), And.NL);
		AndPred pred11 = factory.createAndPred(Arrays.asList(pred1, restricaoT1), And.NL);
		AndPred preC = factory.createAndPred(Arrays.asList(pred11, restricaoT2), And.NL);
		
		AndPred preCAndOp1 = factory.createAndPred(Arrays.asList(preC, predOp1), And.Wedge);
		
		PreExpr pre2 = factory.createPreExpr(action2);
		PreExpr pre2linha = (PreExpr) DashedTerm.getDashedTerm(pre2);
		ImpliesPred predFinal = factory.createImpliesPred(Arrays.asList(preCAndOp1, factory.createExprPred(pre2linha)));
		
		/* Unificando o termo da direita */
		JokerPredBinding  bind2= 
			this.factory.createJokerPredBinding(pred, predFinal);
		/* Unificar a Acao*/
		
		unificacao.add(bind2);

		
		Set<Term> aRetornar = new HashSet<Term>();
		aRetornar.add(right);
		aRetornar.add(pred);
		return aRetornar;
	}

}
