/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.anotations;

import java.util.HashSet;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circuspatt.ast.JokerCommunication;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerExprBinding;
import circusRefine.core.LawAnswer;
import circusRefine.core.crules.CRulesUtils;

/**
 * Classe utilizada na aplicao da lei C.83 (Channel extension 4)
 * para montar a obrigao de prova.
 * 
 * @author Cristiano Castro
 */
public class ChannelNameGetter extends LawApplAnn {

	/** Comunicao a ter o nome associado com a expresso */
	private JokerCommunication comm;
	
	/** A joker que ir ser ligado ao nome do canal */
	private JokerExpr expr;
	
	/**
	 * Inicia o objeto informando o joker ligado com o canal e o 
	 * jokerExpr a ser ligado com o nome do canal
	 * 
	 * @param comm o joker da comunicao
	 * @param expr o joker que ir ser ligado com o nome do canal
	 */
	public ChannelNameGetter(JokerCommunication comm, JokerExpr expr) {
		this.setComm(comm);
		this.setExpr(expr);
	}

	/**
	 * @return the comm
	 */
	private JokerCommunication getComm() {
		return comm;
	}

	/**
	 * @param comm the comm to set
	 */
	private void setComm(JokerCommunication comm) {
		this.comm = comm;
	}

	/**
	 * @return the expr
	 */
	private JokerExpr getExpr() {
		return expr;
	}

	/**
	 * @param expr the expr to set
	 */
	private void setExpr(JokerExpr expr) {
		this.expr = expr;
	}

	@Override
	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao,
			Term parametro, LawAnswer resposta) throws Exception {
		
		/* Pegando a comunicao real do programa */
		Term commReal = ChannelNameGetter.findOriginal(this.getComm().getName(),
				unificacao);

		/* Criando a nova communicao do nome do canal com a expresso */
		JokerExprBinding novaLigacao = 
			this.factory.createJokerExprBinding(this.getExpr(), 
					((Communication) commReal).getChannelExpr());
		
		/* Adiciona o novo binding a lista */
		unificacao.add(novaLigacao);

		/*  */
		HashSet<Term> toReturn = new HashSet<Term>();
		toReturn.add(this.getExpr());
		return toReturn;
	}

}
