package circusRefine.core.crules.anotations;

import java.awt.Stroke;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.SchExprAction;
import net.sourceforge.czt.circus.ast.SpecStmtCommand;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.z.ast.And;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.ExistsPred;
import net.sourceforge.czt.z.ast.InclDecl;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.OutStroke;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.impl.OutStrokeImpl;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import circusRefine.core.LawAnswer;
import circusRefine.core.annotations.StatementSchExprAnn;
import circusRefine.core.annotations.TemporaryTermAnn;
import circusRefine.core.crules.CRulesUtils;
import circusRefine.core.crules.CircusLawApplicationException;
import circusRefine.core.crules.UpdateVisitor;
import circusRefine.core.crules.messages.MessagesManager;
import circusRefine.core.crules.utils.DashedTerm;
import circusRefine.core.crules.utils.DeclUtils;
import circusRefine.core.finder.SchemaFinder;
import circusRefine.core.print.Printer;
import circusRefine.core.util.ClonerVisitor;

/**
 * Anotação utilizada para transforma um schema de operação 
 * em um specification statement
 * @author alessandro87
 *
 */
public class BasicConversionXiOperationAnn extends LawApplAnn {

	private JokerDeclList declsOp;
	private JokerPred predOp;
	private SchExprAction left;
	private JokerAction right;

	public BasicConversionXiOperationAnn(JokerDeclList d, JokerPred p, SchExprAction left, JokerAction right) {
		this.declsOp = d;
		this.predOp = p;
		this.left = left;
		this.right = right;
	}

	public Set<Term> apply(CRulesUtils crUtils, Set<Binding> unificacao, Term parametro, LawAnswer resposta) throws Exception {

		CircusPatternFactoryImpl factory = new CircusPatternFactoryImpl();

		/* Verificar se a operação contém uma variação de estado. Ou seja, um Delta S*/
		ZDeclList declaracoesOperacao = (ZDeclList) 
		LawApplAnn.findOriginal(declsOp.getName(), 
				unificacao);

		ZDeclList outputDeclaracoes = factory.createZDeclList();

		boolean notXiS = true;
		String nomeState = ""; //guarda o nome do estado

		for (Decl decl : declaracoesOperacao) {
			if (decl instanceof InclDecl){
				InclDecl incDecl = (InclDecl)decl;
				String strName = Printer.printLATTEX(incDecl);
				if (strName.contains("\\Xi") || strName.contains(ZString.XI) ) {
					notXiS = false;
					nomeState = strName.replace("\\Xi", "");
					nomeState = nomeState.replace(" ", "");
				}
			}
			/* capturar o declOutput;*/
			else if (decl instanceof VarDecl) {
				VarDecl varDecl = (VarDecl)decl;
				for (Name name : varDecl.getZNameList()) {
					if (name instanceof ZName){
						ZName zname = (ZName)name;
						
						for (net.sourceforge.czt.z.ast.Stroke stroke : zname.getZStrokeList()) {
							if (stroke instanceof OutStroke) {
								VarDecl declOutput = factory.createVarDecl
								(factory.createZNameList(Arrays.asList(zname)), varDecl.getExpr());
								outputDeclaracoes.add(declOutput);
							}
						}
					}
				}
			}
		}

		if (notXiS) {
			String msg = MessagesManager.getInstance().getMessage("XiSError");
			throw  new CircusLawApplicationException(msg); 
		}
		/* Pegar o schema com o nomeState*/
		SchExpr estado = SchemaFinder.getSchema(nomeState, crUtils.getInterno().retornarProgAtual());

		if (estado == null) {
			String msg = MessagesManager.getInstance().getMessage("SNotFoundError");
			throw  new CircusLawApplicationException(msg);
		}
		/* Pegar o invariante do Schema Estado*/
		Pred invariante = estado.getZSchText().getPred();
		if (invariante == null) {invariante = factory.createTruePred();}

		/* Criando d'*/
		ZDeclList declaracoes = estado.getZSchText().getZDeclList();
		ZDeclList declaracoesLinha = (ZDeclList) DashedTerm.getDashedTerm(declaracoes); 

		Pred predicadoOperacaoSchema = (Pred) 
		LawApplAnn.findOriginal(predOp.getName(), 
				unificacao);
		
		Pred predicadoCopia = ClonerVisitor.cloneTerm(predicadoOperacaoSchema);
		
		for (int i=0;i< declaracoes.size();i++) {
			ZNameList nomesAntigo = DeclUtils.getVarNames(declaracoesLinha);
			ZNameList nomesNovos = DeclUtils.getVarNames(declaracoes);
			
			for (int k=0; k< nomesAntigo.size();k++){
				predicadoCopia = (Pred) UpdateVisitor.update(nomesAntigo.get(k),
						nomesNovos.get(k), predicadoCopia, false);
			}
		}
		
		/* Criando existencial */
		ZSchText schText = factory.createZSchText(factory.createZDeclList(outputDeclaracoes), 
				factory.createTruePred());
		ExistsPred exist = factory.createExistsPred(schText, predicadoCopia);
		
		Pred pred1 = factory.createAndPred(Arrays.asList(invariante, exist), And.Wedge);
		

		ZNameList listaVariaveisStmt = factory.createZNameList();
		
		if (!outputDeclaracoes.isEmpty()) {
			listaVariaveisStmt.addAll(DeclUtils.getVarNames(outputDeclaracoes));
		}
		
		SpecStmtCommand statement = factory.createSpecStmtCommand(listaVariaveisStmt, 
				Arrays.asList(pred1,predicadoOperacaoSchema));
		
		//System.out.println(Printer.printLATTEX(statement));
		/* Não é aceito a aplicação de lei sobre um statement, pois quebra o ConstDecl == Expr
		 * Então será utilizado esse termo para guardar o real termo(anotação)*/
		SchExprAction capsula = factory.createSchExprAction(factory.createSchExpr());
		capsula.getExpr().getAnns().add(new StatementSchExprAnn(statement));
		
		Set<Term> aRetornar = new HashSet<Term>();
		
		/* Unificando o termo da direita */
		JokerActionBinding  bind1= 
			this.factory.createJokerActionBinding(right, capsula);
		/* Unificar a Acao*/
		
		unificacao.add(bind1);

		aRetornar.add(right);
		return aRetornar;
	}

}

