/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules;

import java.util.ArrayList;

import circusRefine.util.CRefineAnnotation;

/**
 * Anota��o para especificar a opera��o de uma lei. Quando uma lei 
 * possui essa anota��o, a especifica��o apresentada na observa��o de 
 * aplica��o ser� dada pela Mensagem representada pelo c�digo presente 
 * nesta anota��o 
 * 
 * @author Cristiano Castro
 */
public class LawDefinitionAnn implements CRefineAnnotation {

	/** A string de descri��o da lei */
	private String[] description;
	
	/** 
	 * O c�digo para a string representado as obriga��es de prova
	 * desta lei 
	 */
	private ArrayList<String> pos;

	/**
	 * String que representa o termo antes da aplicacao da Lei
	 */
	private String[] beforeApplication;
	
	/**
	 * String que representar o termo resultante da aplicacao da Lei
	 */
	private String[] afterApplication;
	
	/**
	 * @param description
	 * @param pos
	 */
	public LawDefinitionAnn(String[] description, ArrayList<String> pos,
			String[] antes, String[] depois) {
		this.setDescription(description);
		this.setPos(pos);
		this.setBeforeApplication(antes);
		this.setAfterApplication(depois);
	}
	
	public LawDefinitionAnn(ArrayList<String> pos) {
		this.setPos(pos);

	}

	/**
	 * Retorna o c�digo para a internacionaliza��o representando a 
	 *  mensagem c�digo desta lei
	 * 
	 * @return o c�digo da mensagem de explica��o do funcionamento da 
	 *  lei de Circus
	 */
	public String[] getDescription() {
		return description;
	}

	/**
	 * Modifica o c�digo de descri��o da internacionaliza��o 
	 *  representando a mensagem desta lei
	 * 
	 * @param description O c�digo para a nova explica��o do 
	 *  funcionamento dessa lei
	 */
	private void setDescription(String[] description) {
		this.description = description;
	}

	/**
	 * Acessa as strings representando as obriga��es de prova da lei
	 * 
	 * @return a lista com as defini��es das obriga��es de prova da 
	 *  lei
	 */
	public ArrayList<String> getPos() {
		return pos;
	}

	private void setPos(ArrayList<String> pos) {
		this.pos = pos;
	}

	public String[] getAfterApplication() {
		return afterApplication;
	}

	public String[] getBeforeApplication() {
		return beforeApplication;
	}

	public void setAfterApplication(String[] afterApplication) {
		this.afterApplication = afterApplication;
	}

	public void setBeforeApplication(String[] beforeApplication) {
		this.beforeApplication = beforeApplication;
	}
	
	
	
	
}
