/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules;

import circusRefine.core.crules.messages.CRulesMissingMessageException;
import circusRefine.core.crules.messages.MessagesManager;

/**
 * Excesso gerada quando a aplicao de uma lei  cancelada 
 * 
 * @author Cristiano Castro
 */
public class CancelledApplException extends CRulesException {

	/**
	 * Para uma serializao
	 */
	private static final long serialVersionUID = -2619417167554286040L;
	
	/**
	 * Construtor para uma aplicao cancelada de uma lei
	 * 
	 * @param code o cdigo da mensagem ao usurio
	 * @throws CRulesMissingMessageException 
	 */
	public CancelledApplException(String code) throws 
		CRulesMissingMessageException {
		super(MessagesManager.getInstance().getMessage(code));
	}
	
	/**
	 * Construtor para uma aplicao cancelada de uma lei
	 * @throws CRulesMissingMessageException 
	 */
	public CancelledApplException() throws CRulesMissingMessageException {
		super(MessagesManager.getInstance().getMessage("CancelledApplMsg"));
	}

}
