/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules;

import java.io.StringWriter;
import java.util.Set;

import javax.swing.JOptionPane;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.NameSet;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerActionBinding;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSetBinding;
import net.sourceforge.czt.circuspatt.ast.JokerCommunication;
import net.sourceforge.czt.circuspatt.ast.JokerCommunicationBinding;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.ast.JokerNameSetBinding;
import net.sourceforge.czt.circuspatt.ast.JokerPara;
import net.sourceforge.czt.circuspatt.ast.JokerParaBinding;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerParaListBinding;
import net.sourceforge.czt.circuspatt.ast.JokerProcess;
import net.sourceforge.czt.circuspatt.ast.JokerProcessBinding;
import net.sourceforge.czt.circuspatt.visitor.JokerActionVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerChannelSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerCommunicationVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerNameSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaListVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerProcessVisitor;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ExprList;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NameList;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ParaList;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RenameList;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerDeclListBinding;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerExprBinding;
import net.sourceforge.czt.zpatt.ast.JokerExprList;
import net.sourceforge.czt.zpatt.ast.JokerExprListBinding;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerNameBinding;
import net.sourceforge.czt.zpatt.ast.JokerNameList;
import net.sourceforge.czt.zpatt.ast.JokerNameListBinding;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerPredBinding;
import net.sourceforge.czt.zpatt.ast.JokerRenameList;
import net.sourceforge.czt.zpatt.ast.JokerRenameListBinding;
import net.sourceforge.czt.zpatt.ast.JokerStroke;
import net.sourceforge.czt.zpatt.ast.JokerStrokeBinding;
import net.sourceforge.czt.zpatt.visitor.JokerDeclListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerPredVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerRenameListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerStrokeVisitor;
import circusRefine.core.astmodifiers.IASTModifierAnn;
import circusRefine.core.relations.RelationsUtils;
import circusRefine.core.util.ClonerVisitor;
import circusRefine.core.util.JokerNameGetterVisitor;

/**
 * Construtor da AST apos a aplicacao de uma lei
 * 
 * @author Cristiano Gurgel
 */
public class BuilderVisitor implements TermVisitor<Term>, 
	JokerActionVisitor<Term>, JokerChannelSetVisitor<Term>, 
	JokerCommunicationVisitor<Term>, JokerDeclListVisitor<Term>,
	JokerExprVisitor<Term>, JokerExprListVisitor<Term>, JokerNameVisitor<Term>,
	JokerNameListVisitor<Term>, JokerNameSetVisitor<Term>, 
	JokerParaVisitor<Term>, JokerParaListVisitor<Term>, JokerPredVisitor<Term>, 
	JokerProcessVisitor<Term>, JokerRenameListVisitor<Term>, 
	JokerStrokeVisitor<Term> {

	/**
	 * Constroi um termo de uma lei apos sua aplicada. As pilhas de
	 * 	relacionamento do novo termo s�o vazias.
	 * 
	 * @param law o "molde" do termo 
	 * @param links os bindings utilizados na contru��o do termo
	 * @return o Termo construido
	 */
	public static Term build(Term law, Set<Binding> links) {
		BuilderVisitor builder = new BuilderVisitor(links);
		Term cons = law.accept(builder);
		
		/* Retira as pilhas de relacionamento da nova AST */
		RelationsUtils.removeStack(cons);
		return cons;
	}
	
	/** Mapemento dos jokers com os termos da AST */
	private Set<Binding> mapeamento;
	
	/** Log para a documenta��o da construcao */
	private StringWriter log;
	
	/**
	 * Inicializa o Builder com um mapeamento para a construcao do 
	 * termo
	 */
	public BuilderVisitor(Set<Binding> map) {
		this.setMapeamento(map);
		this.setLog(new StringWriter());
		this.addMessage("Log do Build: " + this);
	}

	/**
	 * Acessa o log da classe
	 * 
	 * @return a informacao sobre unificacao
	 */
	public String getInfo() {
		return this.getLog().toString();
	}
	
	private StringWriter getLog() {
		return log;
	}
	
	private void setLog(StringWriter log) {
		this.log = log;
	}
	
	
	/**
	 * Adiciona uma mensagem ao log de unificacao
	 * 
	 * @param msg a mensagem a ser adicionada
	 */
	private void addMessage(String msg) {
		this.getLog().append(msg + "\n");
	}
	
	private Set<Binding> getMapeamento() {
		return mapeamento;
	}
	
	private void setMapeamento(Set<Binding> mapeamento) {
		this.mapeamento = mapeamento;
	}
	
	/**
	 * Cria um novo termo de acordo com um molde contendo jokers e
	 * um conjunto de {@link Binding}s
	 * 
	 * @param termo o molde para a construcao do termo
	 * @return o termo construido
	 */
	public Term visitTerm(Term termo) {

		/* Retorna a copia construida do termo da lei */
		Term novo = VisitorUtils.visitTerm(this, termo, false);
		
		/* Confere as anota��es do termo */
		for (Object ann : termo.getAnns()) {
			if (ann instanceof IASTModifierAnn) {
				
				/* 
				 * Executa o build tamb�m nas anota��es que modificam a 
				 * AST 
				 */
				IASTModifierAnn amAnn = (IASTModifierAnn) ann;
				
				/* N�o mistura o joker com o termo real */
				Term joker = amAnn.getTerm();
				Term construido = joker.accept(this);
				
				/* Cria uma c�pia da anota��o */
				IASTModifierAnn newAnn = amAnn.create();
				newAnn.setTerm(construido);
				
				/* Substitui os jokers no termo construido */
				novo.getAnns().remove(amAnn);
				novo.getAnns().add(newAnn);
			}
		}
		
		/* Evita erro do Print */
		//this.addMessage("Criando novo Termo: " + novo);
		return novo;
		
	}
	
	/**
	 * Procura a CircusAction correspondente a um JokerAction.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerAction(JokerAction joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			
			if (i instanceof JokerActionBinding) {
				JokerActionBinding binding = (JokerActionBinding)i;
				String nomeJoker = binding.getJokerAction().accept(getter);
				/* Encontrei o Joker!! */
				if (nome.equals(nomeJoker)) {
					CircusAction acao = binding.getCircusAction();
					CircusAction clone = 
						ClonerVisitor.cloneTerm(acao);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link ChannelSet} correspondente a um 
	 * {@link JokerChannelSet}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerChannelSet(JokerChannelSet joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerChannelSetBinding) {
				JokerChannelSetBinding binding = (JokerChannelSetBinding)i;
				String nomeJoker = binding.getJokerChannelSet().accept(getter);
				
				/* Encontrei o Joker!! */
				if (nome.equals(nomeJoker)) {
					ChannelSet term = binding.getChannelSet();
					ChannelSet clone = 
						ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link Communication} correspondente a um 
	 * {@link JokerCommunication}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerCommunication(JokerCommunication joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerCommunicationBinding) {
				JokerCommunicationBinding binding = 
					(JokerCommunicationBinding)i;
				String nomeJoker = 
					binding.getJokerCommunication().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					Communication term = binding.getCommunication();
					Communication clone = 
						ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone.getClass());
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link DeclList} correspondente a um 
	 * {@link JokerDeclList}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerDeclList(JokerDeclList joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerDeclListBinding) {
				JokerDeclListBinding binding = 
					(JokerDeclListBinding)i;
				String nomeJoker = 
					binding.getJokerDeclList().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					DeclList term = binding.getDeclList();
					DeclList clone = 
						ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link Expr} correspondente a um 
	 * {@link JokerExpr}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerExpr(JokerExpr joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerExprBinding) {
				JokerExprBinding binding = 
					(JokerExprBinding)i;
				String nomeJoker = 
					binding.getJokerExpr().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					Expr term = binding.getExpr();
					Expr clone = 
						ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link ExprList} correspondente a um 
	 * {@link JokerExprList}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerExprList(JokerExprList joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerExprListBinding) {
				JokerExprListBinding binding = 
					(JokerExprListBinding)i;
				String nomeJoker = 
					binding.getJokerExprList().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					ExprList term = binding.getExprList();
					ExprList clone = 
						ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link Name} correspondente a um 
	 * {@link JokerName}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerName(JokerName joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerNameBinding) {
				JokerNameBinding binding = 
					(JokerNameBinding)i;
				String nomeJoker = 
					binding.getJokerName().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					Name term = binding.getName();
					Name clone = ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link NameList} correspondente a um 
	 * {@link JokerNameList}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerNameList(JokerNameList joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerNameListBinding) {
				JokerNameListBinding binding = 
					(JokerNameListBinding)i;
				String nomeJoker = 
					binding.getJokerNameList().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					NameList term = binding.getNameList();
					NameList clone = ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link NameSet} correspondente a um 
	 * {@link JokerNameSet}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerNameSet(JokerNameSet joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerNameSetBinding) {
				JokerNameSetBinding binding = 
					(JokerNameSetBinding)i;
				String nomeJoker = 
					binding.getJokerNameSet().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					NameSet term = binding.getNameSet();
					NameSet clone = ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link Pred} correspondente a um 
	 * {@link JokerPred}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerPred(JokerPred joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerPredBinding) {
				JokerPredBinding binding = 
					(JokerPredBinding)i;
				String nomeJoker = 
					binding.getJokerPred().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					Pred term = binding.getPred();
					Pred clone = ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link CircusProcess} correspondente a um 
	 * {@link JokerProcess}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerProcess(JokerProcess joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerProcessBinding) {
				JokerProcessBinding binding = 
					(JokerProcessBinding)i;
				String nomeJoker = 
					binding.getJokerProcess().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					CircusProcess term = binding.getCircusProcess();
					CircusProcess clone = 
							ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link CircusProcess} correspondente a um 
	 * {@link JokerProcess}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerRenameList(JokerRenameList joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerRenameListBinding) {
				JokerRenameListBinding binding = (JokerRenameListBinding)i;
				String nomeJoker = binding.getJokerRenameList().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					RenameList term = binding.getRenameList();
					CircusProcess clone = 
							(CircusProcess)ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link CircusProcess} correspondente a um 
	 * {@link JokerProcess}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerStroke(JokerStroke joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerStrokeBinding) {
				JokerStrokeBinding binding = (JokerStrokeBinding)i;
				String nomeJoker = binding.getJokerStroke().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					Stroke term = binding.getStroke();
					Stroke clone = ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link CircusProcess} correspondente a um 
	 * {@link JokerProcess}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerPara(JokerPara joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerParaBinding) {
				JokerParaBinding binding = (JokerParaBinding)i;
				String nomeJoker = binding.getJokerPara().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					Para term = binding.getPara();
					Para clone = ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}

	/**
	 * Procura o {@link CircusProcess} correspondente a um 
	 * {@link JokerProcess}.
	 * 
	 * @param joker o joker da lei.
	 * @return a acao correspondente ao joker caso este seja um 
	 * 		argumento ou uma copia do joker caso nao seja.
	 */
	public Term visitJokerParaList(JokerParaList joker) {
		JokerNameGetterVisitor getter = new JokerNameGetterVisitor();
		String nome = joker.accept(getter);
		
		/* Procura pelo mapeamento */
		for (Binding i : this.getMapeamento()) {
			if (i instanceof JokerParaListBinding) {
				JokerParaListBinding binding = (JokerParaListBinding)i;
				String nomeJoker = binding.getJokerParaList().accept(getter);
				
				if (nome.equals(nomeJoker)) {
					
					/* Encontrei o Joker!! */
					ParaList term = binding.getParaList();
					ParaList clone = ClonerVisitor.cloneTerm(term);
					this.addMessage("Construido: " + nome + " -> " + clone);
					return clone;
				}
				
			}
		}
		
		/* 
		 * Caso a acao correspondente nao tenha sido encontrada,
		 * retorna uma copia do proprio Joker
		 */
		return this.visitTerm(joker);
	}
	
}