/*
 * Projeto: Circus Refine 
 */
package circusRefine.core.crules;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.NameSet;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.ast.JokerAction;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerCommunication;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.ast.JokerPara;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerProcess;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.circuspatt.visitor.JokerActionVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerChannelSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerCommunicationVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerNameSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaListVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerParaVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerProcessVisitor;
import net.sourceforge.czt.z.ast.DeclList;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ExprList;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NameList;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ParaList;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RenameList;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.zpatt.ast.Binding;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.ast.JokerExprList;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.ast.JokerNameList;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.ast.JokerRenameList;
import net.sourceforge.czt.zpatt.ast.JokerStroke;
import net.sourceforge.czt.zpatt.visitor.JokerDeclListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerExprVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerNameVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerPredVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerRenameListVisitor;
import net.sourceforge.czt.zpatt.visitor.JokerStrokeVisitor;

/**
 * Classe usada para obter um binding a partir de um Joker e um 
 * parmetro real
 * 
 * @author Cristiano Gurgel
 */
public class BindingGetter implements JokerActionVisitor<Binding>, 
		JokerChannelSetVisitor<Binding>, JokerCommunicationVisitor<Binding>, 
		JokerDeclListVisitor<Binding>, JokerExprVisitor<Binding>, 
		JokerExprListVisitor<Binding>, JokerNameVisitor<Binding>, 
		JokerNameListVisitor<Binding>, JokerNameSetVisitor<Binding>, 
		JokerPredVisitor<Binding>, JokerProcessVisitor<Binding>, 
		JokerRenameListVisitor<Binding>, JokerStrokeVisitor<Binding>,
		JokerParaVisitor<Binding>, JokerParaListVisitor<Binding> {

	/**
	 * Retorna o {@link Binding} correspondente a partir de um joker
	 * e de um argumento
	 * 
	 * @param joker o joker a ser ligado a um argumento
	 * @param arg o argumento a ser ligado com um joker
	 * @throws ClassCastException caso o argumento no possa ser 
	 * 		ligado ao joker
	 * @throws UnsupportedAstClassException caso o joker no 
	 * 		represente um Joker
	 */
	public static Binding getBinding(Term joker, Term arg) {
		BindingGetter getter = new BindingGetter(arg);
		return joker.accept(getter);
	}
	
	/** O argumento usado para completar o binding */
	private Term argument;
	
	/**
	 * Inicia o BindingGetter com o parmetro Real
	 * 
	 * @param second
	 */
	public BindingGetter(Term second) {
		this.setArgument(second);
	}
	
	private Term getArgument() {
		return argument;
	}
	
	private void setArgument(Term argument) {
		this.argument = argument;
	}
	
	/**
	 * Liga o {@link JokerAction} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}]
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerAction(JokerAction arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerActionBinding(arg0, 
				(CircusAction)this.getArgument());
	}
	
	/**
	 * Liga o {@link JokerChannelSet} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerChannelSet(JokerChannelSet arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerChannelSetBinding(arg0, 
				(ChannelSet)this.getArgument());
	}

	/**
	 * Liga o {@link JokerCommunication} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerCommunication(JokerCommunication arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerCommunicationBinding(arg0, 
				(Communication)this.getArgument());
	}

	/**
	 * Liga o {@link JokerDeclList} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerDeclList(JokerDeclList arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerDeclListBinding(arg0, 
				(DeclList)this.getArgument());
	}

	/**
	 * Liga o {@link JokerExpr} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerExpr(JokerExpr arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerExprBinding(arg0, (Expr)this.getArgument());
	}

	/**
	 * Liga o {@link JokerExprList} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerExprList(JokerExprList arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerExprListBinding(arg0, 
				(ExprList)this.getArgument());
	}

	/**
	 * Liga o {@link JokerName} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerName(JokerName arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerNameBinding(arg0, (Name)this.getArgument());
	}

	/**
	 * Liga o {@link JokerNameList} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerNameList(JokerNameList arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerNameListBinding(arg0, 
				(NameList)this.getArgument());
	}

	/**
	 * Liga o {@link JokerNameSet} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerNameSet(JokerNameSet arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerNameSetBinding(arg0, 
				(NameSet)this.getArgument());
	}

	/**
	 * Liga o {@link JokerPred} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerPred(JokerPred arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerPredBinding(arg0,	(Pred)this.getArgument());
	}

	/**
	 * Liga o {@link JokerProcess} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerProcess(JokerProcess arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerProcessBinding(arg0, 
				(CircusProcess)this.getArgument());
	}

	/**
	 * Liga o {@link JokerProcess} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerRenameList(JokerRenameList arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerRenameListBinding(arg0, 
				(RenameList)this.getArgument());
	}

	/**
	 * Liga o {@link JokerStroke} ao argumento correspondente
	 * 
	 * @return o novo {@link Binding}
	 * @throws ClassCastException caso o argumento no possa ser
	 * 		associado ao Joker.
	 */
	public Binding visitJokerStroke(JokerStroke arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerStrokeBinding(arg0, 
				(Stroke)this.getArgument());
	}
	
	// TODO comentar este mtodo
	public Binding visitJokerPara(JokerPara arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerParaBinding(arg0, (Para)this.getArgument());
	}
	
	// TODO comentar este mtodo
	public Binding visitJokerParaList(JokerParaList arg0) {
		CircusPatternFactory factory = new CircusPatternFactoryImpl();
		return factory.createJokerParaListBinding(arg0, 
				(ParaList)this.getArgument());
	}

}
