/*
 * Projeto: Circus Refine
 */
package circusRefine.core.astmodifiers;

import net.sourceforge.czt.base.ast.Term;

/**
 * Classe utilitria para os modificadores de AST
 * 
 * @author Cristiano Castro
 */
public final class ASTModifiersUtils {

	/**
	 * Mtodo utilitrio para remover uma anotao do termo caso
	 * 
	 * @param termo o termo cuja anotao dever ser removida
	 * @param classeAnotacao o tipo da anotao a ser removida
	 */
	public static void removeAnn(Term termo, Class<?> classeAnotacao) {
		int idx = -1;
		for (Object ann : termo.getAnns()) {
			if (classeAnotacao.isInstance(ann)) {
				
				/* Achou uma ocorrncia do tipo da anotao */
				idx = termo.getAnns().indexOf(ann);
			}
		}
		
		if (idx >= 0) {
			
			/* Encontrou a anotao a ser removida */
			termo.getAnns().remove(idx);
		}
	}
	
}
