/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.z.ast.Pred;
import circusRefine.core.util.POLog;
import circusRefine.util.OPTipos;

/**
 * Classe que encapsula uma Obrigacao de prova. Contem um predicado 
 * que sera de 1a. ordem. Um atributo que revela se o predicado foi 
 * considerado: verdadeiro, falso, nao checado, valor nao determinado 
 * pelo provador de teorema
 * 
 * @author Alessandro Gurgel
 * @author Cristiano Castro
 */
public class ObrigacaoProva {

	/** Predicado gerado por uma obriga��o de prova */
	private Pred predicado;
	
	/** Predicado extendido (se for poss�vel) */
	private Pred predExtendido;
	
	/** Tipo da resposta do provador com rela��o a OP extendida */
	private OPTipos tipo;
	
	/** Historico das tentativas de se provar a OP */
	private POLog log;
	
	/** Booleano que indica se uma op est� estendida ou n�o */
	private boolean estaExtendida;

	/** Booleano que indica se uma op pode ou nao ser estendida ou n�o */
	private boolean podeExtender;
	
	/** Linha da lei que gerou esta op*/
	private Integer linhaLei;
	
	/** AST que guarda o contexto em que a obriga��o de Prova foi gerada*/
	private Term contexto;
	private Term contextoDepois;
	
	/** booleano que sera true caso o predicado tenha que ser enviado 
	 * a um model Checker para ser provado*/
	private boolean toModelChecker;
	
	/**
	 * Inicia a obriga��o de prova indicando o predicado gerado,
	 * a obriga��o de prova estendida e o tipo da avalia��o da
	 * obriga��o de prova estendida
	 * 
	 * @param predicado o predicado gerado pela OP
	 * @param extendido o predicado extendido gerado pela Obriga��o 
	 *  de prova
	 * @param tipo o tipo da avalia��o da OP extendida
	 */
	public ObrigacaoProva(Pred predicado, Pred extendido, OPTipos tipo, POLog lg, int linhaL, boolean extendivel, boolean toModelChecker) {
		this.predicado = predicado;
		this.predExtendido = extendido;
		this.tipo = tipo;
		this.log = lg;
		this.estaExtendida = false;
		this.linhaLei = linhaL;
		this.podeExtender = extendivel;
		this.toModelChecker = toModelChecker;
		contexto = null;
		
	}
	
	/**
	 * Inicia a obriga��o de prova indicando o predicado gerado,
	 * a obriga��o de prova estendida e o tipo da avalia��o da
	 * obriga��o de prova estendida
	 * 
	 * @param predicado o predicado gerado pela OP
	 * @param extendido o predicado extendido gerado pela Obriga��o 
	 *  de prova
	 * @param tipo o tipo da avalia��o da OP extendida
	 * @param termo AST que guarda o contexto em que a OP foi gerada
	 */
	public ObrigacaoProva(Pred predicado, Pred extendido, OPTipos tipo, POLog lg
			, int linhaL, boolean extendivel, Term termo, boolean toModelChecker) {
		this.predicado = predicado;
		this.predExtendido = extendido;
		this.tipo = tipo;
		this.log = lg;
		this.estaExtendida = false;
		this.linhaLei = linhaL;
		this.podeExtender = extendivel;
		this.contexto = termo;
		this.toModelChecker = toModelChecker;
	}
	
	public ObrigacaoProva(Pred predicado, Pred extendido, OPTipos tipo, POLog lg
			, int linhaL, boolean extendivel, Term termo, Term termodepois, boolean toModelChecker) {
		this.predicado = predicado;
		this.predExtendido = extendido;
		this.tipo = tipo;
		this.log = lg;
		this.estaExtendida = false;
		this.linhaLei = linhaL;
		this.podeExtender = extendivel;
		this.contexto = termo;
		this.toModelChecker = toModelChecker;
		this.contextoDepois = termodepois;
	}
	


	public boolean estaExtendida() {
		return estaExtendida;
	}
	
	public Pred getPredicado() {
		return predicado;
	}
	
	public Pred getExtendido() {
		return predExtendido;
	}
	
	public OPTipos getTipo() {
		return  tipo;
	}
	
	public void setTipo(OPTipos novoTipo){
		tipo = novoTipo;
	}
	
	public void setExtendida(boolean valor) {
		estaExtendida = valor;
	}

	public POLog getLog() {
		return log;
	}

	public void setLog(POLog log) {
		this.log = log;
	}

	public Integer getLinhaLei() {
		return linhaLei;
	}

	public void setLinhaLei(Integer linhaLei) {
		this.linhaLei = linhaLei;
	}
	
	public boolean podeExtender(){
		return podeExtender;
	}

	public Term getContexto() {
		return contexto;
	}

	public void setContexto(Term contexto) {
		this.contexto = contexto;
	}

	public boolean isToModelChecker() {
		return toModelChecker;
	}

	public void setToModelChecker(boolean toModelChecker) {
		this.toModelChecker = toModelChecker;
	}

	public Term getContextoDepois() {
		return contextoDepois;
	}

	public void setContextoDepois(Term contextoDepois) {
		this.contextoDepois = contextoDepois;
	}
}
