/*
 * NoPrograma.java
 *
 * Created on 26 de Setembro de 2005, 10:38
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */
package circusRefine.core;

import net.sourceforge.czt.base.ast.Term;

/**
 * Um n da AST, que corresponde a uma parte do refinamento
 *
 * @author comp
 */
public class NoPrograma {

	/**  */
	private Term programa_;
	private boolean aplicarLei_;
	
	/** Linha inicial do programa */
	private int linhaInicial;
	
	/** Linha final do programa */
	private int linhaFinal;

	/** Creates a new instance of NoPrograma */
	public NoPrograma(Term programas, int lInicial, int lFinal) {
		this(programas);
		
		/* Seta as linhas de aplicao de uma lei */
		this.setLinhaInicial(lInicial);
		this.setLinhaFinal(lFinal);
	}
	

	/** Creates a new instance of NoPrograma */
	public NoPrograma(Term programas) {
		this.programa_ = programas;
		this.aplicarLei_ = true;
	}

	public Term getPrograma() {
		return this.programa_;
	}

	public void setPrograma(Term programa) {
		this.programa_ = programa;
	}

	/**
	 * @return the linhaInicial
	 */
	public int getLinhaInicial() {
		return linhaInicial;
	}

	/**
	 * @param linhaInicial the linhaInicial to set
	 */
	private void setLinhaInicial(int linhaInicial) {
		this.linhaInicial = linhaInicial;
	}

	/**
	 * @return the linhaFinal
	 */
	public int getLinhaFinal() {
		return linhaFinal;
	}

	/**
	 * @param linhaFinal the linhaFinal to set
	 */
	private void setLinhaFinal(int linhaFinal) {
		this.linhaFinal = linhaFinal;
	}

	public boolean aplicarLei() {
		return this.aplicarLei_;
	}

	public void setAplicarLei(boolean pode) {
		this.aplicarLei_ = pode;
	}

}
