/*
 * Projeto: Circus Refine
 */
package circusRefine.core;

/**
 * Resposta da insero de um comentrio na especificao de um 
 * programa para o CRefine
 * 
 * @author Cristiano Castro
 */
public class InsertCommentAnswer implements StepAnswer {

	/** Linha inicial na qual foi aplicado o comentrio */
	private int linhaInicial;
	
	/** Linha final na qual foi aplicado o comentrio */
	private int linhaFinal;
	
	/** Texto no qual o comentrio foi adicionado */
	private String text;

	/** Idenficador de Comentario*/
	private int identificador;

	/**
	 * Inicia a resposta  ao com as linhas nas quais foi aplicado
	 * o comentrio e com o texto do comentrio em si.
	 * 
	 * @param linhaInicial a linha inicial do comentrio
	 * @param linhaFinal a linha final do comentrio
	 * @param text o texto do comentrio
	 */
	public InsertCommentAnswer(int linhaInicial, int linhaFinal, 
			String text, int idt) {
		this.setLinhaInicial(linhaInicial);
		this.setLinhaFinal(linhaFinal);
		this.setText(text);
		this.setIdentificador(idt);
	}
	
	/**
	 * @return the linhaInicial
	 */
	public int getLinhaInicial() {
		return linhaInicial;
	}

	/**
	 * @param linhaInicial the linhaInicial to set
	 */
	public void setLinhaInicial(int linhaInicial) {
		this.linhaInicial = linhaInicial;
	}

	/**
	 * @return the linhaFinal
	 */
	public int getLinhaFinal() {
		return linhaFinal;
	}

	/**
	 * @param linhaFinal the linhaFinal to set
	 */
	public void setLinhaFinal(int linhaFinal) {
		this.linhaFinal = linhaFinal;
	}

	/**
	 * @return the text
	 */
	public String getText() {
		return text;
	}

	/**
	 * @param text the text to set
	 */
	public void setText(String text) {
		this.text = text;
	}
	
	public int getIdentificador() {
		return identificador;
	}

	public void setIdentificador(int identificador) {
		this.identificador = identificador;
	}

	
	
}
