package circusRefine.core;

import java.util.Stack;

import net.sourceforge.czt.base.ast.Term;
import circusRefine.Tactic.Util.TacticAnswer;
import circusRefine.core.relations.RelationRowLaw;

/**
 * Classe que guardas as pilhas referentes ao Gerenciador Externo
 * @author alessandro87
 *
 */
public class ExternalManagerStacks {

	/* Pilhas do Gerenciador Externo*/
	private Stack<RelationRowLaw> leisApl;
	private Stack<RelationRowLaw> taticaApl;
	private Stack<RelationRowLaw> redoleisApl;
	private Stack<RelationRowLaw> redoTaticasApl;
	private Stack<Term> termosApl;
	private Stack<Term> redoTermosApl;
	private Stack<LawAnswer> respostaLeis;
	private Stack<LawAnswer> redoRespostaLeis;
	
	/**
	 * Para as táticas
	 */
	private Stack<TacticAnswer> taticasApl;
	
	public ExternalManagerStacks(Stack<RelationRowLaw> leisAplicadas,
			Stack<RelationRowLaw> taticasAplicadas, 
			Stack<RelationRowLaw> redoleisAplicadas,
			Stack<RelationRowLaw> redoTaticasApl,
			Stack<Term> termosAplicados, Stack<Term> redoTermosAplicados, 
			Stack<LawAnswer> respostaLeisUtilizadas, Stack<LawAnswer> redoRespostaLeisUtilizadas) {
		
		this.leisApl = leisAplicadas;
		this.taticaApl = taticasAplicadas;
		this.redoleisApl = redoleisAplicadas;
		this.redoTaticasApl = redoTaticasApl;
		this.termosApl = termosAplicados;
		this.redoTermosApl = redoTermosAplicados;
		respostaLeis = respostaLeisUtilizadas;
		this.redoRespostaLeis = redoRespostaLeisUtilizadas;
	}

	public ExternalManagerStacks() {
		
		leisApl = new Stack<RelationRowLaw>();
		taticaApl = new Stack<RelationRowLaw>();
		redoleisApl = new Stack<RelationRowLaw>();
		redoTaticasApl = new Stack<RelationRowLaw>();
		termosApl = new Stack<Term>();
		redoTermosApl = new Stack<Term>();
		respostaLeis = new Stack<LawAnswer>();
		taticasApl = new Stack<TacticAnswer>();
		redoRespostaLeis = new Stack<LawAnswer>();
	}

	public Stack<RelationRowLaw> getLeisApl() {
		return leisApl;
	}


	public void setRedoTaticasApl(Stack<RelationRowLaw> redoTaticasApl) {
		this.redoTaticasApl = redoTaticasApl;
	}

	public Stack<RelationRowLaw> getRedoleisApl() {
		return redoleisApl;
	}
	
	public Stack<RelationRowLaw> getRedoTaticasApl() {
		return redoTaticasApl;
	}


	public Stack<LawAnswer> getRedoRespostaLeis() {
		return redoRespostaLeis;
	}


	/**
	 * Para as táticas
	 * @return
	 */
	
	public Stack<TacticAnswer> getTaticasApl() {
		return taticasApl;
	}
	
	public Stack<Term> getRedoTermosApl() {
		return redoTermosApl;
	}


	public Stack<LawAnswer> getRespostaLeis() {
		return respostaLeis;
	}


	public Stack<Term> getTermosApl() {
		return termosApl;
	}

	public void esvaziarRedoPilhas() {
		this.redoTermosApl.clear();
		this.redoleisApl.clear();
		this.redoRespostaLeis.clear();
		
	}

	public void esvaziarPilhas() {
		leisApl.clear(); 
		redoleisApl.clear(); 
		termosApl.clear(); 
		redoTermosApl.clear(); 
		respostaLeis.clear(); 
		redoRespostaLeis.clear(); 
	}

	/**
	 * Para as táticas
	 * @return
	 */
	public Stack<RelationRowLaw> getTaticaApl() {
		return taticaApl;
	}

	

	
}
