/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core;


/** 
 * CircusRefine é um tipo responsével pela inicialização do sistema.
 */
public class CircusRefine {

	/** Numero da verséo atual do CRefine */
	public static String version = "3.0";
	
	/** Gerenciador Externo da ferramenta */ 
    private ExternalManager gerInterface;

    /**
     * Construtor da classe CircusRefine.
     *
     * @param gerInterface       Gerenciador da interface do sistema.
     *
     */
    public CircusRefine(ExternalManager gerInterface) {
        try {
            //UIManager.setLookAndFeel(new com.sun.java.swing.plaf.windows.WindowsLookAndFeel());
            this.gerInterface = gerInterface;
            
        } catch(Exception e) {
            e.printStackTrace();
        } 
        
    }
    
    /**
     * Método que chama o inicializador de interfaces do gerenciador de interface.
     *
     */
    public void inicializar() {
    	gerInterface.inicializar();
        gerInterface.setarFocus();
        gerInterface.updateTacticList();
        
    }
       /**
	* Método que executa o sistema.
	*
	* @param args       Argumentos de inicialização (EX. pt BR).
	*
	*/
    
	public static void main(String[] args) {
		if(args.length == 2) {
			String linguagem = args[0];
			String pais = args[1];
			ExternalManager gerInterface = new ExternalManager(linguagem, pais);
			CircusRefine refine = new CircusRefine(gerInterface);
			refine.inicializar();
		}
		else {
			ExternalManager gerInterface = new ExternalManager("en", "uk");
			CircusRefine teste = new CircusRefine(gerInterface);
			teste.inicializar();
		}

	}
}
