package circusRefine.Tactic.Util;

import java.nio.channels.ClosedByInterruptException;
import java.util.Vector;

public class ListaUtil {

	/**
	 * Método GENERICO que representa a concatenação distribuída
	 * @param list java.util.Vector A lista de lista a ser passada
	 * @return java.util.Vector A lista que representa a concatenação de todas as
	 *						 	listas
	 * @throws BottomListException Caso seja passado uma lista nula
	 * @throws ParametroInvalidoException Caso não seja passado um Vector cujo elementos são Vector
	 */
	public static Vector distributedConcatenation(Vector list) {
		//throws BottomListException, ParametroInvalidoException{

		Vector retorno = new Vector();

		if (list == null) {
			//throw new BottomListException();
		} else {
			Vector clone = (Vector)list.clone();

			// Verifica se todos os elementos da lista passada são listas
			// Se não for lança a exceção de argumento inválido
			for (int i = 0; i < clone.size(); i++){
				if (!(clone.get(i) instanceof Vector)) {
					//throw new ParametroInvalidoException("Parâmetro Inválido na chamada do Método List distributedConcatenation(List) do ListUtil");
				} 
			}

			// Se tudo estiver OK vamos fazer a concatenação
			if (list.size() == 0) {
				retorno = clone;
			} else if (list.size() == 1) {
				//retorno = (Vector) clone.get(0);
				retorno = clone;
			} else {
				//Vector listA = (Vector)clone.elementAt(0);
				RCell rCell = (RCell) clone.get(0);
				Vector listA = new Vector();
				listA.addElement(rCell);
				//(Vector)clone.get(0);
				Vector listB = ListaUtil.distributedConcatenation(ListaUtil.tail(clone));
				retorno = ListaUtil.concatenation(listA,listB);
			}
		}

		return retorno;
	}

	/**
	 * Método que representa a função tail
	 * Creation date: (05/07/02 15:55:47)
	 * @param list java.util.Vector A lista de lista a ser passada
	 * @return java.util.Vector Uma lista contendo todos, exceto o primeiro, elementos de uma lista
	 * @throws BottomListException Caso seja passado uma lista nula
	 */
	public static Vector tail(Vector list) {
		//throws BottomListException {

		Vector retorno = new Vector();

		if (list == null) {
			//throw new BottomListException();
		} else if (list.size() > 0) {
			Vector clone = (Vector)list.clone();
			for (int i = 1; i < clone.size(); i++){
				retorno.addElement(clone.elementAt(i));
			}
		} 

		return retorno;
	}

	/**
	 * Método GENERICO que concatena duas listas
	 * Creation date: (05/07/02 15:55:47)
	 * @param listA java.util.Vector A lista A
	 * @param listB java.util.Vector A lista B
	 * @return java.util.Vector Uma lista contendo a concatenação de listA com listB
	 * @throws BottomListException Caso seja passado uma lista nula
	 */
	public static Vector concatenation(Vector listA, Vector listB){
		//throws BottomListException{

		Vector retorno = new Vector();

		if (listA == null || listB == null) {
			//throw new BottomListException();
		} else {
			Vector cloneA = (Vector)listA.clone();
			Vector cloneB = (Vector)listB.clone();
			retorno = cloneA;
			for (int i = 0; i < cloneB.size(); i++){
				retorno.add(cloneB.elementAt(i));
			}	
		}

		return retorno;
	}

	public static Vector headLine(Vector list){

		Vector retorno = new Vector();

		if (list == null) {
			//throw new BottomListException();
		} else if (list.size() > 0) {
			Vector clone = (Vector)list.clone();
			retorno.add(clone.elementAt(0));
		} 

		return retorno;
	}

	public static Vector distributedCartesianProduct(Vector list) {

		Vector retorno = new Vector();

		if (list != null) {

			// Verificando se a lista é formada por listas realmente
			for (int i = 0; i < list.size(); i++){
				if (!(list.elementAt(i) instanceof Vector)) {
					//throw new ParametroInvalidoException();
				}
				if (list.elementAt(i) == null) {
					//throw new BottomListException();
				}
			}
			
			Vector clone = (Vector)list.clone();

			if (clone.size() > 0 && clone.size() == 1) {
				Vector primeiroElemento = (Vector)clone.elementAt(0);

				for (int i = 0; i < primeiroElemento.size(); i++){
					retorno.addElement(ListaUtil.element2List(primeiroElemento.elementAt(i)));
				}

			} else if (clone.size() > 1){
				// dcp(xs:xss) = [(a:as) | a <- xs, as <- dcp(xss)]

				// xs
				Vector primeiroElemento = (Vector) clone.get(0);
					
					//(Vector)clone.elementAt(0);


				// xss
				Vector restoDaLista = new Vector();
				for (int i = 1; i < clone.size(); i++){
					restoDaLista.addElement(clone.get(i));
				}

				// dcp(xss)
				Vector dcpDoResto = ListaUtil.distributedCartesianProduct(restoDaLista);

				// a <- xs
				for (int i = 0; i < primeiroElemento.size(); i++){
					Object objeto = primeiroElemento.get(i);

					// as <- xss
					for (int j = 0; j < dcpDoResto.size(); j++){
						Vector elementoDoResto = (Vector)((Vector)dcpDoResto.get(j)).clone();

						// (a:as)
						elementoDoResto.add(0,objeto);
						retorno.add(elementoDoResto);
					}
				}

				
			}
		
		}
		
		return retorno;
	}
	
	/**
	 * Método que encapsula um elemento dentro de uma vetor
	 * @param list O elemento a ser encapsulado
	 * @return java.util.Vector A lista que encapsula o objeto
	 */
	public static Vector element2List(Object element) {
		Vector retorno = new Vector();
		retorno.addElement(element);
		return retorno;
	}

}
