package circusRefine.Tactic.Util;

import circusRefine.core.ExternalManager;
import circusRefine.util.Pair;

import circusRefine.Tactic.Principal.*;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import net.sourceforge.czt.base.ast.Term;


/**
 * Classe responsavel por gerenciar as Táticas
 * @author Madiel Filho
 *
 */

public class GerenciadorTaticas {
	
	public static String DIRETORIO_TATICAS_SERIALIZE = "tacticsArcAngelC/tacticsSerialize/";
	private static final String EXTENSAO_TATICAS  = ".tex";
	private static final String EXTENSAO_TATICAS_SERIALIZE  = ".tac";
	JFileChooser fileChooser = new JFileChooser();
	ExternalManager gerInterface;
	ListaTaticas lista = new ListaTaticas();
	static List<Pair<String,Pair<String,Object>>>  listArgs = new ArrayList<Pair<String,Pair<String,Object>>> ();
	public static boolean controlTaltLeft = false;
	public static boolean controlTaltRight = false;
	public static boolean controlTSemi = false;
	public static boolean controlTAbort = false;
	public static boolean rootTalt = false;
	public static TacticComponent tacRoot = null; 
	public static Term lastProcess = null;
	public static String process = "";
	public static boolean controlTFails = false;
	public static boolean rec = false; 
	public static int control = 0;
	public static int leis = 0;
	public static int tatica = 0;

	public Term lastAst;
	
	
	

	List<Pair<String,Term>> mapeamento =  new ArrayList<Pair<String,Term>>();
	
	
	public GerenciadorTaticas(ExternalManager gerInterface) {
		super();
		this.gerInterface = gerInterface;

		
		
	}
	
	public GerenciadorTaticas() {
		super();
		listArgs = new ArrayList<Pair<String,Pair<String,Object>>>();
		controlTaltLeft = false;
		controlTaltRight = false;
		controlTSemi = false;
		controlTAbort = false;
		rootTalt = false;
		tacRoot = null; 
		lastProcess = null;
		controlTFails = false;
		rec = false; 
		
		
	}

	public void adicionarTatica(Tatica tatica){
	     lista.addTactica(tatica);
					
	}
	
	public boolean verificarTatica(Tatica tatica){
		
		boolean overwrite;
		File file = new File(DIRETORIO_TATICAS_SERIALIZE+tatica.getId()+".tac");
		if (file.exists())
		overwrite = true;
		else overwrite = false;
			return overwrite;
	}
	
	public File abrirTatica(){
		File currentDir = new File(".");
		fileChooser = new JFileChooser(currentDir);
		fileChooser.setMultiSelectionEnabled(false);
		fileChooser.setDialogType(JFileChooser.OPEN_DIALOG);
		fileChooser.setDialogTitle(retornarMensagem("OpenT"));
		int choice = fileChooser.showOpenDialog(null);
		File file = fileChooser.getSelectedFile();
		
		if (file != null && choice == JFileChooser.APPROVE_OPTION) {
			String fileName = file.getPath();
			System.out.println("==> "+fileName);

	
	}
		return file;
	}

	public String retornarMensagem(String codigo) {
		String mensagem = gerInterface.getMessage(codigo);
		return mensagem;
	}
	
	public void escreverArquivo(File file, String tacticText) throws IOException{
		if (!file.equals("")) {
			FileWriter writer = new FileWriter(file,false);
			writer.write(tacticText);
			writer.close();
		}
	}
	
	public void escreverArquivoParser(File file, String tacticText) throws IOException{
	
			FileWriter writer = new FileWriter(file,false);
			writer.write(tacticText);
			writer.close();
		
	}


	public List<Tatica> getListaTaticas() {
		return lista.getListaT();
	}

	public void removerTatica(Tatica tatica) {
		
		File file = new File(DIRETORIO_TATICAS_SERIALIZE+tatica.getId()+EXTENSAO_TATICAS_SERIALIZE);
		file.delete();
		lista.removeLista(tatica);
		
		//File fList[] = diretorio.listFiles();

	/*	for (File file : fList) {
			String id = file.getName();
			id = id.replace(".tac", "");
			if (id.equals(tatica.getId())){
				file.delete();
				lista.removeLista(tatica);
			}
				
		}*/
	}
	
	public Tatica retornarTatica(String nomeTatica) throws IOException, ClassNotFoundException{
		//final List <Tatica> listaTac = getListaTaticas();
		
		Tatica tatica = null;
		File file = new File(DIRETORIO_TATICAS_SERIALIZE+nomeTatica+EXTENSAO_TATICAS_SERIALIZE);
		if (file.exists()){
		FileInputStream fileReader = new FileInputStream(file);
		
		ObjectInputStream reader = new ObjectInputStream(fileReader);
		tatica = (Tatica)reader.readObject();
		reader.close();
		}
	
		return tatica;
		
		/*for (Tatica lista : listaTac) {
			if (lista.getId().equals(nomeTatica))
			  return lista;
		}*/
		
       //return null;
	}
	
	
	/**
	 * Ler uma tática serializada.
	 * @param tatica Identificador da tática a ser lida
	 */
	public Tatica readTactic(String id) 
		throws FileNotFoundException, StreamCorruptedException, IOException, ClassNotFoundException{
		
		String name = this.getTacticName(id);

		Tatica tatica = null;

		FileInputStream fileReader = new FileInputStream(DIRETORIO_TATICAS_SERIALIZE+name);
				
		ObjectInputStream reader = new ObjectInputStream(fileReader);
		tatica = (Tatica)reader.readObject();
		reader.close();
	
		return tatica;
	}
	
	/**
	 * Retorna o nome da tática
	 * @param String id O Identificador da tática
	 * @param int origem
	 * @return String O Nome completo da tática
	 */
	private String getTacticName(String id) {
		if (id.indexOf(".") < 0) {
			id = id + GerenciadorTaticas.EXTENSAO_TATICAS;
		}
		id = id.replace("tex", "tac");

		return id;
	}
	
	
	public void setMapeamento(List<Pair<String, Term>> mapeamento) {
		this.mapeamento = mapeamento;
	}
	
	public List<Pair<String,Term>> getMapeamento() {
		return this.mapeamento;
	}
	
	public List<Pair<String,Pair<String,Object>>>  getListArgs() {
		return listArgs;
	}

	public  void setListArgs(List<Pair<String,Pair<String,Object>>>  listArgs) {
		this.listArgs.addAll(listArgs);
	}

	public void setLastAst(Term programaAtual) {
		this.lastAst = programaAtual;
		
	}
	
	public Term getLastAst() {
		return lastAst;
	}
	
	public static boolean isRec() {
		return rec;
	}

	public static void setRec(boolean rec) {
		GerenciadorTaticas.rec = rec;
	}
	
	/**
	 * Grava uma tática serializada.
	 * @param Tatica A tática a ser serializada
	 */
	public void writeTactic(Tatica tatica)
		throws FileNotFoundException, IOException{
		
		boolean overwrite = this.verificarTatica(tatica);

			if (overwrite){
				File oldFile = new File(DIRETORIO_TATICAS_SERIALIZE+tatica.getId()+".tac");
				oldFile.delete();
				/*File newFile = new File(DIRETORIO_TATICAS_SERIALIZE+tatica.getId()+".tac");
				FileOutputStream fileWriter = new FileOutputStream(newFile);
				ObjectOutputStream writer = new ObjectOutputStream(fileWriter);
				writer.writeObject(tatica);
				fileWriter.close();
				lista.addTactica(tatica);*/
		}
		/*else {
			
			File newFile = new File(DIRETORIO_TATICAS_SERIALIZE+tatica.getId()+".tac");
			FileOutputStream fileWriter = new FileOutputStream(newFile);
			ObjectOutputStream writer = new ObjectOutputStream(fileWriter);
			writer.writeObject(tatica);
			fileWriter.close();
			lista.addTactica(tatica);
		}*/
			File newFile = new File(DIRETORIO_TATICAS_SERIALIZE+tatica.getId()+".tac");
			FileOutputStream fileWriter = new FileOutputStream(newFile);
			ObjectOutputStream writer = new ObjectOutputStream(fileWriter);
			writer.writeObject(tatica);
			fileWriter.close();
			lista.addTactica(tatica);
			gerInterface.updateTacticList(tatica);
			//this.adicionarTatica(tatica);
			
		

	}


	
	}
