package circusRefine.Tactic.Principal;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.zpatt.ast.Sequent;
import circusRefine.core.InternalManager;
import circusRefine.core.LawAnswer;
import circusRefine.core.NoPrograma;
import circusRefine.core.crules.utils.TermFromANameGetter;
import circusRefine.core.util.POLog;
import circusRefine.util.OPTipos;
import circusRefine.util.Pair;
import circusRefine.Tactic.Excecao.*;
import circusRefine.Tactic.Util.*;


public class Tlaw extends TacticComponent{


	/**
	 * 
	 */
	private static final long serialVersionUID = 7466083807905099766L;




	public Tlaw(String nome, ArrayList<Object> argumentos) {
		law++;
		this.nome = nome;
		this.argumentos = argumentos;
	}



	public int getLaw() {
		return law;
	}

	public void setLaw(int law) {
		this.law = law;
	}


	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return null;
	}




	/**
	 * Código da Lei a ser aplicada
	 */
	public int law = 0;




	@Override
	public TacticAnswer aplicar(RCell rCell, List<Object> args,
			InternalManager gerInterno)
	throws Exception, LawNotFound {
		Vector respostaTatica = new Vector();

		CircusLaw leiSelecionada = null;

		List<Pair<String,Term>> mapeamento = gerInterno.getMapeamento();
		List<Pair<String,Pair<String,Object>>> argsList = gerInterno.getGerTaticas().getListArgs();
		Term term = null;
		TacticAnswer resposta = null;
		LawAnswer respostaLei = new LawAnswer();
		List<Pair<Pair<Sequent, Sequent>, Pair<OPTipos, POLog>>> ops =
			new ArrayList<Pair<Pair<Sequent,Sequent>,Pair<OPTipos,POLog>>>();
		List<Pair<Pair<Sequent, Sequent>, Pair<OPTipos, POLog>>> newOps =
			new ArrayList<Pair<Pair<Sequent,Sequent>,Pair<OPTipos,POLog>>>();
		boolean empty = false;


		/**
		 * Retorna a Lei que será aplicada
		 */



		leiSelecionada = gerInterno.retornarLei(this.getNome());

		/**
		 * Se leiSelecionada for null, e necessario
		 * verificar se ela esta presenta na lista de argumentos
		 */
		if (leiSelecionada == null){
			for (Pair<String,Pair<String,Object>> pair : argsList) {
				Pair<String,Object> second = (Pair<String,Object>) pair.getSecond();
				if (second.getFirst().equals(this.getNome())){
					this.setNome(second.getSecond()+"");
					leiSelecionada = gerInterno.retornarLei(this.getNome());
					break;
				}

			}
		}

		if (args != null && args.size() > 0){
			if (args.get(0) instanceof Head){
				Head head = (Head) args.get(0);
				for (Pair<String,Pair<String,Object>> pair : argsList) {
					Pair<String,Object> second = (Pair<String,Object>) pair.getSecond();
					second.setFirst(second.getFirst().trim());
					if (second.getFirst().equals(head.getList())
							&& pair.getFirst().equals("APPLYL")){
						/**
						 * Pegar a cabeça da lista
						 */

						if (GerenciadorTaticas.control==0){
							GerenciadorTaticas.control=1;
							ArrayList al = (ArrayList) second.getSecond();
							term = (Term) al.get(0);
							break;
						}
						else{
							empty=true;
							break;
						}
					}
				}
			}else if (args.get(0) instanceof Tail){
				Tail tail = (Tail) args.get(0);
				for (Pair<String,Pair<String,Object>> pair : argsList) {
					Pair<String,Object> second = (Pair<String,Object>) pair.getSecond();
					if (second.getFirst().equals(tail.getList())){
						/**
						 * Pegar o ultimo elemento da lista
						 */
						ArrayList al = (ArrayList) second.getSecond();
						term = (Term) al.get(al.size()-1);
						NoPrograma programa = new NoPrograma(term);
						rCell.setNoPrograma(programa);
						rCell.setOps(rCell.getOps());
						break;
					}
				}
			}
			else if (args.get(0) instanceof Concat){

				Concat concat =(Concat) args.get(0);
				term = gerInterno.contatenar(concat.getLeft(), concat.getRight(),mapeamento);
				NoPrograma programa = new NoPrograma(term);
				rCell.setNoPrograma(programa);

			}

		}
		if (leiSelecionada != null &&
				!empty) {


			if (this.nome.equalsIgnoreCase("MainVarState")){
				respostaLei = gerInterno.leiMainVarState(rCell.getNoPrograma().getPrograma());

			}
			else if (this.nome.equalsIgnoreCase("MainVarState2")){
				respostaLei = gerInterno.leiMainVarState2(rCell.getNoPrograma().getPrograma());
			}

			else if (this.nome.equalsIgnoreCase("Join_Blocks")){
				respostaLei   = gerInterno.leiJoinBlocks(rCell.getNoPrograma().getPrograma());

			}

			else {
				respostaLei = gerInterno.aplicarLeiTatica(rCell.getNoPrograma(), leiSelecionada, args, mapeamento);
			}


			/**
			 * Setando Obrigações de prova e noPrograma
			 */

			if (respostaLei.getProgResultante() != null){
				NoPrograma noPrograma = new NoPrograma(respostaLei.getProgResultante());
				RCell novoRCell = new RCell(noPrograma);
				if (rCell.getOps().size() > 0 && !rCell.getOps().isEmpty()){
					ops = rCell.getOps();
				}
				if (respostaLei.getOps().size() > 0 && !respostaLei.getOps().isEmpty()){
					newOps.addAll(respostaLei.getOps());
					ops.addAll(respostaLei.getOps());
				}


				novoRCell.setNoPrograma(noPrograma);
				novoRCell.setOps(ops);

				RCell rCellResposta = new RCell(novoRCell.getNoPrograma(),novoRCell.getOps());
				respostaTatica.add(rCellResposta);
				resposta = new TacticAnswer(respostaTatica);
			}
			GerenciadorTaticas.leis++;
			return resposta;

		}
		GerenciadorTaticas.leis++;
		return null;
	}


}
