package circusRefine.Tactic.Principal;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.impl.ParallelActionImpl;
import net.sourceforge.czt.circus.impl.ParallelProcessImpl;
import net.sourceforge.czt.circus.impl.PrefixingActionImpl;
import net.sourceforge.czt.circus.impl.SeqActionImpl;
import net.sourceforge.czt.circus.impl.SeqProcessImpl;
import net.sourceforge.czt.zpatt.ast.Sequent;

import circusRefine.Tactic.Excecao.*;
import circusRefine.Tactic.Util.*;
import circusRefine.core.InternalManager;
import circusRefine.core.NoPrograma;
import circusRefine.core.util.POLog;
import circusRefine.util.OPTipos;
import circusRefine.util.Pair;

public class TSemibox extends TaticaBinaria{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3086684992068004675L;

	public TSemibox(TacticComponent tacticLeft, TacticComponent tacticRight) {
		this.setTaticaEsquerda(tacticLeft);
		this.setTaticaDireita(tacticRight);
	}

	public TacticAnswer aplicar(RCell rCell, List argMap,
			InternalManager gerInterno) throws Exception,Unification  {

		Vector listAction = new Vector();
		RCell aplicar = new RCell();
		Vector respostaFinal = new Vector();
		Vector resultadoEsq = null;
		Vector resultadoDir = null;
		TacticAnswer respFinal = null;

		Vector respostas = new Vector();

		NoPrograma noProgInicial = rCell.getNoPrograma();

		List<Pair<Pair<Sequent,Sequent>,Pair<OPTipos, POLog>>> ops1 = new ArrayList<Pair<Pair<Sequent,Sequent>,Pair<OPTipos, POLog>>>();
		List<Pair<Pair<Sequent,Sequent>,Pair<OPTipos, POLog>>> ops2 = new ArrayList<Pair<Pair<Sequent,Sequent>,Pair<OPTipos, POLog>>>();

		if (noProgInicial.getPrograma() instanceof SeqActionImpl
				|| noProgInicial.getPrograma() instanceof SeqProcessImpl){
			//listAction = gerInterno.retornarListaAcoes(rCell.getNoPrograma().getPrograma());
			
			CircusAction leftAction = null, rightAction =  null;
			CircusProcess leftProc = null, rightProc = null;
			NoPrograma noProg1 = null, noProg2 = null;

			if (noProgInicial.getPrograma() instanceof SeqActionImpl){
				SeqActionImpl seq = (SeqActionImpl) noProgInicial.getPrograma();
				leftAction = seq.getLeftAction();
				rightAction = seq.getRightAction();
				noProg1 = new NoPrograma(leftAction);
				noProg2 = new NoPrograma(rightAction);
			}
			else {
				SeqProcessImpl seq = (SeqProcessImpl) noProgInicial.getPrograma();
				leftProc = seq.getLeftProcess();
				rightProc = seq.getRightProcess();
				noProg1 = new NoPrograma(leftProc);
				noProg2 = new NoPrograma(rightProc);
			}

			RCell novoRCell1 = new RCell(noProg1);

			RCell novoRCell2 = new RCell(noProg2);

			/**
			 * Recebendo o rCell da Esquerda
			 */
			if (listAction.size() >0 || listAction !=  null){
				//aplicar = (RCell) listAction.get(0);
				aplicar = new RCell(novoRCell1.getNoPrograma(), rCell.getOps());
				
				/**
				 * Aplicar a tática da Esquerda no programa da Esquerda
				 */
				TacticAnswer respApliEsq = this.getTaticaEsquerda().aplicar(aplicar, argMap, gerInterno);

				/**
				 * Recebendo o rCell da Esquerda
				 */
				//aplicar = (RCell) listAction.get(1);
				aplicar = new RCell(novoRCell2.getNoPrograma(), rCell.getOps());

				/**
				 * Aplicar a tática da Direita no programa da Direita
				 */
				TacticAnswer respApliDir = this.getTaticaDireita().aplicar(aplicar, argMap, gerInterno);

				/**
				 * Recebendo os resultados
				 */
				if (respApliEsq != null){
					resultadoEsq = respApliEsq.getRespostas();
					respostas.addElement(resultadoEsq);
				}
				if (respApliDir != null){
					resultadoDir  = respApliDir.getRespostas();
					respostas.addElement(resultadoDir);
				}

				/**
				 * Realizar o Produto Cartesiano das respostas
				 * Para isso, copiando as duas respostas para um vetor só
				 */
				Vector respProdutoCart = ListaUtil.distributedCartesianProduct(respostas);


				/**
				 * Montar a resposta
				 */

				for (int i = 0; i < respProdutoCart.size(); i++) {

					Vector parRCell = (Vector) respProdutoCart.get(i);

					/**
					 * Recebendo os RCells do par
					 */

					RCell rCell1 = (RCell) parRCell.get(0);
					RCell rCell2 = (RCell) parRCell.get(1);

					/**
					 * Verificando se existe OP´s repetidas
					 */

					if (rCell1.getOps().size() > 0)
						ops1 = rCell1.getOps();
					if (rCell2.getOps().size() > 0)
						ops2 =rCell2.getOps();

					SeqActionImpl seq = (SeqActionImpl) noProgInicial.getPrograma();
					seq.setLeftAction((CircusAction) rCell1.getNoPrograma().getPrograma());
					seq.setRightAction((CircusAction) rCell2.getNoPrograma().getPrograma());
					NoPrograma novoP = new NoPrograma(seq);
					RCell rCellSeqAction = new RCell(novoP);
					//RCell rCellSeqAction = gerInterno.montarRespostaBinaria(rCell1,rCell2,noProgInicial.getPrograma());

					if (rCell2.getOps().size() > 0 && rCell1.getOps().size() == 0){
						//ops1.addElement(ops2);
						/**
						 * Setando as OP´s
						 */
						rCellSeqAction.setOps(rCell2.getOps());
					}
					else if (rCell1.getOps().size() > 0 && rCell2.getOps().size() == 0){
						//ops1.addElement(ops2);
						/**
						 * Setando as OP´s
						 */
						rCellSeqAction.setOps(rCell1.getOps());
					}

					else if(ops1.size() != 0 || ops2.size() != 0){

						for (int j = 0; j < ops2.size(); j++){
							if (!ops1.contains(ops2.get(j))) {
								ops1.add(ops2.get(j));
							}
						}
						/**
						 * Setando as OP´s
						 */
						rCellSeqAction.setOps(ops1);
					}

					RCell rcellfinal = new RCell(rCellSeqAction.getNoPrograma(),rCellSeqAction.getOps());
					respostaFinal.addElement(rcellfinal);
				}
			}

			respFinal = new TacticAnswer(respostaFinal);

		}
		return respFinal;
	}

	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return null;
	}

}
