package circusRefine.Tactic.Principal;

import java.util.List;
import java.util.Vector;


import circusRefine.Tactic.Excecao.*;
import circusRefine.Tactic.Util.*;
import circusRefine.core.InternalManager;
import circusRefine.core.NoPrograma;

public class TIfFi extends TaticaNaria{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2178354897106045850L;

	public TIfFi(ListaTaticas tatica) {
		this.setTaticas(tatica);
	}

	@Override
	public TacticAnswer aplicar(RCell rCell, List argMap,
			InternalManager gerInterno) throws Exception, Unification  {

		Vector respostas = new Vector();
		Vector listaGuardedAction = null;

		NoPrograma programa = rCell.getNoPrograma();
		List opsIniciais  = rCell.getOps();

		/**
		 * Verificando se é um IfGuarded
		 */

		if (gerInterno.verificarPrograma(programa.getPrograma()))
			/**
			 * Método que recebe todas as GuardedAction
			 */
			listaGuardedAction = gerInterno.retornarGuardedAction(programa.getPrograma());

		else throw new LawNotFound("erro");
		int numeroTaticas = this.getTaticas().tam();

		/**
		 * Comparar a quantidade de Guards com a de táticas
		 */

		if (numeroTaticas == listaGuardedAction.size()) {

			Vector respTatica = new Vector();

			for (int i = 0; i < listaGuardedAction.size(); i++) {

				/**
				 * Pega o rCell do Vetor para poder aplicar 
				 */
				RCell rCellAplicar = (RCell) listaGuardedAction.get(i);

				TacticComponent tatica = this.getTaticas().get(i);

				/**
				 * Aplicar a tática
				 */

				TacticAnswer respostaTatica = tatica.aplicar(rCellAplicar, argMap, gerInterno);
				respTatica.addElement(respostaTatica.getRespostas());

			}

			/**
			 * Realizar o produto cartesiano dos RCells
			 */

			//Vê esse resultado 
			Vector produtoCartesiano = ListaUtil.distributedCartesianProduct(respTatica);

			/**
			 * Montar as respostas
			 */

			for (int i = 0; i < produtoCartesiano.size(); i++) {

				Vector vetorResposta = (Vector) produtoCartesiano.elementAt(i);
				//Agora tenho que chamar métodos para atualizar o programa

				//Vetor para as obrigações de prova após o Produto Cartesiano

				Vector opsDepois = new Vector();

				/**
				 * Para todos os RCell que formam a resposta
				 */
				for (int j = 0; j < vetorResposta.size(); j++) {

					RCell rCellResposta = (RCell) vetorResposta.get(i);
					NoPrograma programaFinal = rCellResposta.getNoPrograma();

					/**
					 * Vericar se existe OP´s repeditas
					 */
					List obrigacoesInterno = rCellResposta.getOps();	
					for (int k = 0; k < obrigacoesInterno.size(); k++){
						opsDepois.addElement(obrigacoesInterno.get(k));
					}
					
				
               
				List novoOps = opsIniciais;
				for (int k = 0; k < opsDepois.size(); k++){
					if (!opsIniciais.contains(opsDepois.elementAt(k))) {
						opsIniciais.add(opsDepois.elementAt(k));
					}
				}
				
				/**
				 * Criando o RCell final
				 */
				
				RCell rCellFinal = new RCell(programaFinal,novoOps);
				respostas.addElement(rCellFinal);

			}
			
		}
		}

		TacticAnswer respTatica = new TacticAnswer(respostas);
		return respTatica;

	}

	@Override
	public String toString() {

		return null;
	}
	
	
	

}
