package circusRefine.Tactic.Principal;

import java.util.List;
import java.util.Vector;

import net.sourceforge.czt.base.ast.Term;

import circusRefine.Tactic.Excecao.*;
import circusRefine.Tactic.Util.*;
import circusRefine.core.InternalManager;
import circusRefine.core.NoPrograma;

public class TGuardbox extends TaticaUnaria{

	/**
	 * 
	 */
	private static final long serialVersionUID = -2242399899904841531L;

	public TGuardbox (TacticComponent tatica) {
		this.setTactic(tatica);
	}

	@Override
	public TacticAnswer aplicar(RCell rCell, List argMap,
			InternalManager gerInterno) throws Exception, Unification  {

		NoPrograma programaInicial = rCell.getNoPrograma();
		TacticAnswer respFinal = null;

		/**
		 * Verifica se realmente é um GuardBox
		 */

		List<Term> termos = gerInterno.verificarOperador(programaInicial);

		if (termos.size() > 0){

			/**
			 * Criando um rCell para a Ação
			 */
			NoPrograma novoP = new NoPrograma(termos.get(0));
			RCell novoRcell = new RCell(novoP);

			TacticAnswer respTat = this.getTactic().aplicar(novoRcell, argMap, gerInterno);

			Vector resposta = respTat.getRespostas();

			/**
			 * Montar a resposta
			 */

			Vector resp = gerInterno.montarRespostaUnaria(termos.get(1),resposta,programaInicial.getPrograma());
			
			respFinal = new TacticAnswer(resp);
		}

		return respFinal;
	}

	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return null;
	} 
}
