package circusRefine.Tactic.Factories;

import java.util.List;

import net.sourceforge.czt.circuspatt.util.CircusLaw;
import circusRefine.Tactic.Principal.Tatica;
import circusRefine.core.InternalManager;
import circusRefine.core.crules.factories.LawType;
import circusRefine.util.Internacional;



  /**
   * Classe para todas as fábricas da táticas da ferramenta
   * @author Madiel Filho
   *
   */
public abstract class TacticsFactory {
	
	protected InternalManager gerInterno;
	
	protected String taticaSkip; 
	
	protected Internacional inter;

	public TacticsFactory(Internacional inter, InternalManager gerInt) {
		this.setInter(inter);
		gerInterno = gerInt;
		
		String temp = this.getInter().retornarMensagem("Skip");
		this.setTaticaSkip(temp);

	}


	
	
	
	public InternalManager getGerInterno() {
		return gerInterno;
	}

	public void setGerInterno(InternalManager gerInterno) {
		this.gerInterno = gerInterno;
	}

	public String getTaticaSkip() {
		return taticaSkip;
	}

	public void setTaticaSkip(String taticaSkip) {
		this.taticaSkip = taticaSkip;
	}

	public Internacional getInter() {
		return inter;
	}

	public void setInter(Internacional inter) {
		this.inter = inter;
	}
	
	
	public abstract List<Tatica> createAll();
	
	/**
	 * Retorna um nome para o tipo da lei
	 * 
	 * @param type tipo da lei
	 * @param codName o codigo do nome da lei
	 * @return o nome constru�do da lei
	 */
	protected String retornarMsg(TacticType type , String codName) {
		String name;
		name = this.getInter().retornarMensagem(codName);
		return name;
	}
}
