/*
 * Decompiled with CFR 0.152.
 */
package jcsp.lang;

import jcsp.lang.CSProcess;

public class ProcessNetwork
implements Runnable {
    private CSProcess process;
    private Thread thread;
    private ThreadGroup threadGroup;

    public ProcessNetwork(CSProcess cSProcess) {
        System.out.println("ProcessNetwork: constructor");
        this.threadGroup = new ThreadGroup("ProcessNetwork-" + cSProcess.getClass().getName());
        try {
            this.threadGroup.setDaemon(true);
            System.out.println("ProcessNetwork: setDaemon on private threadgroup");
        }
        catch (SecurityException securityException) {
            System.out.println("ProcessNetwork: could not setDaemon on private threadgroup");
            System.out.println(securityException);
        }
        this.process = cSProcess;
        try {
            this.thread = new Thread(this.threadGroup, this, cSProcess.getClass().getName());
            System.out.println("ProcessNetwork: attached thread to private threadgroup");
        }
        catch (SecurityException securityException) {
            System.out.println("ProcessNetwork: could not attach thread to private threadgroup");
            System.out.println(securityException);
            this.threadGroup = null;
            this.thread = new Thread(null, this, cSProcess.getClass().getName());
        }
        this.thread.setDaemon(true);
    }

    public void start() {
        System.out.println("ProcessNetwork: start");
        this.thread.start();
    }

    public void stop() {
        System.out.println("ProcessNetwork: stop");
        if (this.threadGroup != null) {
            this.threadGroup.stop();
        }
        this.threadGroup = null;
    }

    public void suspend() {
        System.out.println("ProcessNetwork: suspend");
        if (this.threadGroup != null) {
            this.threadGroup.suspend();
        }
    }

    public void resume() {
        System.out.println("ProcessNetwork: resume");
        if (this.threadGroup != null) {
            this.threadGroup.resume();
        }
    }

    public void join() {
        System.out.println("ProcessNetwork: join");
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        System.out.println("ProcessNetwork: run");
        this.process.run();
    }
}

