/*
 * Decompiled with CFR 0.152.
 */
package jcsp.lang;

import java.io.Serializable;
import jcsp.lang.ProcessInterruptedError;

public class Barrier
implements Serializable {
    private int nEnrolled = 0;
    private int countDown = 0;

    public Barrier() {
    }

    public Barrier(int n) {
        this.nEnrolled = n;
        this.countDown = n;
    }

    public synchronized void reset(int n) {
        this.nEnrolled = n;
        this.countDown = n;
    }

    public synchronized void sync() {
        --this.countDown;
        if (this.countDown > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new ProcessInterruptedError("*** Thrown from Barrier.sync ()\n" + interruptedException.toString());
            }
        } else {
            this.countDown = this.nEnrolled;
            this.notifyAll();
        }
    }

    public synchronized void enroll() {
        ++this.nEnrolled;
        ++this.countDown;
    }

    public synchronized void resign() {
        --this.nEnrolled;
        --this.countDown;
        if (this.countDown <= 0) {
            this.countDown = this.nEnrolled;
            this.notifyAll();
        }
    }
}

