/*
 * Decompiled with CFR 0.152.
 */
package jcsp.util.ints;

import java.io.Serializable;
import jcsp.util.ints.BufferIntSizeError;
import jcsp.util.ints.ChannelDataStoreInt;

public class BufferInt
implements ChannelDataStoreInt,
Serializable {
    private final int[] buffer;
    private int counter = 0;
    private int firstIndex = 0;
    private int lastIndex = 0;

    public BufferInt(int n) {
        if (n < 0) {
            throw new BufferIntSizeError("\n*** Attempt to create a buffered channel with negative capacity");
        }
        this.buffer = new int[n + 1];
    }

    public int get() {
        int n = this.buffer[this.firstIndex];
        this.firstIndex = (this.firstIndex + 1) % this.buffer.length;
        --this.counter;
        return n;
    }

    public void put(int n) {
        this.buffer[this.lastIndex] = n;
        this.lastIndex = (this.lastIndex + 1) % this.buffer.length;
        ++this.counter;
    }

    public int getState() {
        if (this.counter == 0) {
            return 0;
        }
        if (this.counter == this.buffer.length) {
            return 2;
        }
        return 1;
    }

    public Object clone() {
        return new BufferInt(this.buffer.length - 1);
    }
}

