/*
 * Decompiled with CFR 0.152.
 */
package jcsp.lang;

import java.io.PrintStream;
import jcsp.lang.Barrier;
import jcsp.lang.CSProcess;
import jcsp.lang.Parallel;

class ParThread
extends Thread {
    private CSProcess process;
    private Barrier barrier;
    private boolean running = true;
    Barrier park = new Barrier(2);

    ParThread(CSProcess cSProcess, Barrier barrier) {
        this.setDaemon(true);
        Parallel.allParThreads.addElement(this);
        this.process = cSProcess;
        this.barrier = barrier;
    }

    public void reset(CSProcess cSProcess, Barrier barrier) {
        this.process = cSProcess;
        this.barrier = barrier;
    }

    public void terminate() {
        this.running = false;
    }

    public void run() {
        while (this.running) {
            try {
                this.process.run();
            }
            catch (Exception exception) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.println("\n*** jcsp.lang.Parallel - a process threw the following exception:");
                    exception.printStackTrace();
                }
            }
            this.barrier.resign();
            this.park.sync();
        }
    }
}

