/*
 * Decompiled with CFR 0.152.
 */
package jcsp.lang;

import java.io.Serializable;
import jcsp.lang.Alternative;
import jcsp.lang.AltingChannelInput;
import jcsp.lang.ChannelOutput;
import jcsp.lang.One2OneChannelX;
import jcsp.lang.ProcessInterruptedError;
import jcsp.util.ChannelDataStore;

public class One2OneChannel
extends AltingChannelInput
implements ChannelOutput,
Serializable {
    protected Object rwMonitor = new Object();
    private Object hold;
    private boolean empty = true;
    protected Alternative alt;

    public Object read() {
        Object object = this.rwMonitor;
        synchronized (object) {
            if (this.empty) {
                this.empty = false;
                try {
                    this.rwMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new ProcessInterruptedError("*** Thrown from One2OneChannel.read ()\n" + interruptedException.toString());
                }
            } else {
                this.empty = true;
            }
            this.rwMonitor.notify();
            Object object2 = this.hold;
            return object2;
        }
    }

    public void write(Object object) {
        Object object2 = this.rwMonitor;
        synchronized (object2) {
            this.hold = object;
            if (this.empty) {
                this.empty = false;
                if (this.alt != null) {
                    this.alt.schedule();
                }
            } else {
                this.empty = true;
                this.rwMonitor.notify();
            }
            try {
                this.rwMonitor.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new ProcessInterruptedError("*** Thrown from One2OneChannel.write (Object)\n" + interruptedException.toString());
            }
        }
    }

    boolean enable(Alternative alternative) {
        Object object = this.rwMonitor;
        synchronized (object) {
            if (this.empty) {
                this.alt = alternative;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    boolean disable() {
        Object object = this.rwMonitor;
        synchronized (object) {
            this.alt = null;
            boolean bl = !this.empty;
            return bl;
        }
    }

    public boolean pending() {
        Object object = this.rwMonitor;
        synchronized (object) {
            boolean bl = !this.empty;
            return bl;
        }
    }

    public static One2OneChannel[] create(int n) {
        One2OneChannel[] one2OneChannelArray = new One2OneChannel[n];
        int n2 = 0;
        while (n2 < n) {
            one2OneChannelArray[n2] = new One2OneChannel();
            ++n2;
        }
        return one2OneChannelArray;
    }

    public static One2OneChannel create(ChannelDataStore channelDataStore) {
        return new One2OneChannelX(channelDataStore);
    }

    public static One2OneChannel[] create(int n, ChannelDataStore channelDataStore) {
        One2OneChannel[] one2OneChannelArray = new One2OneChannel[n];
        int n2 = 0;
        while (n2 < n) {
            one2OneChannelArray[n2] = new One2OneChannelX(channelDataStore);
            ++n2;
        }
        return one2OneChannelArray;
    }
}

