/*
 * Decompiled with CFR 0.152.
 */
package jcsp.util.ints;

import java.io.Serializable;
import jcsp.util.ints.BufferIntSizeError;
import jcsp.util.ints.ChannelDataStoreInt;

public class InfiniteBufferInt
implements ChannelDataStoreInt,
Serializable {
    private static final int DEFAULT_SIZE = 8;
    private int initialSize;
    private int[] buffer;
    private int counter = 0;
    private int firstIndex = 0;
    private int lastIndex = 0;

    public InfiniteBufferInt() {
        this(8);
    }

    public InfiniteBufferInt(int n) {
        if (n <= 0) {
            throw new BufferIntSizeError("\n*** Attempt to create a buffered channel with an initially negative or zero capacity");
        }
        this.initialSize = n;
        this.buffer = new int[n];
    }

    public int get() {
        int n = this.buffer[this.firstIndex];
        this.firstIndex = (this.firstIndex + 1) % this.buffer.length;
        --this.counter;
        return n;
    }

    public void put(int n) {
        if (this.counter == this.buffer.length) {
            int[] nArray = this.buffer;
            this.buffer = new int[this.buffer.length * 2];
            System.arraycopy(nArray, this.firstIndex, this.buffer, 0, nArray.length - this.firstIndex);
            System.arraycopy(nArray, 0, this.buffer, nArray.length - this.firstIndex, this.firstIndex);
            this.firstIndex = 0;
            this.lastIndex = nArray.length;
        }
        this.buffer[this.lastIndex] = n;
        this.lastIndex = (this.lastIndex + 1) % this.buffer.length;
        ++this.counter;
    }

    public int getState() {
        if (this.counter == 0) {
            return 0;
        }
        return 1;
    }

    public Object clone() {
        return new InfiniteBufferInt(this.initialSize);
    }
}

