package circparser.grammar;

import java_cup.runtime.*;
import circparser.grammar.table.*;


class ListSymbol
{
	private Symbol value;
	private ListSymbol prox;
	
	void insert (Symbol val)
	{
		if(this.value == null)
		{
			this.value = val;
			prox = new ListSymbol();
		}
		else
			prox.insert(val);
	}

	Symbol delete ()
	{
		if (this.value == null)
		{
			return null;
		}
		else
		{	
			Symbol head = this.value;
			this.value = prox.value;
			this.prox = prox.prox;
			return head;
		}	
	}

}	
	
  
%%  

%type Symbol

%eofval{
  return new Symbol(sym.EOF, null);
%eofval}


%{
  public String sourceFilename;
  public Map OpTable;
  private ListSymbol list= new ListSymbol();
  private static final int REL = 1;
  private final int FUNGEN = 2;
  private int optype = 0; 
  private boolean ws;
  private boolean hardSpace; // indica se o SPACE eh hard
  private final int InitState = 0;
  private final int CircState = 1;  
  private final int CircState2 = 2;   
  private int state_before;// Zero indica Yyinitial e 1  CircParser 
  private TokenValue nt;
  private boolean return_circus;
  
  public String getYytext() {
     return this.yytext();
  }

  public int getYyline() {
     return this.yyline;
  }  	

%}

%init{
	OpTable = new Map();
	ws = false;
	return_circus = true;
	
%init}

%yylexthrow{
	OperatorDeclaredException
%yylexthrow}


%full
%line
%public

%state CIRCPARSER, TEMPLATE

DIGIT=[0-9]
LETTER=({GREEK}|{LATIN}|{OTHERLETTER})
LATIN=[A-Za-z]
GREEK="\Delta"|"\Xi"|"\lambda"|"\theta"|"\mu"
OTHERLETTER="\arithmos"|"\nat"|"\num"|"\emptyset"|"\nat_1"
STROKECHAR=['!\?]
WORDGLUE=("\_")
BRACKET="("|")"|"["|"]"|"{"|"}"|"\lblot"|"\rblot"|"\ldata"|"\rdata"
SYMBOL=\||"&"|"\vdash"|"\land"|"\lor"|"\implies"|"\iff"|"\lnot"|"\forall"|"\exists"|"\power"|"/"|"="|"\in"|":"|";"|","|"."|"@"|"\hide"|"\project"|"\semi"|"\pipe"|"+"|\|"\exists_1"
NUMBER=({DIGIT})+
STROKE=({STROKECHAR}|("_"{DIGIT}))
NAME=({WORD}({STROKE})*)
WORD=(({WORDPART}|({LETTER}{ALPHASTR}|{SYMBOL}{SYMBOLSTR}))({WORDPART})*)
WORDPART=({WORDGLUE}({ALPHASTR}|{SYMBOLSTR})) 
ALPHASTR=({LETTER}|{DIGIT})*
SYMBOLSTR=({SYMBOL})*
WHITE_SPACE=([\ \n\r\t\f])+
SPACE="~"|"\t1"|"\t2"|"\t3"|"\t4"|"\t5"|"\t6"|"\t7"|"\t8"|"\t9"|"\,"|"\:"|"\;"|"\begin{block}"|"\end{block}"|\\|"%"
NLSTRING="\also"|\\\\|"\znewpage" 
I="\fun"|"\cup"|"\cap"|"\setminus"|"\symdiff"|\+|"\mapsto"|"\rel"|"\bigcup"|"\bigcap"|"\comp"|"\circ"|"\dres"|"\rres"|"\ndres"|"\nrres"|"\oplus"|"\pfun"|"\pinj"|"\inj"|"\psurj"|"\surj"|"\bij"|"\ffun"|"\finj"|"-"|"\times"|"\div"|"\mod"|"\upto"|"\cat"|"\extract"|"\filter"
IP="\in"|"\notin"|"="|"\neq"|"\subseteq"|"\subset"|"\partition"|"\leq"|"\geq"|"<"|">"|"\prefix"|"\su"|"ffix"|"\inseq"
PRE="first"|"second"|"\power"|"\dom"|"\ran"|"\finset"|"\id"|"\negate"|"items"|"succ"|"iter"|"\seq"|"\iseq"|"rev"|"head"|"tail"|"last"|"front"|"squash"|"\dcat"|"\power_1"|"\finset_1"|"min"|"max"|"\seq_1" 
PREP="\disjoint"|"\#"
POST="\inv"|"\star"|"\plus"
EL="\limg"
ER="\rimg"
L="\langle"
SR="\rangle"
ARROW="_{"|"^{"|"^"|"_"





%%  

<YYINITIAL> "\begin{schema}" { 
   state_before = InitState;
   yybegin(CIRCPARSER);  
   ws = false; 
   hardSpace = false;
   return new Symbol(sym.INIS, new TokenValue(yytext(), yyline, ws,hardSpace));
}
<YYINITIAL> "\begin{axdef}" { 
  state_before = InitState;
  ws = false; 
  hardSpace = false;
  yybegin(CIRCPARSER);  
  return new Symbol(sym.INIA, new TokenValue(yytext(), yyline, ws,hardSpace));
}
<YYINITIAL> "\begin{gendef}" { 
  state_before = InitState;
  ws = false; 
  hardSpace = false;
  yybegin(CIRCPARSER);
  return new Symbol(sym.INIAG, new TokenValue(yytext(), yyline, ws,hardSpace));
}

<YYINITIAL> "\begin{zed}" { 
  state_before = InitState;
  yybegin(CIRCPARSER);
  ws = false; 
  hardSpace = false; 
  return new Symbol(sym.INIG, new TokenValue(yytext(), yyline, ws,hardSpace));
}
<YYINITIAL> "\begin{circus}" { 
  state_before = CircState;
  ws = false; 
  hardSpace = false; 
  yybegin(CIRCPARSER);  
//  if(return_circus) {
      return new Symbol(sym.INICIRC, new TokenValue(yytext(), yyline, ws,hardSpace));
//  }
}

<YYINITIAL> [\n] {
}

<YYINITIAL> . {
}

<CIRCPARSER> "\cup" { 
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CUP, nt);
}
<CIRCPARSER> "\cap" { 
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CAP, nt);
}
<CIRCPARSER> "\setminus" { 
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.SETMIM, nt);
}

<CIRCPARSER> {I} { 
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ITOK, nt);
}
<CIRCPARSER> {IP} { 
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.IPTOK, nt);
}
<CIRCPARSER> {PRE} {
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.PRETOK, nt);
}
<CIRCPARSER> {PREP} {
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.PREPTOK, nt);
}
<CIRCPARSER> {POST} {
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.POSTTOK, nt);
}
<CIRCPARSER> {EL} {
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ELTOK, nt);
}
<CIRCPARSER> {ER} {
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ERTOK, nt);
}
<CIRCPARSER> {L} {
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.LTOK, nt);
}
<CIRCPARSER> {SR} {
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.SRTOK, nt);
}
<CIRCPARSER> "\ELSE" { 
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ELSE_KEYWORD, nt);
}
<CIRCPARSER> "\false" { 
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.TFALSE, nt);
}
<CIRCPARSER> "\function" {
      	
  	optype = FUNGEN;
      	yybegin(TEMPLATE);
	return new Symbol(sym.FUNCTION, nt); 
}
<CIRCPARSER> "\generic" {

  	optype = FUNGEN;
	yybegin(TEMPLATE); 
  	return new Symbol(sym.GENERIC, nt);
}
<CIRCPARSER> "\IF" { 
  nt = new TokenValue(yytext(), yyline, ws);
  ws = false;
  hardSpace = false;
  return new Symbol(sym.IF_KEYWORD, nt);
}

<CIRCPARSER> "\LET" { 
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.LET, nt);
}
<CIRCPARSER> "\pre" { 
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ZPRE, nt);
}
<CIRCPARSER> "\relation" {

  	optype = REL;
	yybegin(TEMPLATE); 
  	return new Symbol(sym.RELATION, new TokenValue(yytext(), yyline));
}
<CIRCPARSER> "\THEN" { 
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.THEN_KEYWORD, nt);
}
<CIRCPARSER> "\true" { 
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.TTRUE, nt);
}
<CIRCPARSER> {WHITE_SPACE} {    
  ws = true; 
  hardSpace=false;
  }
<CIRCPARSER> {SPACE} { 
  ws = true;
  hardSpace = true;
  }
<CIRCPARSER> "." { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.POINT, nt); 
}
<CIRCPARSER> ":=" {
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ATRIB, nt); 
} 
<CIRCPARSER> "::=" {
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.DDEF, nt); 
} 
<CIRCPARSER> "!" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.EXCL, nt); 
} 
<CIRCPARSER> "?" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.INTER, nt); 
} 
<CIRCPARSER> {STROKE} { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.STROKE, nt); 
} 
<CIRCPARSER> "\lambda" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.LAMBDA, nt);
}
<CIRCPARSER> "\theta" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.THETA, nt);
}
<CIRCPARSER> "\mu" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.MU, nt);
}
<CIRCPARSER> "|" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.BAR, nt);
}
<CIRCPARSER> "&" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.AND, nt);
}
<CIRCPARSER> \\\{ {
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.LKEY, nt);
}
<CIRCPARSER> \\\} { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.RKEY, nt);
}
<CIRCPARSER> "\lchanset" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.LCHST, nt);
}
<CIRCPARSER> "\rchanset" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.RCHST, nt);
}

<CIRCPARSER> "\_" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.UND, nt);
}
<CIRCPARSER> "\end{schema}" { 
   yybegin(YYINITIAL);
   nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  	
  return new Symbol(sym.ENDS, new TokenValue(yytext(), yyline ));
}
<CIRCPARSER> "\end{axdef}" { 
  yybegin(YYINITIAL);
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
  ws = false; 
  hardSpace = false; 
  return new Symbol(sym.ENDA, new TokenValue(yytext(), yyline ));
}
<CIRCPARSER> "\end{gendef}" { 
  yybegin(YYINITIAL);
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
  ws = false; 
  hardSpace = false; 
  return new Symbol(sym.ENDAG, nt);
}

<CIRCPARSER> "\end{zed}" { 
  yybegin(YYINITIAL);
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
  ws = false; 
  hardSpace = false; 
  return new Symbol(sym.ENDG, nt);
}
<CIRCPARSER> "\end{circus}" { 
  yybegin(YYINITIAL);
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
  ws = false; 
  hardSpace = false;
//  if (return_circus) {
      return new Symbol(sym.ENDCIRC, nt);
//  }
}
<CIRCPARSER> "[" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.LBRACT, nt);
}
<CIRCPARSER> "]" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.RBRACT, nt);
}
<CIRCPARSER> "\ldata" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.OPANG, nt);
}
<CIRCPARSER> "\rdata" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CLANG, nt);
}
<CIRCPARSER> "\lblot" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.OPBIND, nt);
}
<CIRCPARSER> "\rblot" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CLBIND, nt);
}
<CIRCPARSER> "\vdash" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.THRM, nt);
}
<CIRCPARSER> "\circprocess" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.PRO, nt);
}
<CIRCPARSER> "\circbegin" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
   return_circus = false;
  return new Symbol(sym.CBEG, nt);
}
<CIRCPARSER> "\circend" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
   return_circus = true;
  return new Symbol(sym.CEND, nt);
}
<CIRCPARSER> "\circchannel" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CHAN, nt);
}
<CIRCPARSER> "\circchanset" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CHANST, nt);
}
<CIRCPARSER> "\circcon" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CCON, nt);
}
<CIRCPARSER> "\circvar" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CVAR, nt);
}

<CIRCPARSER> "\circstate" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
  ws = false; 
  hardSpace = false; 
  System.out.println("circstate");
  return new Symbol(sym.STATE, nt);
}
<CIRCPARSER> "Skip" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.SKIP, nt);
}
<CIRCPARSER> "Stop" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.STOP, nt);
}
<CIRCPARSER> "Chaos" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CHAOS, nt);
}

<CIRCPARSER> "\then" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CTHEN, nt);
}
<CIRCPARSER> "\guard" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CGUARD, nt);
}
<CIRCPARSER> "\extchoice" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false;
    hardSpace = false; 
  return new Symbol(sym.EXTCH, nt);
}
<CIRCPARSER> "\intchoice" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.INTCH, nt);
}
<CIRCPARSER> "\lpar" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.LPAR, nt);
}
<CIRCPARSER> "\rpar" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.RPAR, nt);
}
<CIRCPARSER> "\linter" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.LINTLV, nt);
}
<CIRCPARSER> "\rinter" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.RINTLV, nt);
}
<CIRCPARSER> "\interleave" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.INTLV, nt);
}
<CIRCPARSER> "\circmu" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CMU, nt);
}
<CIRCPARSER> "\Semi" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CSEMI, nt);
}
<CIRCPARSER> "\Extchoice" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CEXTCH, nt);
}
<CIRCPARSER> "\Intchoice" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CINTCH, nt);
}
<CIRCPARSER> "\Parallel" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CPAR, nt);
}
<CIRCPARSER> "\Interleave" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CINTLV, nt);
}
<CIRCPARSER> ";" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.SEMI, nt);
}
<CIRCPARSER> {NLSTRING} { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
 return new Symbol(sym.SEP, nt);
  		
}
<CIRCPARSER> ":" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.TWOP, nt);
}
<CIRCPARSER> "(" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.LPAREN, nt);
}
<CIRCPARSER> ")" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.RPAREN, nt);
}
<CIRCPARSER> "\iff" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false;
   hardSpace = false; 
  return new Symbol(sym.IFF, nt);
}
<CIRCPARSER> "\implies" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.IMP, nt);
}
<CIRCPARSER> "\lor" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.OR, nt);
}
<CIRCPARSER> "\land" {
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.AND2, nt);
}
<CIRCPARSER> "\lnot" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.NOT, nt);
}
<CIRCPARSER> "\semi" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ZFRC, nt);
}
<CIRCPARSER> "\pipe" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ZPIPE, nt);
}
<CIRCPARSER> "\hide" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ZHIDE, nt);
}
<CIRCPARSER> "\project" {
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false;
   hardSpace = false; 
  return new Symbol(sym.ZPROJ, nt);
}

<CIRCPARSER> "\cross" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.MEM, nt);
}
<CIRCPARSER> "\lambda" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.LAMBDA, nt);
}
<CIRCPARSER> "\mu" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.MU, nt);
}
<CIRCPARSER> "\circif" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CIF, nt);
}
<CIRCPARSER> "\circfi" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CFI, nt);
}
<CIRCPARSER> "\circthen" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CCTHEN, nt);
}
<CIRCPARSER> "\circelse" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CELSE, nt);
}
<CIRCPARSER> "\odot" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ODOT, nt);
}
<CIRCPARSER> "\lfloor" {
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.LFL, nt);
}
<CIRCPARSER> "\rfloor" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.RFL, nt);
}
<CIRCPARSER> "@" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.SPOT, nt);
}
<CIRCPARSER> "==" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.TDEF, nt);
}
<CIRCPARSER> "\defs" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.CDEF, nt);
}
<CIRCPARSER> "/" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.DIV, nt);
}
<CIRCPARSER> "," { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
    return new Symbol(sym.COMMA, nt);

}
<CIRCPARSER> "\exists" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.EXI, nt);
}
<CIRCPARSER> "\exists_1" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.EXI1, nt);
}
<CIRCPARSER> "\forall" {
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ALL, nt);
}
<CIRCPARSER> "\where" {
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.TWHERE, nt);
}


<CIRCPARSER> "{" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.KEYL, nt);
}
<CIRCPARSER> "}" { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.KEYR, nt);
}
<CIRCPARSER> {NUMBER} { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.NATURAL, nt);
}
<CIRCPARSER> "\listarg" {
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ELLIPSIS, nt); 
}
<CIRCPARSER> {ARROW} {
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.ARW, nt);
}
<CIRCPARSER> (((\\)?){NAME}) { 
  nt = new TokenValue(yytext(), yyline, ws,hardSpace);
   ws = false; 
   hardSpace = false; 
  return new Symbol(sym.IDENT, nt); 
}
<CIRCPARSER> . {
	  return new Symbol(sym.error, nt); 
} 

<TEMPLATE> "\_" {
  	Symbol val = new Symbol(sym.UND, new TokenValue(yytext(), yyline));
	list.insert(val);
	return val;
}
<TEMPLATE> {WHITE_SPACE} {}
<TEMPLATE> "(" { 
  Symbol val = new Symbol(sym.LPAREN, new TokenValue(yytext(), yyline));
  return val;
}
<TEMPLATE> ")" { 
  Symbol val = new Symbol(sym.RPAREN, new TokenValue(yytext(), yyline));
  list.insert(val);
  return val;
}
<TEMPLATE> "\rightassoc" { 
  Symbol val = new Symbol(sym.RIGHTASSOC, new TokenValue(yytext(), yyline));
  return val;
}
<TEMPLATE> "\leftassoc" { 
  Symbol val = new Symbol(sym.LEFTASSOC, new TokenValue(yytext(), yyline));
  return val; 
}
<TEMPLATE> "\end{zed}" { 
  if ( state_before == InitState)
  	yybegin(YYINITIAL);
  return new Symbol(sym.ENDG, new TokenValue(yytext(), yyline));
}

<TEMPLATE> "\listarg" { 
  Symbol val = new Symbol(sym.ELLIPSIS, new TokenValue(yytext(), yyline));
  list.insert(val);
  return val;
}
<TEMPLATE> {NUMBER} { 
  Symbol val = new Symbol(sym.NATURAL, new TokenValue(yytext(), yyline)); 
  return val;
}

<TEMPLATE> {NAME} {
  Symbol val = new Symbol(sym.IDENT, new TokenValue(yytext(), yyline));
  list.insert(val);
  return val; 
}
<TEMPLATE> . {
	return new Symbol(sym.error, new TokenValue(yytext(), yyline)); 
}



